/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionManager;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.Base64;
import org.modeshape.jcr.api.ValueFactory;
import org.modeshape.web.jcr.rest.RestHelper;
import org.modeshape.web.jcr.rest.handler.AbstractHandler;
import org.modeshape.web.jcr.rest.handler.ItemHandler;
import org.wisdom.api.content.Json;
import org.wisdom.api.http.Request;

@Immutable
public abstract class ItemHandlerImpl
extends AbstractHandler
implements ItemHandler {
    protected static final String CHILD_NODE_HOLDER = "children";
    private static final String PRIMARY_TYPE_PROPERTY = "jcr:primaryType";
    private static final String MIXIN_TYPES_PROPERTY = "jcr:mixinTypes";
    private static final String PROPERTIES_HOLDER = "properties";

    protected Node addNode(Node parentNode, String nodeName, JsonNode jsonNode) throws RepositoryException {
        Node newNode;
        JsonNode properties = this.getProperties(jsonNode);
        if (properties.has(PRIMARY_TYPE_PROPERTY)) {
            String primaryType = properties.get(PRIMARY_TYPE_PROPERTY).asText();
            newNode = parentNode.addNode(nodeName, primaryType);
        } else {
            newNode = parentNode.addNode(nodeName);
        }
        if (properties.has(MIXIN_TYPES_PROPERTY)) {
            this.updateMixins(newNode, properties.get(MIXIN_TYPES_PROPERTY));
        }
        Iterator iter = properties.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (PRIMARY_TYPE_PROPERTY.equals(key) || MIXIN_TYPES_PROPERTY.equals(key)) continue;
            this.setPropertyOnNode(newNode, key, properties.get(key));
        }
        if (this.hasChildren(jsonNode)) {
            List<JSONChild> children = this.getChildren(jsonNode);
            for (JSONChild child : children) {
                this.addNode(newNode, child.getName(), child.getBody());
            }
        }
        return newNode;
    }

    protected List<JSONChild> getChildren(JsonNode jsonNode) {
        JsonNode childrenNode = jsonNode.get(CHILD_NODE_HOLDER);
        if (childrenNode instanceof ObjectNode) {
            ObjectNode childrenObject = (ObjectNode)childrenNode;
            ArrayList<JSONChild> children = new ArrayList<JSONChild>(childrenObject.size());
            Iterator iterator = childrenObject.fields();
            while (iterator.hasNext()) {
                String childName = iterator.next().toString();
                children.add(new JSONChild(childName, childrenObject.get(childName), 1));
            }
            return children;
        }
        ArrayNode childrenArray = (ArrayNode)childrenNode;
        ArrayList<JSONChild> children = new ArrayList<JSONChild>(childrenArray.size());
        HashMap<String, Integer> visitedNames = new HashMap<String, Integer>(childrenArray.size());
        for (int i = 0; i < childrenArray.size(); ++i) {
            String childName;
            JsonNode child = childrenArray.get(i);
            if (child.size() == 0) continue;
            if (child.size() > 1) {
                this.logger.warn("The child object {0} has more than 1 elements, only the first one will be taken into account", (Object)child);
            }
            int sns = visitedNames.containsKey(childName = ((Map.Entry)child.fields().next()).toString()) ? (Integer)visitedNames.get(childName) + 1 : 1;
            visitedNames.put(childName, sns);
            children.add(new JSONChild(childName, child.get(childName), sns));
        }
        return children;
    }

    protected abstract Json getJson();

    protected boolean hasChildren(JsonNode jsonNode) {
        return jsonNode.has(CHILD_NODE_HOLDER);
    }

    protected JsonNode getProperties(JsonNode jsonNode) {
        return jsonNode.has(PROPERTIES_HOLDER) ? jsonNode.get(PROPERTIES_HOLDER) : this.getJson().newObject();
    }

    private Value createBinaryValue(String base64EncodedValue, javax.jcr.ValueFactory valueFactory) throws RepositoryException {
        InputStream stream = null;
        try {
            byte[] binaryValue = Base64.decode((String)base64EncodedValue);
            stream = new ByteArrayInputStream(binaryValue);
            Binary binary = valueFactory.createBinary(stream);
            Value value = valueFactory.createValue(binary);
            return value;
        }
        catch (IOException ioe) {
            throw new RepositoryException((Throwable)ioe);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                this.logger.debug("Error while closing binary stream", (Throwable)e);
            }
        }
    }

    protected void setPropertyOnNode(Node node, String propName, Object value) throws RepositoryException {
        Object values;
        boolean encoded = propName.endsWith("/base64/");
        if (encoded) {
            int newLength = propName.length() - "/base64/".length();
            String string = propName = newLength > 0 ? propName.substring(0, newLength) : "";
        }
        if ((values = this.convertToJcrValues(node, value, encoded)) == null) {
            node.setProperty(propName, (Value)null);
        } else if (values instanceof Value) {
            node.setProperty(propName, (Value)values);
        } else {
            node.setProperty(propName, (Value[])values);
        }
    }

    private Set<String> updateMixins(Node node, Object mixinsJsonValue) throws RepositoryException {
        Object valuesObject = this.convertToJcrValues(node, mixinsJsonValue, false);
        Value[] values = null;
        values = valuesObject == null ? new Value[]{} : (valuesObject instanceof Value[] ? (Value[])valuesObject : new Value[]{(Value)valuesObject});
        HashSet<String> jsonMixins = new HashSet<String>(values.length);
        for (Value theValue : values) {
            jsonMixins.add(theValue.getString());
        }
        HashSet<String> mixinsToRemove = new HashSet<String>();
        for (NodeType nodeType : node.getMixinNodeTypes()) {
            mixinsToRemove.add(nodeType.getName());
        }
        HashSet mixinsToAdd = new HashSet(jsonMixins);
        mixinsToAdd.removeAll(mixinsToRemove);
        mixinsToRemove.removeAll(jsonMixins);
        for (String nodeType : mixinsToAdd) {
            node.addMixin(nodeType);
        }
        return mixinsToRemove;
    }

    private Object convertToJcrValues(Node node, Object value, boolean encoded) throws RepositoryException {
        if (value == NullNode.getInstance() || value instanceof ArrayNode && ((ArrayNode)value).size() == 0) {
            return null;
        }
        ValueFactory valueFactory = (ValueFactory)node.getSession().getValueFactory();
        if (value instanceof ArrayNode) {
            ArrayNode jsonValues = (ArrayNode)value;
            Value[] values = new Value[jsonValues.size()];
            for (int i = 0; i < jsonValues.size(); ++i) {
                values[i] = encoded ? this.createBinaryValue(jsonValues.get(i).asText(), (javax.jcr.ValueFactory)valueFactory) : RestHelper.jsonValueToJCRValue(jsonValues.get(i), valueFactory);
            }
            return values;
        }
        return encoded ? this.createBinaryValue(value.toString(), (javax.jcr.ValueFactory)valueFactory) : RestHelper.jsonValueToJCRValue(value, valueFactory);
    }

    @Override
    public void deleteItem(Request request, String rawRepositoryName, String rawWorkspaceName, String path) throws RepositoryException {
        assert (rawRepositoryName != null);
        assert (rawWorkspaceName != null);
        assert (path != null);
        Session session = this.getSession(request, rawRepositoryName, rawWorkspaceName);
        this.doDelete(path, session);
        session.save();
    }

    protected void doDelete(String path, Session session) throws RepositoryException {
        Item item = session.getItem(path);
        item.remove();
    }

    protected Item updateItem(Item item, JsonNode jsonItem) throws RepositoryException {
        if (item instanceof Node) {
            return this.updateNode((Node)item, jsonItem);
        }
        return this.updateProperty((Property)item, jsonItem);
    }

    private Property updateProperty(Property property, JsonNode jsonItem) throws RepositoryException {
        String propertyName = property.getName();
        String jsonPropertyName = jsonItem.has(propertyName) ? propertyName : propertyName + "/base64/";
        Node node = property.getParent();
        this.setPropertyOnNode(node, jsonPropertyName, jsonItem.get(jsonPropertyName));
        return property;
    }

    protected Node updateNode(Node node, JsonNode jsonItem) throws RepositoryException {
        VersionableChanges changes = new VersionableChanges(node.getSession());
        try {
            node = this.updateNode(node, jsonItem, changes);
            changes.checkin();
        }
        catch (RuntimeException | RepositoryException e) {
            changes.abort();
            throw e;
        }
        return node;
    }

    protected Node updateNode(Node node, JsonNode jsonNode, VersionableChanges changes) throws RepositoryException {
        JsonNode properties = jsonNode;
        if (jsonNode.has(PROPERTIES_HOLDER)) {
            properties = jsonNode.get(PROPERTIES_HOLDER);
        }
        changes.checkout(node);
        if (properties.has(PRIMARY_TYPE_PROPERTY)) {
            String primaryType = properties.get(PRIMARY_TYPE_PROPERTY).asText();
            if ((primaryType = primaryType.trim()).length() != 0 && !node.getPrimaryNodeType().getName().equals(primaryType)) {
                node.setPrimaryType(primaryType);
            }
        }
        Set<Object> mixinsToRemove = new HashSet();
        if (properties.has(MIXIN_TYPES_PROPERTY)) {
            mixinsToRemove = this.updateMixins(node, properties.get(MIXIN_TYPES_PROPERTY));
        }
        Iterator iter = properties.fieldNames();
        while (iter.hasNext()) {
            String string = (String)iter.next();
            if (PRIMARY_TYPE_PROPERTY.equals(string) || MIXIN_TYPES_PROPERTY.equals(string) || CHILD_NODE_HOLDER.equals(string)) continue;
            this.setPropertyOnNode(node, string, properties.get(string));
        }
        if (this.hasChildren(jsonNode)) {
            this.updateChildren(node, jsonNode, changes);
        }
        for (String string : mixinsToRemove) {
            node.removeMixin(string);
        }
        return node;
    }

    private void updateChildren(Node node, JsonNode jsonNode, VersionableChanges changes) throws RepositoryException {
        Session session = node.getSession();
        LinkedHashMap<String, Node> existingChildNames = new LinkedHashMap<String, Node>();
        ArrayList<String> existingChildrenToUpdate = new ArrayList<String>();
        NodeIterator childIter = node.getNodes();
        while (childIter.hasNext()) {
            Node child = childIter.nextNode();
            String childName = this.nameOf(child);
            existingChildNames.put(childName, child);
            existingChildrenToUpdate.add(childName);
        }
        ArrayList<String> newChildrenToUpdate = new ArrayList<String>();
        List<JSONChild> children = this.getChildren(jsonNode);
        for (JSONChild jsonChild : children) {
            String childNodeName;
            Node childNode;
            String childName = jsonChild.getNameWithSNS();
            JsonNode child = jsonChild.getBody();
            if (node.hasNode(childName)) {
                childNode = node.getNode(childName);
                childNodeName = this.nameOf(childNode);
                newChildrenToUpdate.add(childNodeName);
                this.updateNode(childNode, child, changes);
                existingChildNames.remove(childNodeName);
                continue;
            }
            try {
                childNode = session.getNodeByIdentifier(childName);
                childNodeName = this.nameOf(childNode);
                if (childNode.getParent().getIdentifier().equals(node.getIdentifier())) {
                    newChildrenToUpdate.add(childNodeName);
                    this.updateNode(childNode, child, changes);
                    existingChildNames.remove(childNodeName);
                    continue;
                }
                if (childNode.isNodeType("mix:shareable")) {
                    this.logger.warn("The node {0} with the id {1} is a shared node belonging to another parent. It cannot be changed via the update operation", (Object)childNode.getPath(), (Object)childNode.getIdentifier());
                    continue;
                }
                session.move(childNode.getPath(), node.getPath() + "/" + childNodeName);
            }
            catch (ItemNotFoundException e) {
                this.addNode(node, childName, child);
            }
        }
        LinkedList childNodes = new LinkedList(existingChildNames.values());
        while (!childNodes.isEmpty()) {
            Node child = (Node)childNodes.removeLast();
            existingChildrenToUpdate.remove(child.getIdentifier());
            child.remove();
        }
        if (newChildrenToUpdate.equals(existingChildrenToUpdate)) {
            return;
        }
        for (int i = 0; i < newChildrenToUpdate.size() - 1; ++i) {
            String startNodeName = (String)newChildrenToUpdate.get(i);
            int startNodeOriginalPosition = existingChildrenToUpdate.indexOf(startNodeName);
            assert (startNodeOriginalPosition != -1);
            for (int j = i + 1; j < newChildrenToUpdate.size(); ++j) {
                String nodeName = (String)newChildrenToUpdate.get(j);
                int nodeOriginalPosition = existingChildrenToUpdate.indexOf(nodeName);
                assert (nodeOriginalPosition != -1);
                if (startNodeOriginalPosition <= nodeOriginalPosition) continue;
                node.orderBefore(startNodeName, nodeName);
            }
        }
    }

    private String nameOf(Node node) throws RepositoryException {
        int index = node.getIndex();
        String childName = node.getName();
        return index == 1 ? childName : childName + "[" + index + "]";
    }

    protected static class VersionableChanges {
        private final Set<String> changedVersionableNodes = new HashSet<String>();
        private final Session session;
        private final VersionManager versionManager;

        protected VersionableChanges(Session session) throws RepositoryException {
            this.session = session;
            assert (this.session != null);
            this.versionManager = session.getWorkspace().getVersionManager();
        }

        public void checkout(Node node) throws RepositoryException {
            boolean versionable = node.isNodeType("mix:versionable");
            if (versionable) {
                String path = node.getPath();
                this.versionManager.checkout(path);
                this.changedVersionableNodes.add(path);
            }
        }

        public void checkin() throws RepositoryException {
            if (this.changedVersionableNodes.isEmpty()) {
                return;
            }
            this.session.save();
            RepositoryException first = null;
            for (String path : this.changedVersionableNodes) {
                try {
                    if (!this.versionManager.isCheckedOut(path)) continue;
                    this.versionManager.checkin(path);
                }
                catch (RepositoryException e) {
                    if (first != null) continue;
                    first = e;
                }
            }
            if (first != null) {
                throw first;
            }
        }

        public void abort() throws RepositoryException {
            if (this.changedVersionableNodes.isEmpty()) {
                return;
            }
            this.session.refresh(false);
            RepositoryException first = null;
            for (String path : this.changedVersionableNodes) {
                try {
                    if (!this.versionManager.isCheckedOut(path)) continue;
                    this.versionManager.checkin(path);
                }
                catch (RepositoryException e) {
                    if (first != null) continue;
                    first = e;
                }
            }
            if (first != null) {
                throw first;
            }
        }
    }

    protected static class JSONChild {
        private final String name;
        private final JsonNode body;
        private final int snsIdx;

        protected JSONChild(String name, JsonNode body, int snsIdx) {
            this.name = name;
            this.body = body;
            this.snsIdx = snsIdx;
        }

        public String getName() {
            return this.name;
        }

        public String getNameWithSNS() {
            return this.snsIdx > 1 ? this.name + "[" + this.snsIdx + "]" : this.name;
        }

        public JsonNode getBody() {
            return this.body;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("JSONChild{");
            sb.append("name='").append(this.getNameWithSNS()).append('\'');
            sb.append(", body=").append(this.body);
            sb.append('}');
            return sb.toString();
        }
    }
}

