/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.handler;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Requires;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.Binary;
import org.modeshape.web.jcr.rest.handler.AbstractHandler;
import org.modeshape.web.jcr.rest.handler.RestBinaryHandler;
import org.modeshape.web.jcr.rest.model.RestItem;
import org.wisdom.api.annotations.Service;
import org.wisdom.api.http.Request;
import org.wisdom.api.http.Result;
import org.wisdom.jcr.modeshape.api.RepositoryManager;

@Service(value={RestBinaryHandler.class})
public final class RestBinaryHandlerImpl
extends AbstractHandler
implements RestBinaryHandler,
Pojo {
    InstanceManager __IM;
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private boolean __FrepositoryManager;
    @Requires
    RepositoryManager repositoryManager;
    boolean __MgetBinaryProperty$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String;
    boolean __MgetDefaultContentDisposition$javax_jcr_Property;
    boolean __MgetDefaultMimeType$javax_jcr_Property;
    boolean __MupdateBinary$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream$boolean;
    boolean __MuploadBinary$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream;
    boolean __MgetRepositoryManager;

    RepositoryManager __getrepositoryManager() {
        if (!this.__FrepositoryManager) {
            return this.repositoryManager;
        }
        return (RepositoryManager)this.__IM.onGet((Object)this, "repositoryManager");
    }

    void __setrepositoryManager(RepositoryManager repositoryManager) {
        if (!this.__FrepositoryManager) {
            this.repositoryManager = repositoryManager;
            return;
        }
        this.__IM.onSet((Object)this, "repositoryManager", (Object)repositoryManager);
    }

    public RestBinaryHandlerImpl() {
        this(null);
    }

    private RestBinaryHandlerImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    @Override
    public Property getBinaryProperty(Request request, String repositoryName, String workspaceName, String binaryAbsPath) throws RepositoryException {
        Property property;
        if (!this.__MgetBinaryProperty$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_getBinaryProperty(request, repositoryName, workspaceName, binaryAbsPath);
        }
        try {
            this.__IM.onEntry((Object)this, "getBinaryProperty$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String", new Object[]{request, repositoryName, workspaceName, binaryAbsPath});
            property = this.__M_getBinaryProperty(request, repositoryName, workspaceName, binaryAbsPath);
            this.__IM.onExit((Object)this, "getBinaryProperty$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String", (Object)property);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getBinaryProperty$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return property;
    }

    private Property __M_getBinaryProperty(Request request, String repositoryName, String workspaceName, String binaryAbsPath) throws RepositoryException {
        Session session = this.getSession(request, repositoryName, workspaceName);
        return session.getProperty(binaryAbsPath);
    }

    @Override
    public String getDefaultContentDisposition(Property binaryProperty) throws RepositoryException {
        String string;
        if (!this.__MgetDefaultContentDisposition$javax_jcr_Property) {
            return this.__M_getDefaultContentDisposition(binaryProperty);
        }
        try {
            this.__IM.onEntry((Object)this, "getDefaultContentDisposition$javax_jcr_Property", new Object[]{binaryProperty});
            string = this.__M_getDefaultContentDisposition(binaryProperty);
            this.__IM.onExit((Object)this, "getDefaultContentDisposition$javax_jcr_Property", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDefaultContentDisposition$javax_jcr_Property", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getDefaultContentDisposition(Property binaryProperty) throws RepositoryException {
        Node parentNode = this.getParentNode(binaryProperty);
        String parentName = parentNode.getName();
        if (StringUtil.isBlank((String)parentName)) {
            parentName = "binary";
        }
        return "attachment;filename=" + parentName;
    }

    @Override
    public String getDefaultMimeType(Property binaryProperty) throws RepositoryException {
        String string;
        if (!this.__MgetDefaultMimeType$javax_jcr_Property) {
            return this.__M_getDefaultMimeType(binaryProperty);
        }
        try {
            this.__IM.onEntry((Object)this, "getDefaultMimeType$javax_jcr_Property", new Object[]{binaryProperty});
            string = this.__M_getDefaultMimeType(binaryProperty);
            this.__IM.onExit((Object)this, "getDefaultMimeType$javax_jcr_Property", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDefaultMimeType$javax_jcr_Property", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getDefaultMimeType(Property binaryProperty) throws RepositoryException {
        try {
            javax.jcr.Binary binary = binaryProperty.getBinary();
            return binary instanceof Binary ? ((Binary)binary).getMimeType() : DEFAULT_MIME_TYPE;
        }
        catch (IOException e) {
            this.logger.warn("Cannot determine default mime-type", (Throwable)e);
            return DEFAULT_MIME_TYPE;
        }
    }

    @Override
    public Result updateBinary(Request request, String repositoryName, String workspaceName, String binaryPropertyAbsPath, InputStream binaryStream, boolean allowCreation) throws RepositoryException {
        Result result;
        if (!this.__MupdateBinary$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream$boolean) {
            return this.__M_updateBinary(request, repositoryName, workspaceName, binaryPropertyAbsPath, binaryStream, allowCreation);
        }
        try {
            this.__IM.onEntry((Object)this, "updateBinary$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream$boolean", new Object[]{request, repositoryName, workspaceName, binaryPropertyAbsPath, binaryStream, new Boolean(allowCreation)});
            result = this.__M_updateBinary(request, repositoryName, workspaceName, binaryPropertyAbsPath, binaryStream, allowCreation);
            this.__IM.onExit((Object)this, "updateBinary$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream$boolean", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updateBinary$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream$boolean", throwable);
            throw throwable;
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private Result __M_updateBinary(Request request, String repositoryName, String workspaceName, String binaryPropertyAbsPath, InputStream binaryStream, boolean allowCreation) throws RepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Result uploadBinary(Request request, String repositoryName, String workspaceName, String filePath, InputStream binaryStream) throws RepositoryException {
        Result result;
        if (!this.__MuploadBinary$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream) {
            return this.__M_uploadBinary(request, repositoryName, workspaceName, filePath, binaryStream);
        }
        try {
            this.__IM.onEntry((Object)this, "uploadBinary$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream", new Object[]{request, repositoryName, workspaceName, filePath, binaryStream});
            result = this.__M_uploadBinary(request, repositoryName, workspaceName, filePath, binaryStream);
            this.__IM.onExit((Object)this, "uploadBinary$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "uploadBinary$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream", throwable);
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result __M_uploadBinary(Request request, String repositoryName, String workspaceName, String filePath, InputStream binaryStream) throws RepositoryException {
        Node fileNode;
        CheckArg.isNotNull((Object)binaryStream, (String)"request body");
        String[] segments = filePath.split("\\/");
        ArrayList<String> parsedSegments = new ArrayList<String>();
        for (String segment : segments) {
            if (StringUtil.isBlank((String)segment)) continue;
            parsedSegments.add(segment);
        }
        if (parsedSegments.isEmpty()) {
            return this.exceptionResponse("The path '" + filePath + "' should contain at least one segment");
        }
        Session session = this.getSession(request, repositoryName, workspaceName);
        try {
            fileNode = session.getNode(filePath);
        }
        catch (PathNotFoundException e) {
            fileNode = null;
        }
        try {
            int responseStatus;
            Node content;
            if (fileNode == null) {
                String filename = (String)parsedSegments.get(parsedSegments.size() - 1);
                String parentPath = "/";
                Node parent = session.getNode(parentPath);
                for (String childName : parsedSegments) {
                    try {
                        parent = parent.getNode(childName);
                    }
                    catch (PathNotFoundException e) {
                        parent = parent.addNode(childName, "nt:folder");
                    }
                }
                fileNode = parent.addNode(filename, "nt:file");
                content = fileNode.addNode("jcr:content", "nt:resource");
                responseStatus = 201;
            } else {
                if (!"nt:file".equalsIgnoreCase(fileNode.getPrimaryNodeType().getName())) {
                    Result filename = this.exceptionResponse("The node at '" + filePath + "' does not have the [nt:file] primary type");
                    return filename;
                }
                content = fileNode.getNode("jcr:content");
                responseStatus = 200;
            }
            javax.jcr.Binary binary = session.getValueFactory().createBinary(binaryStream);
            Property binaryProperty = content.setProperty("jcr:data", binary);
            session.save();
            RestItem restItem = this.createRestItem(request, 0, session, (Item)binaryProperty);
            Result result = new Result(responseStatus).render((Object)restItem);
            return result;
        }
        finally {
            try {
                binaryStream.close();
            }
            catch (IOException ioe) {
                this.logger.error("Cannot close binary stream", (Throwable)ioe);
            }
        }
    }

    @Override
    protected RepositoryManager getRepositoryManager() {
        RepositoryManager repositoryManager;
        if (!this.__MgetRepositoryManager) {
            return this.__M_getRepositoryManager();
        }
        try {
            this.__IM.onEntry((Object)this, "getRepositoryManager", new Object[0]);
            repositoryManager = this.__M_getRepositoryManager();
            this.__IM.onExit((Object)this, "getRepositoryManager", (Object)repositoryManager);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRepositoryManager", throwable);
            throw throwable;
        }
        return repositoryManager;
    }

    private RepositoryManager __M_getRepositoryManager() {
        return this.__getrepositoryManager();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("repositoryManager")) {
            this.__FrepositoryManager = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getBinaryProperty$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MgetBinaryProperty$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("getDefaultContentDisposition$javax_jcr_Property")) {
                this.__MgetDefaultContentDisposition$javax_jcr_Property = true;
            }
            if (set.contains("getDefaultMimeType$javax_jcr_Property")) {
                this.__MgetDefaultMimeType$javax_jcr_Property = true;
            }
            if (set.contains("updateBinary$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream$boolean")) {
                this.__MupdateBinary$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream$boolean = true;
            }
            if (set.contains("uploadBinary$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream")) {
                this.__MuploadBinary$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream = true;
            }
            if (set.contains("getRepositoryManager")) {
                this.__MgetRepositoryManager = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

