/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.handler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Requires;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.query.QueryResult;
import org.modeshape.web.jcr.rest.RestHelper;
import org.modeshape.web.jcr.rest.handler.AbstractHandler;
import org.modeshape.web.jcr.rest.handler.RestQueryHandler;
import org.modeshape.web.jcr.rest.model.RestQueryPlanResult;
import org.modeshape.web.jcr.rest.model.RestQueryResult;
import org.wisdom.api.annotations.Service;
import org.wisdom.api.http.Request;
import org.wisdom.jcr.modeshape.api.RepositoryManager;

@Service(value={RestQueryHandler.class})
public final class RestQueryHandlerImpl
extends AbstractHandler
implements RestQueryHandler,
Pojo {
    InstanceManager __IM;
    private static final String MODE_URI = "mode:uri";
    private static final String UNKNOWN_TYPE = "unknown-type";
    private static final Set<String> SKIP_QUERY_PARAMETERS = new HashSet<String>(Arrays.asList("offset", "limit"));
    private boolean __FrepositoryManager;
    @Requires
    RepositoryManager repositoryManager;
    boolean __MexecuteQuery$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String$long$long;
    boolean __MplanQuery$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String$long$long;
    boolean __MsetRows$long$long$javax_jcr_Session$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__$java_lang_String;
    boolean __McreateLinksFromNodePaths$javax_jcr_query_QueryResult$java_lang_String$javax_jcr_query_Row$org_modeshape_web_jcr_rest_model_RestQueryResult$RestRow;
    boolean __McreateRestRow$javax_jcr_Session$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__$java_lang_String$javax_jcr_query_Row;
    boolean __MbinaryPropertyPaths$javax_jcr_query_Row$java_lang_String__;
    boolean __MbinaryPropertyPaths$javax_jcr_Node;
    boolean __MsetColumns$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__;
    boolean __McreateQuery$java_lang_String$java_lang_String$javax_jcr_Session;
    boolean __MbindExtraVariables$org_wisdom_api_http_Request$javax_jcr_ValueFactory$javax_jcr_query_Query;
    boolean __MgetRepositoryManager;

    RepositoryManager __getrepositoryManager() {
        if (!this.__FrepositoryManager) {
            return this.repositoryManager;
        }
        return (RepositoryManager)this.__IM.onGet((Object)this, "repositoryManager");
    }

    void __setrepositoryManager(RepositoryManager repositoryManager) {
        if (!this.__FrepositoryManager) {
            this.repositoryManager = repositoryManager;
            return;
        }
        this.__IM.onSet((Object)this, "repositoryManager", (Object)repositoryManager);
    }

    public RestQueryHandlerImpl() {
        this(null);
    }

    private RestQueryHandlerImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    @Override
    public RestQueryResult executeQuery(Request request, String repositoryName, String workspaceName, String language, String statement, long offset, long limit) throws RepositoryException {
        RestQueryResult restQueryResult;
        if (!this.__MexecuteQuery$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String$long$long) {
            return this.__M_executeQuery(request, repositoryName, workspaceName, language, statement, offset, limit);
        }
        try {
            Object[] objectArray = new Object[7];
            objectArray[0] = request;
            objectArray[1] = repositoryName;
            objectArray[2] = workspaceName;
            objectArray[3] = language;
            objectArray[4] = statement;
            objectArray[5] = new Long(offset);
            objectArray[6] = new Long(limit);
            this.__IM.onEntry((Object)this, "executeQuery$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String$long$long", objectArray);
            restQueryResult = this.__M_executeQuery(request, repositoryName, workspaceName, language, statement, offset, limit);
            this.__IM.onExit((Object)this, "executeQuery$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String$long$long", (Object)restQueryResult);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "executeQuery$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String$long$long", throwable);
            throw throwable;
        }
        return restQueryResult;
    }

    private RestQueryResult __M_executeQuery(Request request, String repositoryName, String workspaceName, String language, String statement, long offset, long limit) throws RepositoryException {
        assert (repositoryName != null);
        assert (workspaceName != null);
        assert (language != null);
        assert (statement != null);
        Session session = this.getSession(request, repositoryName, workspaceName);
        org.modeshape.jcr.api.query.Query query = this.createQuery(language, statement, session);
        this.bindExtraVariables(request, session.getValueFactory(), (Query)query);
        javax.jcr.query.QueryResult result = query.execute();
        RestQueryResult restQueryResult = new RestQueryResult();
        String[] columnNames = result.getColumnNames();
        this.setColumns(result, restQueryResult, columnNames);
        String baseUrl = RestHelper.repositoryUrl(request);
        this.setRows(offset, limit, session, result, restQueryResult, columnNames, baseUrl);
        return restQueryResult;
    }

    @Override
    public RestQueryPlanResult planQuery(Request request, String repositoryName, String workspaceName, String language, String statement, long offset, long limit) throws RepositoryException {
        RestQueryPlanResult restQueryPlanResult;
        if (!this.__MplanQuery$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String$long$long) {
            return this.__M_planQuery(request, repositoryName, workspaceName, language, statement, offset, limit);
        }
        try {
            Object[] objectArray = new Object[7];
            objectArray[0] = request;
            objectArray[1] = repositoryName;
            objectArray[2] = workspaceName;
            objectArray[3] = language;
            objectArray[4] = statement;
            objectArray[5] = new Long(offset);
            objectArray[6] = new Long(limit);
            this.__IM.onEntry((Object)this, "planQuery$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String$long$long", objectArray);
            restQueryPlanResult = this.__M_planQuery(request, repositoryName, workspaceName, language, statement, offset, limit);
            this.__IM.onExit((Object)this, "planQuery$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String$long$long", (Object)restQueryPlanResult);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "planQuery$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String$long$long", throwable);
            throw throwable;
        }
        return restQueryPlanResult;
    }

    private RestQueryPlanResult __M_planQuery(Request request, String repositoryName, String workspaceName, String language, String statement, long offset, long limit) throws RepositoryException {
        assert (repositoryName != null);
        assert (workspaceName != null);
        assert (language != null);
        assert (statement != null);
        Session session = this.getSession(request, repositoryName, workspaceName);
        org.modeshape.jcr.api.query.Query query = this.createQuery(language, statement, session);
        this.bindExtraVariables(request, session.getValueFactory(), (Query)query);
        QueryResult result = query.explain();
        String plan = result.getPlan();
        return new RestQueryPlanResult(plan, statement, language, query.getAbstractQueryModelRepresentation());
    }

    private void setRows(long offset, long limit, Session session, javax.jcr.query.QueryResult result, RestQueryResult restQueryResult, String[] columnNames, String baseUrl) throws RepositoryException {
        if (!this.__MsetRows$long$long$javax_jcr_Session$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__$java_lang_String) {
            this.__M_setRows(offset, limit, session, result, restQueryResult, columnNames, baseUrl);
            return;
        }
        try {
            Object[] objectArray = new Object[7];
            objectArray[0] = new Long(offset);
            objectArray[1] = new Long(limit);
            objectArray[2] = session;
            objectArray[3] = result;
            objectArray[4] = restQueryResult;
            objectArray[5] = columnNames;
            objectArray[6] = baseUrl;
            this.__IM.onEntry((Object)this, "setRows$long$long$javax_jcr_Session$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__$java_lang_String", objectArray);
            this.__M_setRows(offset, limit, session, result, restQueryResult, columnNames, baseUrl);
            this.__IM.onExit((Object)this, "setRows$long$long$javax_jcr_Session$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setRows$long$long$javax_jcr_Session$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setRows(long offset, long limit, Session session, javax.jcr.query.QueryResult result, RestQueryResult restQueryResult, String[] columnNames, String baseUrl) throws RepositoryException {
        RowIterator resultRows = result.getRows();
        if (offset > 0L) {
            resultRows.skip(offset);
        }
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        while (resultRows.hasNext() && limit > 0L) {
            --limit;
            Row resultRow = resultRows.nextRow();
            RestQueryResult.RestRow restRow = this.createRestRow(session, result, restQueryResult, columnNames, baseUrl, resultRow);
            this.createLinksFromNodePaths(result, baseUrl, resultRow, restRow);
            restQueryResult.addRow(restRow);
        }
    }

    private void createLinksFromNodePaths(javax.jcr.query.QueryResult result, String baseUrl, Row resultRow, RestQueryResult.RestRow restRow) throws RepositoryException {
        if (!this.__McreateLinksFromNodePaths$javax_jcr_query_QueryResult$java_lang_String$javax_jcr_query_Row$org_modeshape_web_jcr_rest_model_RestQueryResult$RestRow) {
            this.__M_createLinksFromNodePaths(result, baseUrl, resultRow, restRow);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createLinksFromNodePaths$javax_jcr_query_QueryResult$java_lang_String$javax_jcr_query_Row$org_modeshape_web_jcr_rest_model_RestQueryResult$RestRow", new Object[]{result, baseUrl, resultRow, restRow});
            this.__M_createLinksFromNodePaths(result, baseUrl, resultRow, restRow);
            this.__IM.onExit((Object)this, "createLinksFromNodePaths$javax_jcr_query_QueryResult$java_lang_String$javax_jcr_query_Row$org_modeshape_web_jcr_rest_model_RestQueryResult$RestRow", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createLinksFromNodePaths$javax_jcr_query_QueryResult$java_lang_String$javax_jcr_query_Row$org_modeshape_web_jcr_rest_model_RestQueryResult$RestRow", throwable);
            throw throwable;
        }
    }

    private void __M_createLinksFromNodePaths(javax.jcr.query.QueryResult result, String baseUrl, Row resultRow, RestQueryResult.RestRow restRow) throws RepositoryException {
        if (result.getSelectorNames().length == 1) {
            String defaultPath = this.encodedPath(resultRow.getPath());
            if (!StringUtil.isBlank((String)defaultPath)) {
                restRow.addValue(MODE_URI, RestHelper.urlFrom(baseUrl, "items", defaultPath));
            }
        } else {
            for (String selectorName : result.getSelectorNames()) {
                try {
                    String selectorPath = this.encodedPath(resultRow.getPath(selectorName));
                    restRow.addValue("mode:uri-" + selectorName, RestHelper.urlFrom(baseUrl, "items", selectorPath));
                }
                catch (RepositoryException e) {
                    this.logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private RestQueryResult.RestRow createRestRow(Session session, javax.jcr.query.QueryResult result, RestQueryResult restQueryResult, String[] columnNames, String baseUrl, Row resultRow) throws RepositoryException {
        RestQueryResult.RestRow restRow;
        if (!this.__McreateRestRow$javax_jcr_Session$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__$java_lang_String$javax_jcr_query_Row) {
            return this.__M_createRestRow(session, result, restQueryResult, columnNames, baseUrl, resultRow);
        }
        try {
            this.__IM.onEntry((Object)this, "createRestRow$javax_jcr_Session$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__$java_lang_String$javax_jcr_query_Row", new Object[]{session, result, restQueryResult, columnNames, baseUrl, resultRow});
            restRow = this.__M_createRestRow(session, result, restQueryResult, columnNames, baseUrl, resultRow);
            this.__IM.onExit((Object)this, "createRestRow$javax_jcr_Session$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__$java_lang_String$javax_jcr_query_Row", (Object)restRow);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createRestRow$javax_jcr_Session$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__$java_lang_String$javax_jcr_query_Row", throwable);
            throw throwable;
        }
        return restRow;
    }

    private RestQueryResult.RestRow __M_createRestRow(Session session, javax.jcr.query.QueryResult result, RestQueryResult restQueryResult, String[] columnNames, String baseUrl, Row resultRow) throws RepositoryException {
        RestQueryResult.RestRow restRow = new RestQueryResult.RestRow(restQueryResult);
        Map<Value, String> binaryPropertyPaths = null;
        for (String columnName : columnNames) {
            Value value = resultRow.getValue(columnName);
            if (value == null) continue;
            String propertyPath = null;
            if (value.getType() == 2) {
                if (binaryPropertyPaths == null) {
                    binaryPropertyPaths = this.binaryPropertyPaths(resultRow, result.getSelectorNames());
                }
                propertyPath = (String)binaryPropertyPaths.get(value);
            }
            String valueString = this.valueToString(propertyPath, value, baseUrl, session);
            restRow.addValue(columnName, valueString);
        }
        return restRow;
    }

    private Map<Value, String> binaryPropertyPaths(Row row, String[] selectorNames) throws RepositoryException {
        Map<Value, String> map;
        if (!this.__MbinaryPropertyPaths$javax_jcr_query_Row$java_lang_String__) {
            return this.__M_binaryPropertyPaths(row, selectorNames);
        }
        try {
            this.__IM.onEntry((Object)this, "binaryPropertyPaths$javax_jcr_query_Row$java_lang_String__", new Object[]{row, selectorNames});
            map = this.__M_binaryPropertyPaths(row, selectorNames);
            this.__IM.onExit((Object)this, "binaryPropertyPaths$javax_jcr_query_Row$java_lang_String__", map);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "binaryPropertyPaths$javax_jcr_query_Row$java_lang_String__", throwable);
            throw throwable;
        }
        return map;
    }

    private Map<Value, String> __M_binaryPropertyPaths(Row row, String[] selectorNames) throws RepositoryException {
        HashMap<Value, String> result = new HashMap<Value, String>();
        Node node = row.getNode();
        if (node != null) {
            result.putAll(this.binaryPropertyPaths(node));
        }
        for (String selectorName : selectorNames) {
            Node selectedNode = row.getNode(selectorName);
            if (selectedNode == null || selectedNode == node) continue;
            result.putAll(this.binaryPropertyPaths(selectedNode));
        }
        return result;
    }

    private Map<Value, String> binaryPropertyPaths(Node node) throws RepositoryException {
        Map<Value, String> map;
        if (!this.__MbinaryPropertyPaths$javax_jcr_Node) {
            return this.__M_binaryPropertyPaths(node);
        }
        try {
            this.__IM.onEntry((Object)this, "binaryPropertyPaths$javax_jcr_Node", new Object[]{node});
            map = this.__M_binaryPropertyPaths(node);
            this.__IM.onExit((Object)this, "binaryPropertyPaths$javax_jcr_Node", map);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "binaryPropertyPaths$javax_jcr_Node", throwable);
            throw throwable;
        }
        return map;
    }

    private Map<Value, String> __M_binaryPropertyPaths(Node node) throws RepositoryException {
        HashMap<Value, String> result = new HashMap<Value, String>();
        PropertyIterator propertyIterator = node.getProperties();
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.nextProperty();
            if (property.getType() != 2) continue;
            result.put(property.getValue(), property.getPath());
        }
        return result;
    }

    private void setColumns(javax.jcr.query.QueryResult result, RestQueryResult restQueryResult, String[] columnNames) {
        if (!this.__MsetColumns$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__) {
            this.__M_setColumns(result, restQueryResult, columnNames);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setColumns$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__", new Object[]{result, restQueryResult, columnNames});
            this.__M_setColumns(result, restQueryResult, columnNames);
            this.__IM.onExit((Object)this, "setColumns$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setColumns$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__", throwable);
            throw throwable;
        }
    }

    private void __M_setColumns(javax.jcr.query.QueryResult result, RestQueryResult restQueryResult, String[] columnNames) {
        if (result instanceof QueryResult) {
            QueryResult modeShapeQueryResult = (QueryResult)result;
            String[] columnTypes = modeShapeQueryResult.getColumnTypes();
            for (int i = 0; i < columnNames.length; ++i) {
                restQueryResult.addColumn(columnNames[i], columnTypes[i]);
            }
        } else {
            for (String columnName : columnNames) {
                restQueryResult.addColumn(columnName, UNKNOWN_TYPE);
            }
        }
    }

    private org.modeshape.jcr.api.query.Query createQuery(String language, String statement, Session session) throws RepositoryException {
        org.modeshape.jcr.api.query.Query query;
        if (!this.__McreateQuery$java_lang_String$java_lang_String$javax_jcr_Session) {
            return this.__M_createQuery(language, statement, session);
        }
        try {
            this.__IM.onEntry((Object)this, "createQuery$java_lang_String$java_lang_String$javax_jcr_Session", new Object[]{language, statement, session});
            query = this.__M_createQuery(language, statement, session);
            this.__IM.onExit((Object)this, "createQuery$java_lang_String$java_lang_String$javax_jcr_Session", (Object)query);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createQuery$java_lang_String$java_lang_String$javax_jcr_Session", throwable);
            throw throwable;
        }
        return query;
    }

    private org.modeshape.jcr.api.query.Query __M_createQuery(String language, String statement, Session session) throws RepositoryException {
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        return (org.modeshape.jcr.api.query.Query)queryManager.createQuery(statement, language);
    }

    private void bindExtraVariables(Request uriInfo, ValueFactory valueFactory, Query query) throws RepositoryException {
        if (!this.__MbindExtraVariables$org_wisdom_api_http_Request$javax_jcr_ValueFactory$javax_jcr_query_Query) {
            this.__M_bindExtraVariables(uriInfo, valueFactory, query);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindExtraVariables$org_wisdom_api_http_Request$javax_jcr_ValueFactory$javax_jcr_query_Query", new Object[]{uriInfo, valueFactory, query});
            this.__M_bindExtraVariables(uriInfo, valueFactory, query);
            this.__IM.onExit((Object)this, "bindExtraVariables$org_wisdom_api_http_Request$javax_jcr_ValueFactory$javax_jcr_query_Query", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindExtraVariables$org_wisdom_api_http_Request$javax_jcr_ValueFactory$javax_jcr_query_Query", throwable);
            throw throwable;
        }
    }

    private void __M_bindExtraVariables(Request uriInfo, ValueFactory valueFactory, Query query) throws RepositoryException {
        if (uriInfo == null) {
            return;
        }
        for (Map.Entry entry : uriInfo.parameters().entrySet()) {
            String variableName = (String)entry.getKey();
            List variableValues = (List)entry.getValue();
            if (variableValues == null || variableValues.isEmpty() || SKIP_QUERY_PARAMETERS.contains(variableName)) continue;
            Iterator valuesIterator = variableValues.iterator();
            String variableValue = null;
            while (valuesIterator.hasNext() && variableValue == null) {
                variableValue = (String)valuesIterator.next();
            }
            if (variableValue == null) continue;
            query.bindValue(variableName, valueFactory.createValue(variableValue));
        }
    }

    @Override
    protected RepositoryManager getRepositoryManager() {
        RepositoryManager repositoryManager;
        if (!this.__MgetRepositoryManager) {
            return this.__M_getRepositoryManager();
        }
        try {
            this.__IM.onEntry((Object)this, "getRepositoryManager", new Object[0]);
            repositoryManager = this.__M_getRepositoryManager();
            this.__IM.onExit((Object)this, "getRepositoryManager", (Object)repositoryManager);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRepositoryManager", throwable);
            throw throwable;
        }
        return repositoryManager;
    }

    private RepositoryManager __M_getRepositoryManager() {
        return this.__getrepositoryManager();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("repositoryManager")) {
            this.__FrepositoryManager = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("executeQuery$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String$long$long")) {
                this.__MexecuteQuery$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String$long$long = true;
            }
            if (set.contains("planQuery$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String$long$long")) {
                this.__MplanQuery$org_wisdom_api_http_Request$java_lang_String$java_lang_String$java_lang_String$java_lang_String$long$long = true;
            }
            if (set.contains("setRows$long$long$javax_jcr_Session$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__$java_lang_String")) {
                this.__MsetRows$long$long$javax_jcr_Session$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__$java_lang_String = true;
            }
            if (set.contains("createLinksFromNodePaths$javax_jcr_query_QueryResult$java_lang_String$javax_jcr_query_Row$org_modeshape_web_jcr_rest_model_RestQueryResult$RestRow")) {
                this.__McreateLinksFromNodePaths$javax_jcr_query_QueryResult$java_lang_String$javax_jcr_query_Row$org_modeshape_web_jcr_rest_model_RestQueryResult$RestRow = true;
            }
            if (set.contains("createRestRow$javax_jcr_Session$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__$java_lang_String$javax_jcr_query_Row")) {
                this.__McreateRestRow$javax_jcr_Session$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__$java_lang_String$javax_jcr_query_Row = true;
            }
            if (set.contains("binaryPropertyPaths$javax_jcr_query_Row$java_lang_String__")) {
                this.__MbinaryPropertyPaths$javax_jcr_query_Row$java_lang_String__ = true;
            }
            if (set.contains("binaryPropertyPaths$javax_jcr_Node")) {
                this.__MbinaryPropertyPaths$javax_jcr_Node = true;
            }
            if (set.contains("setColumns$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__")) {
                this.__MsetColumns$javax_jcr_query_QueryResult$org_modeshape_web_jcr_rest_model_RestQueryResult$java_lang_String__ = true;
            }
            if (set.contains("createQuery$java_lang_String$java_lang_String$javax_jcr_Session")) {
                this.__McreateQuery$java_lang_String$java_lang_String$javax_jcr_Session = true;
            }
            if (set.contains("bindExtraVariables$org_wisdom_api_http_Request$javax_jcr_ValueFactory$javax_jcr_query_Query")) {
                this.__MbindExtraVariables$org_wisdom_api_http_Request$javax_jcr_ValueFactory$javax_jcr_query_Query = true;
            }
            if (set.contains("getRepositoryManager")) {
                this.__MgetRepositoryManager = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

