/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.modeshape.common.collection.Collections;
import org.modeshape.web.jcr.rest.model.RestItem;
import org.modeshape.web.jcr.rest.model.RestProperty;
import org.wisdom.api.content.Json;

public final class RestNode
extends RestItem {
    public static final String SELF_FIELD_NAME = "self";
    public static final String UP_FIELD_NAME = "up";
    public static final String ID_FIELD_NAME = "id";
    public static final String CHILDREN_FIELD_NAME = "children";
    private static final Set<String> RESERVED_FIELD_NAMES = Collections.unmodifiableSet((Object[])new String[]{"self", "up", "id", "children"});
    private final List<RestProperty> jcrProperties;
    private final List<RestNode> children;
    private final Map<String, String> customProperties;
    protected final String id;

    public RestNode(String name, String id, String url, String parentUrl) {
        super(name, url, parentUrl);
        this.id = id;
        this.jcrProperties = new ArrayList<RestProperty>();
        this.children = new ArrayList<RestNode>();
        this.customProperties = new TreeMap<String, String>();
    }

    public RestNode addChild(RestNode child) {
        this.children.add(child);
        return this;
    }

    public RestNode addJcrProperty(RestProperty property) {
        this.jcrProperties.add(property);
        return this;
    }

    public RestNode addCustomProperty(String name, String value) {
        this.customProperties.put(name, value);
        return this;
    }

    @Override
    public ObjectNode toJSON(Json json) {
        ObjectNode node = json.newObject();
        node.put(SELF_FIELD_NAME, this.url);
        node.put(UP_FIELD_NAME, this.parentUrl);
        node.put(ID_FIELD_NAME, this.id);
        this.addCustomProperties(node);
        this.addJcrProperties(node);
        this.addChildren(node, json);
        return node;
    }

    private boolean isReservedField(String fieldName) {
        return RESERVED_FIELD_NAMES.contains(fieldName);
    }

    private void addChildren(ObjectNode node, Json json) {
        if (!this.children.isEmpty()) {
            ObjectNode children = json.newObject();
            for (RestNode child : this.children) {
                children.put(child.name, (JsonNode)child.toJSON(json));
            }
            node.put(CHILDREN_FIELD_NAME, (JsonNode)children);
        }
    }

    private void addJcrProperties(ObjectNode node) {
        for (RestProperty restProperty : this.jcrProperties) {
            if (this.isReservedField(restProperty.name)) continue;
            if (restProperty.isMultiValue()) {
                ArrayNode arrayNode = node.putArray(restProperty.name);
                for (String value : restProperty.getValues()) {
                    arrayNode.add(value);
                }
                continue;
            }
            if (restProperty.getValue() == null) continue;
            node.put(restProperty.name, restProperty.getValue());
        }
    }

    private void addCustomProperties(ObjectNode node) {
        for (String customPropertyName : this.customProperties.keySet()) {
            if (this.isReservedField(customPropertyName)) continue;
            node.put(customPropertyName, this.customProperties.get(customPropertyName));
        }
    }
}

