/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import org.modeshape.web.jcr.rest.RestHelper;
import org.modeshape.web.jcr.rest.model.JSONAble;
import org.modeshape.web.jcr.rest.model.RestPropertyType;
import org.wisdom.api.content.Json;

public final class RestNodeType
implements JSONAble {
    private final Set<String> superTypesLinks;
    private final Set<String> subTypesLinks;
    private final List<RestPropertyType> propertyTypes;
    private final String name;
    private final boolean isMixin;
    private final boolean hasOrderableChildNodes;
    private final boolean isAbstract;
    private final boolean isQueryable;

    public RestNodeType(NodeType nodeType, String baseUrl) {
        this.name = nodeType.getName();
        this.isMixin = nodeType.isMixin();
        this.isAbstract = nodeType.isAbstract();
        this.isQueryable = nodeType.isQueryable();
        this.hasOrderableChildNodes = nodeType.hasOrderableChildNodes();
        this.superTypesLinks = new TreeSet<String>();
        for (NodeType nodeType2 : nodeType.getDeclaredSupertypes()) {
            String superTypeLink = RestHelper.urlFrom(baseUrl, "nodetypes", RestHelper.URL_ENCODER.encode(nodeType2.getName()));
            this.superTypesLinks.add(superTypeLink);
        }
        this.subTypesLinks = new TreeSet<String>();
        NodeTypeIterator subTypeIterator = nodeType.getDeclaredSubtypes();
        while (subTypeIterator.hasNext()) {
            String subTypeLink = RestHelper.urlFrom(baseUrl, "nodetypes", RestHelper.URL_ENCODER.encode(subTypeIterator.nextNodeType().getName()));
            this.subTypesLinks.add(subTypeLink);
        }
        this.propertyTypes = new ArrayList<RestPropertyType>();
        for (NodeType nodeType3 : nodeType.getDeclaredPropertyDefinitions()) {
            this.propertyTypes.add(new RestPropertyType((PropertyDefinition)nodeType3));
        }
    }

    @Override
    public ObjectNode toJSON(Json json) {
        ObjectNode content = json.newObject();
        content.put("mixin", this.isMixin);
        content.put("abstract", this.isAbstract);
        content.put("queryable", this.isQueryable);
        content.put("hasOrderableChildNodes", this.hasOrderableChildNodes);
        if (!this.propertyTypes.isEmpty()) {
            ArrayNode propertyDefinitions = content.putArray("propertyDefinitions");
            for (RestPropertyType restPropertyType : this.propertyTypes) {
                propertyDefinitions.add((JsonNode)restPropertyType.toJSON(json));
            }
        }
        if (!this.superTypesLinks.isEmpty()) {
            ArrayNode superTypesLinksArrayNode = content.putArray("superTypes");
            for (String superTypesLink : this.superTypesLinks) {
                superTypesLinksArrayNode.add(superTypesLink);
            }
        }
        if (!this.subTypesLinks.isEmpty()) {
            ArrayNode subTypesLinksArrayNode = content.putArray("subTypes");
            for (String subTypesLink : this.subTypesLinks) {
                subTypesLinksArrayNode.add(subTypesLink);
            }
        }
        ObjectNode result = json.newObject();
        result.put(this.name, (JsonNode)content);
        return result;
    }
}

