/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.modeshape.web.jcr.rest.model.JSONAble;
import org.wisdom.api.content.Json;

public final class RestRepositories
implements JSONAble {
    private final List<Repository> repositories = new ArrayList<Repository>();

    public Repository addRepository(String name, String url) {
        Repository repository = new Repository(name, url);
        this.repositories.add(repository);
        return repository;
    }

    @Override
    public ObjectNode toJSON(Json json) {
        ObjectNode result = json.newObject();
        ArrayNode repositories = result.putArray("repositories");
        for (Repository repository : this.repositories) {
            repositories.add((JsonNode)repository.toJSON(json));
        }
        return result;
    }

    public final class Repository
    implements JSONAble {
        private final String name;
        private final String url;
        private final Map<String, List<String>> metadata;
        private int activeSessionsCount;

        protected Repository(String name, String url) {
            this.name = name;
            this.url = url;
            this.metadata = new TreeMap<String, List<String>>();
        }

        public void addMetadata(String key, List<String> value) {
            if (key != null && value != null && !value.isEmpty()) {
                this.metadata.put(key, value);
            }
        }

        public void setActiveSessionsCount(int activeSessionsCount) {
            this.activeSessionsCount = activeSessionsCount;
        }

        @Override
        public ObjectNode toJSON(Json json) {
            ObjectNode object = json.newObject();
            object.put("name", this.name);
            object.put("workspaces", this.url);
            object.put("activeSessionsCount", this.activeSessionsCount);
            ObjectNode metadata = object.putObject("metadata");
            for (String metadataKey : this.metadata.keySet()) {
                List<String> values = this.metadata.get(metadataKey);
                if (values.size() == 1) {
                    metadata.put(metadataKey, values.get(0));
                    continue;
                }
                ArrayNode metadataArrayNode = metadata.putArray(metadataKey);
                for (String value : values) {
                    metadataArrayNode.add(value);
                }
            }
            return object;
        }
    }
}

