/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import java.io.InputStream;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Requires;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.StringUtil;
import org.modeshape.web.jcr.rest.handler.RestBinaryHandler;
import org.modeshape.web.jcr.rest.handler.RestItemHandler;
import org.modeshape.web.jcr.rest.handler.RestNodeHandler;
import org.modeshape.web.jcr.rest.handler.RestNodeTypeHandler;
import org.modeshape.web.jcr.rest.handler.RestQueryHandler;
import org.modeshape.web.jcr.rest.handler.RestRepositoryHandler;
import org.modeshape.web.jcr.rest.handler.RestServerHandler;
import org.modeshape.web.jcr.rest.model.RestException;
import org.wisdom.api.DefaultController;
import org.wisdom.api.annotations.Body;
import org.wisdom.api.annotations.Controller;
import org.wisdom.api.annotations.DefaultValue;
import org.wisdom.api.annotations.FormParameter;
import org.wisdom.api.annotations.Parameter;
import org.wisdom.api.annotations.Path;
import org.wisdom.api.annotations.PathParameter;
import org.wisdom.api.annotations.QueryParameter;
import org.wisdom.api.annotations.Route;
import org.wisdom.api.http.FileItem;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Result;

@Immutable
@Path(value="/")
@Controller
public final class ModeShapeRestService
extends DefaultController
implements Pojo {
    InstanceManager __IM;
    private boolean __FserverHandler;
    @Requires
    private RestServerHandler serverHandler;
    private boolean __FrepositoryHandler;
    @Requires
    private RestRepositoryHandler repositoryHandler;
    private boolean __FitemHandler;
    @Requires
    private RestItemHandler itemHandler;
    private boolean __FnodeHandler;
    @Requires
    private RestNodeHandler nodeHandler;
    private boolean __FqueryHandler;
    @Requires
    private RestQueryHandler queryHandler;
    private boolean __FbinaryHandler;
    @Requires
    private RestBinaryHandler binaryHandler;
    private boolean __FnodeTypeHandler;
    @Requires
    private RestNodeTypeHandler nodeTypeHandler;
    boolean __MgetRepositories;
    boolean __MgetWorkspaces$java_lang_String;
    boolean __MgetBinary$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    boolean __MgetNodeType$java_lang_String$java_lang_String$java_lang_String;
    boolean __MpostCND$java_lang_String$java_lang_String$boolean$java_io_InputStream;
    boolean __MpostCNDViaForm$java_lang_String$java_lang_String$boolean$org_wisdom_api_http_FileItem;
    boolean __MgetItem$java_lang_String$java_lang_String$java_lang_String$int;
    boolean __MpostItem$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    boolean __MpostItems$java_lang_String$java_lang_String$java_lang_String;
    boolean __MdeleteItem$java_lang_String$java_lang_String$java_lang_String;
    boolean __MdeleteItems$java_lang_String$java_lang_String$java_lang_String;
    boolean __MputItem$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    boolean __MputItems$java_lang_String$java_lang_String$java_lang_String;
    boolean __MpostBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream;
    boolean __MputBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream;
    boolean __MpostBinaryViaForm$java_lang_String$java_lang_String$java_lang_String$org_wisdom_api_http_FileItem;
    boolean __MuploadBinaryViaForm$java_lang_String$java_lang_String$java_lang_String$org_wisdom_api_http_FileItem;
    boolean __MuploadBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream;
    boolean __MpostXPathQuery$java_lang_String$java_lang_String$long$long$java_lang_String;
    boolean __MpostJcrSqlQuery$java_lang_String$java_lang_String$long$long$java_lang_String;
    boolean __MpostJcrSql2Query$java_lang_String$java_lang_String$long$long$java_lang_String;
    boolean __MpostJcrSearchQuery$java_lang_String$java_lang_String$long$long$java_lang_String;
    boolean __MpostXPathQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String;
    boolean __MpostJcrSqlQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String;
    boolean __MpostJcrSql2QueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String;
    boolean __MpostJcrSearchQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String;
    boolean __MgetNodeWithId$java_lang_String$java_lang_String$java_lang_String$int;
    boolean __MputNodeWithId$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    boolean __MdeleteNodeWithId$java_lang_String$java_lang_String$java_lang_String;

    RestServerHandler __getserverHandler() {
        if (!this.__FserverHandler) {
            return this.serverHandler;
        }
        return (RestServerHandler)this.__IM.onGet((Object)this, "serverHandler");
    }

    void __setserverHandler(RestServerHandler restServerHandler) {
        if (!this.__FserverHandler) {
            this.serverHandler = restServerHandler;
            return;
        }
        this.__IM.onSet((Object)this, "serverHandler", (Object)restServerHandler);
    }

    RestRepositoryHandler __getrepositoryHandler() {
        if (!this.__FrepositoryHandler) {
            return this.repositoryHandler;
        }
        return (RestRepositoryHandler)this.__IM.onGet((Object)this, "repositoryHandler");
    }

    void __setrepositoryHandler(RestRepositoryHandler restRepositoryHandler) {
        if (!this.__FrepositoryHandler) {
            this.repositoryHandler = restRepositoryHandler;
            return;
        }
        this.__IM.onSet((Object)this, "repositoryHandler", (Object)restRepositoryHandler);
    }

    RestItemHandler __getitemHandler() {
        if (!this.__FitemHandler) {
            return this.itemHandler;
        }
        return (RestItemHandler)this.__IM.onGet((Object)this, "itemHandler");
    }

    void __setitemHandler(RestItemHandler restItemHandler) {
        if (!this.__FitemHandler) {
            this.itemHandler = restItemHandler;
            return;
        }
        this.__IM.onSet((Object)this, "itemHandler", (Object)restItemHandler);
    }

    RestNodeHandler __getnodeHandler() {
        if (!this.__FnodeHandler) {
            return this.nodeHandler;
        }
        return (RestNodeHandler)this.__IM.onGet((Object)this, "nodeHandler");
    }

    void __setnodeHandler(RestNodeHandler restNodeHandler) {
        if (!this.__FnodeHandler) {
            this.nodeHandler = restNodeHandler;
            return;
        }
        this.__IM.onSet((Object)this, "nodeHandler", (Object)restNodeHandler);
    }

    RestQueryHandler __getqueryHandler() {
        if (!this.__FqueryHandler) {
            return this.queryHandler;
        }
        return (RestQueryHandler)this.__IM.onGet((Object)this, "queryHandler");
    }

    void __setqueryHandler(RestQueryHandler restQueryHandler) {
        if (!this.__FqueryHandler) {
            this.queryHandler = restQueryHandler;
            return;
        }
        this.__IM.onSet((Object)this, "queryHandler", (Object)restQueryHandler);
    }

    RestBinaryHandler __getbinaryHandler() {
        if (!this.__FbinaryHandler) {
            return this.binaryHandler;
        }
        return (RestBinaryHandler)this.__IM.onGet((Object)this, "binaryHandler");
    }

    void __setbinaryHandler(RestBinaryHandler restBinaryHandler) {
        if (!this.__FbinaryHandler) {
            this.binaryHandler = restBinaryHandler;
            return;
        }
        this.__IM.onSet((Object)this, "binaryHandler", (Object)restBinaryHandler);
    }

    RestNodeTypeHandler __getnodeTypeHandler() {
        if (!this.__FnodeTypeHandler) {
            return this.nodeTypeHandler;
        }
        return (RestNodeTypeHandler)this.__IM.onGet((Object)this, "nodeTypeHandler");
    }

    void __setnodeTypeHandler(RestNodeTypeHandler restNodeTypeHandler) {
        if (!this.__FnodeTypeHandler) {
            this.nodeTypeHandler = restNodeTypeHandler;
            return;
        }
        this.__IM.onSet((Object)this, "nodeTypeHandler", (Object)restNodeTypeHandler);
    }

    public ModeShapeRestService() {
        this(null);
    }

    private ModeShapeRestService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    @Route(uri="/", method=HttpMethod.GET)
    public Result getRepositories() {
        Result result;
        if (!this.__MgetRepositories) {
            return this.__M_getRepositories();
        }
        try {
            this.__IM.onEntry((Object)this, "getRepositories", new Object[0]);
            result = this.__M_getRepositories();
            this.__IM.onExit((Object)this, "getRepositories", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRepositories", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_getRepositories() {
        return ModeShapeRestService.ok((Object)this.__getserverHandler().getRepositories(this.request()));
    }

    @Route(uri="/{repositoryName}", method=HttpMethod.GET)
    public Result getWorkspaces(@PathParameter(value="repositoryName") String rawRepositoryName) throws RepositoryException {
        Result result;
        if (!this.__MgetWorkspaces$java_lang_String) {
            return this.__M_getWorkspaces(rawRepositoryName);
        }
        try {
            this.__IM.onEntry((Object)this, "getWorkspaces$java_lang_String", new Object[]{rawRepositoryName});
            result = this.__M_getWorkspaces(rawRepositoryName);
            this.__IM.onExit((Object)this, "getWorkspaces$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getWorkspaces$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_getWorkspaces(String rawRepositoryName) throws RepositoryException {
        return ModeShapeRestService.ok((Object)this.__getrepositoryHandler().getWorkspaces(this.request(), rawRepositoryName));
    }

    @Route(uri="{repositoryName}/{workspaceName}/binary{path:.+}", method=HttpMethod.GET)
    public Result getBinary(@PathParameter(value="repositoryName") String repositoryName, @PathParameter(value="workspaceName") String workspaceName, @PathParameter(value="path") String path, @Parameter(value="mimeType") String mimeType, @Parameter(value="contentDisposition") String contentDisposition) throws RepositoryException {
        Result result;
        if (!this.__MgetBinary$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_getBinary(repositoryName, workspaceName, path, mimeType, contentDisposition);
        }
        try {
            this.__IM.onEntry((Object)this, "getBinary$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{repositoryName, workspaceName, path, mimeType, contentDisposition});
            result = this.__M_getBinary(repositoryName, workspaceName, path, mimeType, contentDisposition);
            this.__IM.onExit((Object)this, "getBinary$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getBinary$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_getBinary(String repositoryName, String workspaceName, String path, String mimeType, String contentDisposition) throws RepositoryException {
        Property binaryProperty = this.__getbinaryHandler().getBinaryProperty(this.request(), repositoryName, workspaceName, path);
        if (binaryProperty.getType() != 2) {
            return ModeShapeRestService.notFound((String)new RestException("The property " + binaryProperty.getPath() + " is not a binary").toString());
        }
        Binary binary = binaryProperty.getBinary();
        if (StringUtil.isBlank((String)mimeType)) {
            mimeType = this.__getbinaryHandler().getDefaultMimeType(binaryProperty);
        }
        if (StringUtil.isBlank((String)contentDisposition)) {
            contentDisposition = this.__getbinaryHandler().getDefaultContentDisposition(binaryProperty);
        }
        Result result = ModeShapeRestService.ok((InputStream)binary.getStream()).as(mimeType);
        result.getHeaders().put("Content-Disposition", contentDisposition);
        return result;
    }

    @Route(uri="{repositoryName}/{workspaceName}/nodetypes/{nodeTypeName:.+}", method=HttpMethod.GET)
    public Result getNodeType(@PathParameter(value="repositoryName") String repositoryName, @PathParameter(value="workspaceName") String workspaceName, @PathParameter(value="nodeTypeName") String nodeTypeName) throws RepositoryException {
        Result result;
        if (!this.__MgetNodeType$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_getNodeType(repositoryName, workspaceName, nodeTypeName);
        }
        try {
            this.__IM.onEntry((Object)this, "getNodeType$java_lang_String$java_lang_String$java_lang_String", new Object[]{repositoryName, workspaceName, nodeTypeName});
            result = this.__M_getNodeType(repositoryName, workspaceName, nodeTypeName);
            this.__IM.onExit((Object)this, "getNodeType$java_lang_String$java_lang_String$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getNodeType$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_getNodeType(String repositoryName, String workspaceName, String nodeTypeName) throws RepositoryException {
        return ModeShapeRestService.ok((Object)this.__getnodeTypeHandler().getNodeType(this.request(), repositoryName, workspaceName, nodeTypeName));
    }

    @Route(uri="{repositoryName}/{workspaceName}/nodetypes", method=HttpMethod.POST)
    public Result postCND(@PathParameter(value="repositoryName") String repositoryName, @PathParameter(value="workspaceName") String workspaceName, @PathParameter(value="allowUpdate") @DefaultValue(value="true") boolean allowUpdate, @Body InputStream requestBodyInputStream) throws RepositoryException {
        Result result;
        if (!this.__MpostCND$java_lang_String$java_lang_String$boolean$java_io_InputStream) {
            return this.__M_postCND(repositoryName, workspaceName, allowUpdate, requestBodyInputStream);
        }
        try {
            this.__IM.onEntry((Object)this, "postCND$java_lang_String$java_lang_String$boolean$java_io_InputStream", new Object[]{repositoryName, workspaceName, new Boolean(allowUpdate), requestBodyInputStream});
            result = this.__M_postCND(repositoryName, workspaceName, allowUpdate, requestBodyInputStream);
            this.__IM.onExit((Object)this, "postCND$java_lang_String$java_lang_String$boolean$java_io_InputStream", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "postCND$java_lang_String$java_lang_String$boolean$java_io_InputStream", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_postCND(String repositoryName, String workspaceName, boolean allowUpdate, InputStream requestBodyInputStream) throws RepositoryException {
        return this.__getnodeTypeHandler().importCND(this.request(), repositoryName, workspaceName, allowUpdate, requestBodyInputStream);
    }

    @Route(uri="{repositoryName}/{workspaceName}/nodetypes", method=HttpMethod.POST)
    public Result postCNDViaForm(@PathParameter(value="repositoryName") String repositoryName, @PathParameter(value="workspaceName") String workspaceName, @QueryParameter(value="allowUpdate") @DefaultValue(value="true") boolean allowUpdate, @FormParameter(value="upload") FileItem form) throws RepositoryException {
        Result result;
        if (!this.__MpostCNDViaForm$java_lang_String$java_lang_String$boolean$org_wisdom_api_http_FileItem) {
            return this.__M_postCNDViaForm(repositoryName, workspaceName, allowUpdate, form);
        }
        try {
            this.__IM.onEntry((Object)this, "postCNDViaForm$java_lang_String$java_lang_String$boolean$org_wisdom_api_http_FileItem", new Object[]{repositoryName, workspaceName, new Boolean(allowUpdate), form});
            result = this.__M_postCNDViaForm(repositoryName, workspaceName, allowUpdate, form);
            this.__IM.onExit((Object)this, "postCNDViaForm$java_lang_String$java_lang_String$boolean$org_wisdom_api_http_FileItem", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "postCNDViaForm$java_lang_String$java_lang_String$boolean$org_wisdom_api_http_FileItem", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_postCNDViaForm(String repositoryName, String workspaceName, boolean allowUpdate, FileItem form) throws RepositoryException {
        return this.__getnodeTypeHandler().importCND(this.request(), repositoryName, workspaceName, allowUpdate, form.stream());
    }

    @Route(uri="{repositoryName}/{workspaceName}/items{path:.*}", method=HttpMethod.GET)
    public Result getItem(@PathParameter(value="repositoryName") String rawRepositoryName, @PathParameter(value="workspaceName") String rawWorkspaceName, @PathParameter(value="path") String path, @QueryParameter(value="depth") @DefaultValue(value="0") int depth) throws RepositoryException {
        Result result;
        if (!this.__MgetItem$java_lang_String$java_lang_String$java_lang_String$int) {
            return this.__M_getItem(rawRepositoryName, rawWorkspaceName, path, depth);
        }
        try {
            this.__IM.onEntry((Object)this, "getItem$java_lang_String$java_lang_String$java_lang_String$int", new Object[]{rawRepositoryName, rawWorkspaceName, path, new Integer(depth)});
            result = this.__M_getItem(rawRepositoryName, rawWorkspaceName, path, depth);
            this.__IM.onExit((Object)this, "getItem$java_lang_String$java_lang_String$java_lang_String$int", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getItem$java_lang_String$java_lang_String$java_lang_String$int", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_getItem(String rawRepositoryName, String rawWorkspaceName, String path, int depth) throws RepositoryException {
        return ModeShapeRestService.ok((Object)this.__getitemHandler().item(this.request(), rawRepositoryName, rawWorkspaceName, path, depth));
    }

    @Route(uri="{repositoryName}/{workspaceName}/items{path:.+}", method=HttpMethod.POST)
    public Result postItem(@PathParameter(value="repositoryName") String rawRepositoryName, @PathParameter(value="workspaceName") String rawWorkspaceName, @PathParameter(value="path") String path, @Body String requestContent) throws RepositoryException {
        Result result;
        if (!this.__MpostItem$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_postItem(rawRepositoryName, rawWorkspaceName, path, requestContent);
        }
        try {
            this.__IM.onEntry((Object)this, "postItem$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{rawRepositoryName, rawWorkspaceName, path, requestContent});
            result = this.__M_postItem(rawRepositoryName, rawWorkspaceName, path, requestContent);
            this.__IM.onExit((Object)this, "postItem$java_lang_String$java_lang_String$java_lang_String$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "postItem$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_postItem(String rawRepositoryName, String rawWorkspaceName, String path, String requestContent) throws RepositoryException {
        return ModeShapeRestService.ok((Object)this.__getitemHandler().addItem(this.request(), rawRepositoryName, rawWorkspaceName, path, requestContent));
    }

    @Route(uri="{repositoryName}/{workspaceName}/items", method=HttpMethod.POST)
    public Result postItems(@PathParameter(value="repositoryName") String rawRepositoryName, @PathParameter(value="workspaceName") String rawWorkspaceName, @Body String requestContent) throws RepositoryException {
        Result result;
        if (!this.__MpostItems$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_postItems(rawRepositoryName, rawWorkspaceName, requestContent);
        }
        try {
            this.__IM.onEntry((Object)this, "postItems$java_lang_String$java_lang_String$java_lang_String", new Object[]{rawRepositoryName, rawWorkspaceName, requestContent});
            result = this.__M_postItems(rawRepositoryName, rawWorkspaceName, requestContent);
            this.__IM.onExit((Object)this, "postItems$java_lang_String$java_lang_String$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "postItems$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_postItems(String rawRepositoryName, String rawWorkspaceName, String requestContent) throws RepositoryException {
        this.__getitemHandler().addItems(this.request(), rawRepositoryName, rawWorkspaceName, requestContent);
        return ModeShapeRestService.ok();
    }

    @Route(uri="{repositoryName}/{workspaceName}/items{path:.+}", method=HttpMethod.DELETE)
    public Result deleteItem(@PathParameter(value="repositoryName") String rawRepositoryName, @PathParameter(value="workspaceName") String rawWorkspaceName, @PathParameter(value="path") String path) throws RepositoryException {
        Result result;
        if (!this.__MdeleteItem$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_deleteItem(rawRepositoryName, rawWorkspaceName, path);
        }
        try {
            this.__IM.onEntry((Object)this, "deleteItem$java_lang_String$java_lang_String$java_lang_String", new Object[]{rawRepositoryName, rawWorkspaceName, path});
            result = this.__M_deleteItem(rawRepositoryName, rawWorkspaceName, path);
            this.__IM.onExit((Object)this, "deleteItem$java_lang_String$java_lang_String$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deleteItem$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_deleteItem(String rawRepositoryName, String rawWorkspaceName, String path) throws RepositoryException {
        this.__getitemHandler().deleteItem(this.request(), rawRepositoryName, rawWorkspaceName, path);
        return ModeShapeRestService.noContent();
    }

    @Route(uri="{repositoryName}/{workspaceName}/items", method=HttpMethod.DELETE)
    public Result deleteItems(@PathParameter(value="repositoryName") String rawRepositoryName, @PathParameter(value="workspaceName") String rawWorkspaceName, @Body String requestContent) throws RepositoryException {
        Result result;
        if (!this.__MdeleteItems$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_deleteItems(rawRepositoryName, rawWorkspaceName, requestContent);
        }
        try {
            this.__IM.onEntry((Object)this, "deleteItems$java_lang_String$java_lang_String$java_lang_String", new Object[]{rawRepositoryName, rawWorkspaceName, requestContent});
            result = this.__M_deleteItems(rawRepositoryName, rawWorkspaceName, requestContent);
            this.__IM.onExit((Object)this, "deleteItems$java_lang_String$java_lang_String$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deleteItems$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_deleteItems(String rawRepositoryName, String rawWorkspaceName, String requestContent) throws RepositoryException {
        this.__getitemHandler().deleteItems(this.request(), rawRepositoryName, rawWorkspaceName, requestContent);
        return ModeShapeRestService.ok();
    }

    @Route(uri="{repositoryName}/{workspaceName}/items{path:.+}", method=HttpMethod.PUT)
    public Result putItem(@PathParameter(value="repositoryName") String rawRepositoryName, @PathParameter(value="workspaceName") String rawWorkspaceName, @PathParameter(value="path") String path, @Body String requestContent) throws RepositoryException {
        Result result;
        if (!this.__MputItem$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_putItem(rawRepositoryName, rawWorkspaceName, path, requestContent);
        }
        try {
            this.__IM.onEntry((Object)this, "putItem$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{rawRepositoryName, rawWorkspaceName, path, requestContent});
            result = this.__M_putItem(rawRepositoryName, rawWorkspaceName, path, requestContent);
            this.__IM.onExit((Object)this, "putItem$java_lang_String$java_lang_String$java_lang_String$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "putItem$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_putItem(String rawRepositoryName, String rawWorkspaceName, String path, String requestContent) throws RepositoryException {
        return ModeShapeRestService.ok((Object)this.__getitemHandler().updateItem(this.request(), rawRepositoryName, rawWorkspaceName, path, requestContent));
    }

    @Route(uri="{repositoryName}/{workspaceName}/items", method=HttpMethod.PUT)
    public Result putItems(@PathParameter(value="repositoryName") String rawRepositoryName, @PathParameter(value="workspaceName") String rawWorkspaceName, @Body String requestContent) throws RepositoryException {
        Result result;
        if (!this.__MputItems$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_putItems(rawRepositoryName, rawWorkspaceName, requestContent);
        }
        try {
            this.__IM.onEntry((Object)this, "putItems$java_lang_String$java_lang_String$java_lang_String", new Object[]{rawRepositoryName, rawWorkspaceName, requestContent});
            result = this.__M_putItems(rawRepositoryName, rawWorkspaceName, requestContent);
            this.__IM.onExit((Object)this, "putItems$java_lang_String$java_lang_String$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "putItems$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_putItems(String rawRepositoryName, String rawWorkspaceName, String requestContent) throws RepositoryException {
        this.__getitemHandler().updateItems(this.request(), rawRepositoryName, rawWorkspaceName, requestContent);
        return ModeShapeRestService.ok();
    }

    @Route(uri="{repositoryName}/{workspaceName}/binary{path:.+}", method=HttpMethod.POST)
    public Result postBinary(@PathParameter(value="repositoryName") String repositoryName, @PathParameter(value="workspaceName") String workspaceName, @PathParameter(value="path") String path, @Body InputStream requestBodyInputStream) throws RepositoryException {
        Result result;
        if (!this.__MpostBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream) {
            return this.__M_postBinary(repositoryName, workspaceName, path, requestBodyInputStream);
        }
        try {
            this.__IM.onEntry((Object)this, "postBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream", new Object[]{repositoryName, workspaceName, path, requestBodyInputStream});
            result = this.__M_postBinary(repositoryName, workspaceName, path, requestBodyInputStream);
            this.__IM.onExit((Object)this, "postBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "postBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_postBinary(String repositoryName, String workspaceName, String path, InputStream requestBodyInputStream) throws RepositoryException {
        return this.__getbinaryHandler().updateBinary(this.request(), repositoryName, workspaceName, path, requestBodyInputStream, true);
    }

    @Route(uri="{repositoryName}/{workspaceName}/binary{path:.+}", method=HttpMethod.PUT)
    public Result putBinary(@PathParameter(value="repositoryName") String repositoryName, @PathParameter(value="workspaceName") String workspaceName, @PathParameter(value="path") String path, @Body InputStream requestBodyInputStream) throws RepositoryException {
        Result result;
        if (!this.__MputBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream) {
            return this.__M_putBinary(repositoryName, workspaceName, path, requestBodyInputStream);
        }
        try {
            this.__IM.onEntry((Object)this, "putBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream", new Object[]{repositoryName, workspaceName, path, requestBodyInputStream});
            result = this.__M_putBinary(repositoryName, workspaceName, path, requestBodyInputStream);
            this.__IM.onExit((Object)this, "putBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "putBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_putBinary(String repositoryName, String workspaceName, String path, InputStream requestBodyInputStream) throws RepositoryException {
        return this.__getbinaryHandler().updateBinary(this.request(), repositoryName, workspaceName, path, requestBodyInputStream, false);
    }

    @Route(uri="{repositoryName}/{workspaceName}/binary{path:.+}", method=HttpMethod.POST)
    public Result postBinaryViaForm(@PathParameter(value="repositoryName") String repositoryName, @PathParameter(value="workspaceName") String workspaceName, @PathParameter(value="path") String path, @FormParameter(value="upload") FileItem form) throws RepositoryException {
        Result result;
        if (!this.__MpostBinaryViaForm$java_lang_String$java_lang_String$java_lang_String$org_wisdom_api_http_FileItem) {
            return this.__M_postBinaryViaForm(repositoryName, workspaceName, path, form);
        }
        try {
            this.__IM.onEntry((Object)this, "postBinaryViaForm$java_lang_String$java_lang_String$java_lang_String$org_wisdom_api_http_FileItem", new Object[]{repositoryName, workspaceName, path, form});
            result = this.__M_postBinaryViaForm(repositoryName, workspaceName, path, form);
            this.__IM.onExit((Object)this, "postBinaryViaForm$java_lang_String$java_lang_String$java_lang_String$org_wisdom_api_http_FileItem", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "postBinaryViaForm$java_lang_String$java_lang_String$java_lang_String$org_wisdom_api_http_FileItem", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_postBinaryViaForm(String repositoryName, String workspaceName, String path, FileItem form) throws RepositoryException {
        return this.__getbinaryHandler().updateBinary(this.request(), repositoryName, workspaceName, path, form.stream(), true);
    }

    @Route(uri="{repositoryName}/{workspaceName}/upload{path:.+}", method=HttpMethod.POST)
    public Result uploadBinaryViaForm(@PathParameter(value="repositoryName") String repositoryName, @PathParameter(value="workspaceName") String workspaceName, @PathParameter(value="path") String filePath, @FormParameter(value="upload") FileItem form) throws RepositoryException {
        Result result;
        if (!this.__MuploadBinaryViaForm$java_lang_String$java_lang_String$java_lang_String$org_wisdom_api_http_FileItem) {
            return this.__M_uploadBinaryViaForm(repositoryName, workspaceName, filePath, form);
        }
        try {
            this.__IM.onEntry((Object)this, "uploadBinaryViaForm$java_lang_String$java_lang_String$java_lang_String$org_wisdom_api_http_FileItem", new Object[]{repositoryName, workspaceName, filePath, form});
            result = this.__M_uploadBinaryViaForm(repositoryName, workspaceName, filePath, form);
            this.__IM.onExit((Object)this, "uploadBinaryViaForm$java_lang_String$java_lang_String$java_lang_String$org_wisdom_api_http_FileItem", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "uploadBinaryViaForm$java_lang_String$java_lang_String$java_lang_String$org_wisdom_api_http_FileItem", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_uploadBinaryViaForm(String repositoryName, String workspaceName, String filePath, FileItem form) throws RepositoryException {
        return this.__getbinaryHandler().uploadBinary(this.request(), repositoryName, workspaceName, filePath, form.stream());
    }

    @Route(uri="{repositoryName}/{workspaceName}/upload{path:.+}", method=HttpMethod.POST)
    public Result uploadBinary(@PathParameter(value="repositoryName") String repositoryName, @PathParameter(value="workspaceName") String workspaceName, @PathParameter(value="path") String filePath, @Body InputStream requestBodyInputStream) throws RepositoryException {
        Result result;
        if (!this.__MuploadBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream) {
            return this.__M_uploadBinary(repositoryName, workspaceName, filePath, requestBodyInputStream);
        }
        try {
            this.__IM.onEntry((Object)this, "uploadBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream", new Object[]{repositoryName, workspaceName, filePath, requestBodyInputStream});
            result = this.__M_uploadBinary(repositoryName, workspaceName, filePath, requestBodyInputStream);
            this.__IM.onExit((Object)this, "uploadBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "uploadBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_uploadBinary(String repositoryName, String workspaceName, String filePath, InputStream requestBodyInputStream) throws RepositoryException {
        return this.__getbinaryHandler().uploadBinary(this.request(), repositoryName, workspaceName, filePath, requestBodyInputStream);
    }

    @Route(uri="{repositoryName}/{workspaceName}/query", method=HttpMethod.POST)
    public Result postXPathQuery(@PathParameter(value="repositoryName") String rawRepositoryName, @PathParameter(value="workspaceName") String rawWorkspaceName, @QueryParameter(value="offset") @DefaultValue(value="-1") long offset, @QueryParameter(value="limit") @DefaultValue(value="-1") long limit, @Body String requestContent) throws RepositoryException {
        Result result;
        if (!this.__MpostXPathQuery$java_lang_String$java_lang_String$long$long$java_lang_String) {
            return this.__M_postXPathQuery(rawRepositoryName, rawWorkspaceName, offset, limit, requestContent);
        }
        try {
            Object[] objectArray = new Object[5];
            objectArray[0] = rawRepositoryName;
            objectArray[1] = rawWorkspaceName;
            objectArray[2] = new Long(offset);
            objectArray[3] = new Long(limit);
            objectArray[4] = requestContent;
            this.__IM.onEntry((Object)this, "postXPathQuery$java_lang_String$java_lang_String$long$long$java_lang_String", objectArray);
            result = this.__M_postXPathQuery(rawRepositoryName, rawWorkspaceName, offset, limit, requestContent);
            this.__IM.onExit((Object)this, "postXPathQuery$java_lang_String$java_lang_String$long$long$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "postXPathQuery$java_lang_String$java_lang_String$long$long$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_postXPathQuery(String rawRepositoryName, String rawWorkspaceName, long offset, long limit, String requestContent) throws RepositoryException {
        return ModeShapeRestService.ok((Object)this.__getqueryHandler().executeQuery(this.request(), rawRepositoryName, rawWorkspaceName, "xpath", requestContent, offset, limit));
    }

    @Route(uri="{repositoryName}/{workspaceName}/query", method=HttpMethod.POST)
    public Result postJcrSqlQuery(@PathParameter(value="repositoryName") String rawRepositoryName, @PathParameter(value="workspaceName") String rawWorkspaceName, @QueryParameter(value="offset") @DefaultValue(value="-1") long offset, @QueryParameter(value="limit") @DefaultValue(value="-1") long limit, @Body String requestContent) throws RepositoryException {
        Result result;
        if (!this.__MpostJcrSqlQuery$java_lang_String$java_lang_String$long$long$java_lang_String) {
            return this.__M_postJcrSqlQuery(rawRepositoryName, rawWorkspaceName, offset, limit, requestContent);
        }
        try {
            Object[] objectArray = new Object[5];
            objectArray[0] = rawRepositoryName;
            objectArray[1] = rawWorkspaceName;
            objectArray[2] = new Long(offset);
            objectArray[3] = new Long(limit);
            objectArray[4] = requestContent;
            this.__IM.onEntry((Object)this, "postJcrSqlQuery$java_lang_String$java_lang_String$long$long$java_lang_String", objectArray);
            result = this.__M_postJcrSqlQuery(rawRepositoryName, rawWorkspaceName, offset, limit, requestContent);
            this.__IM.onExit((Object)this, "postJcrSqlQuery$java_lang_String$java_lang_String$long$long$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "postJcrSqlQuery$java_lang_String$java_lang_String$long$long$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_postJcrSqlQuery(String rawRepositoryName, String rawWorkspaceName, long offset, long limit, String requestContent) throws RepositoryException {
        return ModeShapeRestService.ok((Object)this.__getqueryHandler().executeQuery(this.request(), rawRepositoryName, rawWorkspaceName, "sql", requestContent, offset, limit));
    }

    @Route(uri="{repositoryName}/{workspaceName}/query", method=HttpMethod.POST)
    public Result postJcrSql2Query(@PathParameter(value="repositoryName") String rawRepositoryName, @PathParameter(value="workspaceName") String rawWorkspaceName, @QueryParameter(value="offset") @DefaultValue(value="-1") long offset, @QueryParameter(value="limit") @DefaultValue(value="-1") long limit, @Body String requestContent) throws RepositoryException {
        Result result;
        if (!this.__MpostJcrSql2Query$java_lang_String$java_lang_String$long$long$java_lang_String) {
            return this.__M_postJcrSql2Query(rawRepositoryName, rawWorkspaceName, offset, limit, requestContent);
        }
        try {
            Object[] objectArray = new Object[5];
            objectArray[0] = rawRepositoryName;
            objectArray[1] = rawWorkspaceName;
            objectArray[2] = new Long(offset);
            objectArray[3] = new Long(limit);
            objectArray[4] = requestContent;
            this.__IM.onEntry((Object)this, "postJcrSql2Query$java_lang_String$java_lang_String$long$long$java_lang_String", objectArray);
            result = this.__M_postJcrSql2Query(rawRepositoryName, rawWorkspaceName, offset, limit, requestContent);
            this.__IM.onExit((Object)this, "postJcrSql2Query$java_lang_String$java_lang_String$long$long$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "postJcrSql2Query$java_lang_String$java_lang_String$long$long$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_postJcrSql2Query(String rawRepositoryName, String rawWorkspaceName, long offset, long limit, String requestContent) throws RepositoryException {
        return ModeShapeRestService.ok((Object)this.__getqueryHandler().executeQuery(this.request(), rawRepositoryName, rawWorkspaceName, "JCR-SQL2", requestContent, offset, limit));
    }

    @Route(uri="{repositoryName}/{workspaceName}/query", method=HttpMethod.POST)
    public Result postJcrSearchQuery(@PathParameter(value="repositoryName") String rawRepositoryName, @PathParameter(value="workspaceName") String rawWorkspaceName, @QueryParameter(value="offset") @DefaultValue(value="-1") long offset, @QueryParameter(value="limit") @DefaultValue(value="-1") long limit, @Body String requestContent) throws RepositoryException {
        Result result;
        if (!this.__MpostJcrSearchQuery$java_lang_String$java_lang_String$long$long$java_lang_String) {
            return this.__M_postJcrSearchQuery(rawRepositoryName, rawWorkspaceName, offset, limit, requestContent);
        }
        try {
            Object[] objectArray = new Object[5];
            objectArray[0] = rawRepositoryName;
            objectArray[1] = rawWorkspaceName;
            objectArray[2] = new Long(offset);
            objectArray[3] = new Long(limit);
            objectArray[4] = requestContent;
            this.__IM.onEntry((Object)this, "postJcrSearchQuery$java_lang_String$java_lang_String$long$long$java_lang_String", objectArray);
            result = this.__M_postJcrSearchQuery(rawRepositoryName, rawWorkspaceName, offset, limit, requestContent);
            this.__IM.onExit((Object)this, "postJcrSearchQuery$java_lang_String$java_lang_String$long$long$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "postJcrSearchQuery$java_lang_String$java_lang_String$long$long$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_postJcrSearchQuery(String rawRepositoryName, String rawWorkspaceName, long offset, long limit, String requestContent) throws RepositoryException {
        return ModeShapeRestService.ok((Object)this.__getqueryHandler().executeQuery(this.request(), rawRepositoryName, rawWorkspaceName, "search", requestContent, offset, limit));
    }

    @Route(uri="{repositoryName}/{workspaceName}/queryPlan", method=HttpMethod.POST)
    public Result postXPathQueryPlan(@PathParameter(value="repositoryName") String rawRepositoryName, @PathParameter(value="workspaceName") String rawWorkspaceName, @QueryParameter(value="offset") @DefaultValue(value="-1") long offset, @QueryParameter(value="limit") @DefaultValue(value="-1") long limit, @Body String requestContent) throws RepositoryException {
        Result result;
        if (!this.__MpostXPathQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String) {
            return this.__M_postXPathQueryPlan(rawRepositoryName, rawWorkspaceName, offset, limit, requestContent);
        }
        try {
            Object[] objectArray = new Object[5];
            objectArray[0] = rawRepositoryName;
            objectArray[1] = rawWorkspaceName;
            objectArray[2] = new Long(offset);
            objectArray[3] = new Long(limit);
            objectArray[4] = requestContent;
            this.__IM.onEntry((Object)this, "postXPathQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String", objectArray);
            result = this.__M_postXPathQueryPlan(rawRepositoryName, rawWorkspaceName, offset, limit, requestContent);
            this.__IM.onExit((Object)this, "postXPathQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "postXPathQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_postXPathQueryPlan(String rawRepositoryName, String rawWorkspaceName, long offset, long limit, String requestContent) throws RepositoryException {
        return ModeShapeRestService.ok((Object)this.__getqueryHandler().planQuery(this.request(), rawRepositoryName, rawWorkspaceName, "xpath", requestContent, offset, limit));
    }

    @Route(uri="{repositoryName}/{workspaceName}/queryPlan", method=HttpMethod.POST)
    public Result postJcrSqlQueryPlan(@PathParameter(value="repositoryName") String rawRepositoryName, @PathParameter(value="workspaceName") String rawWorkspaceName, @QueryParameter(value="offset") @DefaultValue(value="-1") long offset, @QueryParameter(value="limit") @DefaultValue(value="-1") long limit, @Body String requestContent) throws RepositoryException {
        Result result;
        if (!this.__MpostJcrSqlQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String) {
            return this.__M_postJcrSqlQueryPlan(rawRepositoryName, rawWorkspaceName, offset, limit, requestContent);
        }
        try {
            Object[] objectArray = new Object[5];
            objectArray[0] = rawRepositoryName;
            objectArray[1] = rawWorkspaceName;
            objectArray[2] = new Long(offset);
            objectArray[3] = new Long(limit);
            objectArray[4] = requestContent;
            this.__IM.onEntry((Object)this, "postJcrSqlQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String", objectArray);
            result = this.__M_postJcrSqlQueryPlan(rawRepositoryName, rawWorkspaceName, offset, limit, requestContent);
            this.__IM.onExit((Object)this, "postJcrSqlQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "postJcrSqlQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_postJcrSqlQueryPlan(String rawRepositoryName, String rawWorkspaceName, long offset, long limit, String requestContent) throws RepositoryException {
        return ModeShapeRestService.ok((Object)this.__getqueryHandler().planQuery(this.request(), rawRepositoryName, rawWorkspaceName, "sql", requestContent, offset, limit));
    }

    @Route(uri="{repositoryName}/{workspaceName}/queryPlan", method=HttpMethod.POST)
    public Result postJcrSql2QueryPlan(@PathParameter(value="repositoryName") String rawRepositoryName, @PathParameter(value="workspaceName") String rawWorkspaceName, @QueryParameter(value="offset") @DefaultValue(value="-1") long offset, @QueryParameter(value="limit") @DefaultValue(value="-1") long limit, @Body String requestContent) throws RepositoryException {
        Result result;
        if (!this.__MpostJcrSql2QueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String) {
            return this.__M_postJcrSql2QueryPlan(rawRepositoryName, rawWorkspaceName, offset, limit, requestContent);
        }
        try {
            Object[] objectArray = new Object[5];
            objectArray[0] = rawRepositoryName;
            objectArray[1] = rawWorkspaceName;
            objectArray[2] = new Long(offset);
            objectArray[3] = new Long(limit);
            objectArray[4] = requestContent;
            this.__IM.onEntry((Object)this, "postJcrSql2QueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String", objectArray);
            result = this.__M_postJcrSql2QueryPlan(rawRepositoryName, rawWorkspaceName, offset, limit, requestContent);
            this.__IM.onExit((Object)this, "postJcrSql2QueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "postJcrSql2QueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_postJcrSql2QueryPlan(String rawRepositoryName, String rawWorkspaceName, long offset, long limit, String requestContent) throws RepositoryException {
        return ModeShapeRestService.ok((Object)this.__getqueryHandler().planQuery(this.request(), rawRepositoryName, rawWorkspaceName, "JCR-SQL2", requestContent, offset, limit));
    }

    @Route(uri="{repositoryName}/{workspaceName}/queryPlan", method=HttpMethod.POST)
    public Result postJcrSearchQueryPlan(@PathParameter(value="repositoryName") String rawRepositoryName, @PathParameter(value="workspaceName") String rawWorkspaceName, @QueryParameter(value="offset") @DefaultValue(value="-1") long offset, @QueryParameter(value="limit") @DefaultValue(value="-1") long limit, @Body String requestContent) throws RepositoryException {
        Result result;
        if (!this.__MpostJcrSearchQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String) {
            return this.__M_postJcrSearchQueryPlan(rawRepositoryName, rawWorkspaceName, offset, limit, requestContent);
        }
        try {
            Object[] objectArray = new Object[5];
            objectArray[0] = rawRepositoryName;
            objectArray[1] = rawWorkspaceName;
            objectArray[2] = new Long(offset);
            objectArray[3] = new Long(limit);
            objectArray[4] = requestContent;
            this.__IM.onEntry((Object)this, "postJcrSearchQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String", objectArray);
            result = this.__M_postJcrSearchQueryPlan(rawRepositoryName, rawWorkspaceName, offset, limit, requestContent);
            this.__IM.onExit((Object)this, "postJcrSearchQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "postJcrSearchQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_postJcrSearchQueryPlan(String rawRepositoryName, String rawWorkspaceName, long offset, long limit, String requestContent) throws RepositoryException {
        return ModeShapeRestService.ok((Object)this.__getqueryHandler().planQuery(this.request(), rawRepositoryName, rawWorkspaceName, "search", requestContent, offset, limit));
    }

    @Route(uri="{repositoryName}/{workspaceName}/nodes/{id:.*}", method=HttpMethod.GET)
    public Result getNodeWithId(@PathParameter(value="repositoryName") String rawRepositoryName, @PathParameter(value="workspaceName") String rawWorkspaceName, @PathParameter(value="id") String id, @QueryParameter(value="depth") @DefaultValue(value="0") int depth) throws RepositoryException {
        Result result;
        if (!this.__MgetNodeWithId$java_lang_String$java_lang_String$java_lang_String$int) {
            return this.__M_getNodeWithId(rawRepositoryName, rawWorkspaceName, id, depth);
        }
        try {
            this.__IM.onEntry((Object)this, "getNodeWithId$java_lang_String$java_lang_String$java_lang_String$int", new Object[]{rawRepositoryName, rawWorkspaceName, id, new Integer(depth)});
            result = this.__M_getNodeWithId(rawRepositoryName, rawWorkspaceName, id, depth);
            this.__IM.onExit((Object)this, "getNodeWithId$java_lang_String$java_lang_String$java_lang_String$int", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getNodeWithId$java_lang_String$java_lang_String$java_lang_String$int", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_getNodeWithId(String rawRepositoryName, String rawWorkspaceName, String id, int depth) throws RepositoryException {
        return ModeShapeRestService.ok((Object)this.__getnodeHandler().nodeWithId(this.request(), rawRepositoryName, rawWorkspaceName, id, depth));
    }

    @Route(uri="{repositoryName}/{workspaceName}/nodes/{id:.+}", method=HttpMethod.PUT)
    public Result putNodeWithId(@PathParameter(value="repositoryName") String rawRepositoryName, @PathParameter(value="workspaceName") String rawWorkspaceName, @PathParameter(value="id") String id, @Body String requestContent) throws RepositoryException {
        Result result;
        if (!this.__MputNodeWithId$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_putNodeWithId(rawRepositoryName, rawWorkspaceName, id, requestContent);
        }
        try {
            this.__IM.onEntry((Object)this, "putNodeWithId$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{rawRepositoryName, rawWorkspaceName, id, requestContent});
            result = this.__M_putNodeWithId(rawRepositoryName, rawWorkspaceName, id, requestContent);
            this.__IM.onExit((Object)this, "putNodeWithId$java_lang_String$java_lang_String$java_lang_String$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "putNodeWithId$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_putNodeWithId(String rawRepositoryName, String rawWorkspaceName, String id, String requestContent) throws RepositoryException {
        return ModeShapeRestService.ok((Object)this.__getnodeHandler().updateNodeWithId(this.request(), rawRepositoryName, rawWorkspaceName, id, requestContent));
    }

    @Route(uri="{repositoryName}/{workspaceName}/nodes/{id:.+}", method=HttpMethod.DELETE)
    public Result deleteNodeWithId(@PathParameter(value="repositoryName") String rawRepositoryName, @PathParameter(value="workspaceName") String rawWorkspaceName, @PathParameter(value="id") String id) throws RepositoryException {
        Result result;
        if (!this.__MdeleteNodeWithId$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_deleteNodeWithId(rawRepositoryName, rawWorkspaceName, id);
        }
        try {
            this.__IM.onEntry((Object)this, "deleteNodeWithId$java_lang_String$java_lang_String$java_lang_String", new Object[]{rawRepositoryName, rawWorkspaceName, id});
            result = this.__M_deleteNodeWithId(rawRepositoryName, rawWorkspaceName, id);
            this.__IM.onExit((Object)this, "deleteNodeWithId$java_lang_String$java_lang_String$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deleteNodeWithId$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_deleteNodeWithId(String rawRepositoryName, String rawWorkspaceName, String id) throws RepositoryException {
        this.__getnodeHandler().deleteNodeWithId(this.request(), rawRepositoryName, rawWorkspaceName, id);
        return ModeShapeRestService.noContent();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("binaryHandler")) {
                this.__FbinaryHandler = true;
            }
            if (set.contains("itemHandler")) {
                this.__FitemHandler = true;
            }
            if (set.contains("nodeHandler")) {
                this.__FnodeHandler = true;
            }
            if (set.contains("nodeTypeHandler")) {
                this.__FnodeTypeHandler = true;
            }
            if (set.contains("queryHandler")) {
                this.__FqueryHandler = true;
            }
            if (set.contains("repositoryHandler")) {
                this.__FrepositoryHandler = true;
            }
            if (set.contains("serverHandler")) {
                this.__FserverHandler = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getRepositories")) {
                this.__MgetRepositories = true;
            }
            if (set.contains("getWorkspaces$java_lang_String")) {
                this.__MgetWorkspaces$java_lang_String = true;
            }
            if (set.contains("getBinary$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MgetBinary$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("getNodeType$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MgetNodeType$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("postCND$java_lang_String$java_lang_String$boolean$java_io_InputStream")) {
                this.__MpostCND$java_lang_String$java_lang_String$boolean$java_io_InputStream = true;
            }
            if (set.contains("postCNDViaForm$java_lang_String$java_lang_String$boolean$org_wisdom_api_http_FileItem")) {
                this.__MpostCNDViaForm$java_lang_String$java_lang_String$boolean$org_wisdom_api_http_FileItem = true;
            }
            if (set.contains("getItem$java_lang_String$java_lang_String$java_lang_String$int")) {
                this.__MgetItem$java_lang_String$java_lang_String$java_lang_String$int = true;
            }
            if (set.contains("postItem$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MpostItem$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("postItems$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MpostItems$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("deleteItem$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MdeleteItem$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("deleteItems$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MdeleteItems$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("putItem$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MputItem$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("putItems$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MputItems$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("postBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream")) {
                this.__MpostBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream = true;
            }
            if (set.contains("putBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream")) {
                this.__MputBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream = true;
            }
            if (set.contains("postBinaryViaForm$java_lang_String$java_lang_String$java_lang_String$org_wisdom_api_http_FileItem")) {
                this.__MpostBinaryViaForm$java_lang_String$java_lang_String$java_lang_String$org_wisdom_api_http_FileItem = true;
            }
            if (set.contains("uploadBinaryViaForm$java_lang_String$java_lang_String$java_lang_String$org_wisdom_api_http_FileItem")) {
                this.__MuploadBinaryViaForm$java_lang_String$java_lang_String$java_lang_String$org_wisdom_api_http_FileItem = true;
            }
            if (set.contains("uploadBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream")) {
                this.__MuploadBinary$java_lang_String$java_lang_String$java_lang_String$java_io_InputStream = true;
            }
            if (set.contains("postXPathQuery$java_lang_String$java_lang_String$long$long$java_lang_String")) {
                this.__MpostXPathQuery$java_lang_String$java_lang_String$long$long$java_lang_String = true;
            }
            if (set.contains("postJcrSqlQuery$java_lang_String$java_lang_String$long$long$java_lang_String")) {
                this.__MpostJcrSqlQuery$java_lang_String$java_lang_String$long$long$java_lang_String = true;
            }
            if (set.contains("postJcrSql2Query$java_lang_String$java_lang_String$long$long$java_lang_String")) {
                this.__MpostJcrSql2Query$java_lang_String$java_lang_String$long$long$java_lang_String = true;
            }
            if (set.contains("postJcrSearchQuery$java_lang_String$java_lang_String$long$long$java_lang_String")) {
                this.__MpostJcrSearchQuery$java_lang_String$java_lang_String$long$long$java_lang_String = true;
            }
            if (set.contains("postXPathQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String")) {
                this.__MpostXPathQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String = true;
            }
            if (set.contains("postJcrSqlQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String")) {
                this.__MpostJcrSqlQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String = true;
            }
            if (set.contains("postJcrSql2QueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String")) {
                this.__MpostJcrSql2QueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String = true;
            }
            if (set.contains("postJcrSearchQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String")) {
                this.__MpostJcrSearchQueryPlan$java_lang_String$java_lang_String$long$long$java_lang_String = true;
            }
            if (set.contains("getNodeWithId$java_lang_String$java_lang_String$java_lang_String$int")) {
                this.__MgetNodeWithId$java_lang_String$java_lang_String$java_lang_String$int = true;
            }
            if (set.contains("putNodeWithId$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MputNodeWithId$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("deleteNodeWithId$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MdeleteNodeWithId$java_lang_String$java_lang_String$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

