/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.modeshape.common.text.UrlEncoder;
import org.modeshape.common.util.Base64;
import org.modeshape.jcr.api.ValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.http.Request;

public final class RestHelper {
    public static final UrlEncoder URL_ENCODER = new UrlEncoder();
    public static final String BINARY_METHOD_NAME = "binary";
    public static final String ITEMS_METHOD_NAME = "items";
    public static final String NODES_METHOD_NAME = "nodes";
    public static final String QUERY_METHOD_NAME = "query";
    public static final String QUERY_PLAN_METHOD_NAME = "queryPlan";
    public static final String NODE_TYPES_METHOD_NAME = "nodetypes";
    public static final String UPLOAD_METHOD_NAME = "upload";
    private static final List<String> ALL_METHODS = Arrays.asList("binary", "items", "nodes", "query", "queryPlan", "nodetypes", "upload");
    private static final List<SimpleDateFormat> ISO8601_DATE_PARSERS = Arrays.asList(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd"));
    private static final Logger LOGGER = LoggerFactory.getLogger(RestHelper.class);

    private RestHelper() {
    }

    public static String repositoryUrl(Request request) {
        String requestURL = request.uri();
        int delimiterSegmentIdx = requestURL.length();
        for (String methodName : ALL_METHODS) {
            if (requestURL.indexOf(methodName) == -1) continue;
            delimiterSegmentIdx = requestURL.indexOf(methodName);
            break;
        }
        return requestURL.substring(0, delimiterSegmentIdx);
    }

    public static String urlFrom(Request request, String ... pathSegments) {
        return RestHelper.urlFrom(request.uri(), pathSegments);
    }

    public static String urlFrom(String baseUrl, String ... pathSegments) {
        StringBuilder urlBuilder = new StringBuilder(baseUrl);
        if (urlBuilder.charAt(urlBuilder.length() - 1) == '/') {
            urlBuilder.deleteCharAt(urlBuilder.length() - 1);
        }
        for (String pathSegment : pathSegments) {
            if (pathSegment.equalsIgnoreCase("..")) {
                urlBuilder.delete(urlBuilder.lastIndexOf("/"), urlBuilder.length());
                continue;
            }
            if (!pathSegment.startsWith("/")) {
                urlBuilder.append("/");
            }
            urlBuilder.append(pathSegment);
        }
        return urlBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String jsonEncodedStringFor(Value value) {
        String string;
        block11: {
            if (value.getType() != 2) {
                return value.getString();
            }
            InputStream stream = value.getBinary().getStream();
            try {
                string = Base64.encode((InputStream)stream);
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            LOGGER.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            try {
                stream.close();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return string;
    }

    public static Value jsonValueToJCRValue(Object value, ValueFactory valueFactory) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer || value instanceof Long) {
            return valueFactory.createValue(((Number)value).longValue());
        }
        if (value instanceof Double || value instanceof Float) {
            return valueFactory.createValue(((Number)value).doubleValue());
        }
        if (value instanceof Boolean) {
            return valueFactory.createValue(((Boolean)value).booleanValue());
        }
        String valueString = value.toString();
        for (DateFormat dateFormat : ISO8601_DATE_PARSERS) {
            try {
                Date date = dateFormat.parse(valueString);
                return valueFactory.createValue(date);
            }
            catch (ParseException parseException) {
            }
            catch (ValueFormatException valueFormatException) {
            }
        }
        return valueFactory.createValue(valueString);
    }
}

