/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.PropertyType;
import org.modeshape.web.jcr.rest.model.JSONAble;
import org.wisdom.api.content.Json;

public final class RestPropertyType
implements JSONAble {
    private final String declaringNodeTypeName;
    private final boolean isAutoCreated;
    private final boolean isMandatory;
    private final boolean isProtected;
    private final String onParentVersion;
    private final String name;
    private final boolean isMultiple;
    private final boolean isFullTextSearchable;
    private final String requiredType;

    public RestPropertyType(PropertyDefinition definition) {
        this.name = definition.getName();
        this.requiredType = PropertyType.nameFromValue((int)definition.getRequiredType());
        NodeType declaringNodeType = definition.getDeclaringNodeType();
        this.declaringNodeTypeName = declaringNodeType == null ? null : declaringNodeType.getName();
        this.isAutoCreated = definition.isAutoCreated();
        this.isMandatory = definition.isMandatory();
        this.isProtected = definition.isProtected();
        this.isFullTextSearchable = definition.isFullTextSearchable();
        this.onParentVersion = OnParentVersionAction.nameFromValue((int)definition.getOnParentVersion());
        this.isMultiple = definition.isMultiple();
    }

    @Override
    public ObjectNode toJSON(Json json) {
        ObjectNode content = json.newObject();
        content.put("requiredType", this.requiredType);
        if (!StringUtil.isBlank((String)this.declaringNodeTypeName)) {
            content.put("declaringNodeTypeName", this.declaringNodeTypeName);
        }
        content.put("mandatory", this.isMandatory);
        content.put("multiple", this.isMultiple);
        content.put("autocreated", this.isAutoCreated);
        content.put("protected", this.isProtected);
        content.put("fullTextSearchable", this.isFullTextSearchable);
        content.put("onParentVersion", this.onParentVersion);
        ObjectNode object = json.newObject();
        object.put(this.name, (JsonNode)content);
        return object;
    }
}

