/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.jcr.modeshape.api.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.RepositoryFactory;
import javax.jcr.Session;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Requires;
import org.modeshape.common.annotation.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.annotations.Service;
import org.wisdom.api.http.Request;
import org.wisdom.jcr.modeshape.RequestCredentials;
import org.wisdom.jcr.modeshape.WebJcrI18n;
import org.wisdom.jcr.modeshape.api.NoSuchRepositoryException;
import org.wisdom.jcr.modeshape.api.RepositoryManager;
import org.wisdom.jcr.modeshape.service.ModeshapeRepositoryFactory;

@ThreadSafe
@Service(value={RepositoryManager.class})
public class RepositoryManagerImpl
implements RepositoryManager,
Pojo {
    InstanceManager __IM;
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryManagerImpl.class);
    private boolean __FrepositoryFactory;
    @Requires
    RepositoryFactory repositoryFactory;
    boolean __MgetSession$org_wisdom_api_http_Request$java_lang_String$java_lang_String;
    boolean __MgetRepository$java_lang_String;
    boolean __MgetJcrRepositoryNames;

    RepositoryFactory __getrepositoryFactory() {
        if (!this.__FrepositoryFactory) {
            return this.repositoryFactory;
        }
        return (RepositoryFactory)this.__IM.onGet((Object)this, "repositoryFactory");
    }

    void __setrepositoryFactory(RepositoryFactory repositoryFactory) {
        if (!this.__FrepositoryFactory) {
            this.repositoryFactory = repositoryFactory;
            return;
        }
        this.__IM.onSet((Object)this, "repositoryFactory", (Object)repositoryFactory);
    }

    private RepositoryManagerImpl() {
        this(null);
    }

    private RepositoryManagerImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    @Override
    public Session getSession(Request request, String repositoryName, String workspaceName) throws RepositoryException {
        Session session;
        if (!this.__MgetSession$org_wisdom_api_http_Request$java_lang_String$java_lang_String) {
            return this.__M_getSession(request, repositoryName, workspaceName);
        }
        try {
            this.__IM.onEntry((Object)this, "getSession$org_wisdom_api_http_Request$java_lang_String$java_lang_String", new Object[]{request, repositoryName, workspaceName});
            session = this.__M_getSession(request, repositoryName, workspaceName);
            this.__IM.onExit((Object)this, "getSession$org_wisdom_api_http_Request$java_lang_String$java_lang_String", (Object)session);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getSession$org_wisdom_api_http_Request$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return session;
    }

    private Session __M_getSession(Request request, String repositoryName, String workspaceName) throws RepositoryException {
        Repository repository = this.getRepository(repositoryName);
        if (request == null || request.username() == null) {
            return repository.login(workspaceName);
        }
        return repository.login((Credentials)new RequestCredentials(request), workspaceName);
    }

    @Override
    public Repository getRepository(String repositoryName) throws NoSuchRepositoryException {
        Repository repository;
        if (!this.__MgetRepository$java_lang_String) {
            return this.__M_getRepository(repositoryName);
        }
        try {
            this.__IM.onEntry((Object)this, "getRepository$java_lang_String", new Object[]{repositoryName});
            repository = this.__M_getRepository(repositoryName);
            this.__IM.onExit((Object)this, "getRepository$java_lang_String", (Object)repository);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRepository$java_lang_String", throwable);
            throw throwable;
        }
        return repository;
    }

    private Repository __M_getRepository(String repositoryName) throws NoSuchRepositoryException {
        Repository repository = null;
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("org.modeshape.jcr.RepositoryName", repositoryName);
            repository = this.__getrepositoryFactory().getRepository(map);
        }
        catch (RepositoryException e) {
            throw new NoSuchRepositoryException(WebJcrI18n.cannotInitializeRepository.text(new Object[]{repositoryName}), e);
        }
        if (repository == null) {
            throw new NoSuchRepositoryException(WebJcrI18n.repositoryNotFound.text(new Object[]{repositoryName}));
        }
        return repository;
    }

    @Override
    public Set<String> getJcrRepositoryNames() {
        Set<String> set;
        if (!this.__MgetJcrRepositoryNames) {
            return this.__M_getJcrRepositoryNames();
        }
        try {
            this.__IM.onEntry((Object)this, "getJcrRepositoryNames", new Object[0]);
            set = this.__M_getJcrRepositoryNames();
            this.__IM.onExit((Object)this, "getJcrRepositoryNames", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJcrRepositoryNames", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<String> __M_getJcrRepositoryNames() {
        try {
            return ((ModeshapeRepositoryFactory)this.__getrepositoryFactory()).getRepositoryNames();
        }
        catch (RepositoryException e) {
            LOGGER.error(WebJcrI18n.cannotLoadRepositoryNames.text(new Object[0]), (Throwable)e);
            return Collections.emptySet();
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("repositoryFactory")) {
            this.__FrepositoryFactory = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getSession$org_wisdom_api_http_Request$java_lang_String$java_lang_String")) {
                this.__MgetSession$org_wisdom_api_http_Request$java_lang_String$java_lang_String = true;
            }
            if (set.contains("getRepository$java_lang_String")) {
                this.__MgetRepository$java_lang_String = true;
            }
            if (set.contains("getJcrRepositoryNames")) {
                this.__MgetJcrRepositoryNames = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

