/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.jcr.modeshape.service;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.Set;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.RepositoryFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.schematic.document.ParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.configuration.ApplicationConfiguration;

@Component(name="org:wisdom:jcr:modeshape:factory")
@Provides(specifications={RepositoryFactory.class})
@Instantiate
public class ModeshapeRepositoryFactory
implements RepositoryFactory,
Pojo {
    InstanceManager __IM;
    private boolean __Flogger;
    private Logger logger;
    private boolean __FapplicationConfiguration;
    @Requires
    ApplicationConfiguration applicationConfiguration;
    private static String JCR = "jcr";
    private boolean __Fengine;
    private final ModeShapeEngine engine;
    boolean __Mstart;
    boolean __MgetRepositoryConfiguration$java_lang_String;
    boolean __Mstop;
    boolean __MgetRepository$java_util_Map;
    boolean __MgetRepositoryNames;

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    ApplicationConfiguration __getapplicationConfiguration() {
        if (!this.__FapplicationConfiguration) {
            return this.applicationConfiguration;
        }
        return (ApplicationConfiguration)this.__IM.onGet((Object)this, "applicationConfiguration");
    }

    void __setapplicationConfiguration(ApplicationConfiguration applicationConfiguration) {
        if (!this.__FapplicationConfiguration) {
            this.applicationConfiguration = applicationConfiguration;
            return;
        }
        this.__IM.onSet((Object)this, "applicationConfiguration", (Object)applicationConfiguration);
    }

    ModeShapeEngine __getengine() {
        if (!this.__Fengine) {
            return this.engine;
        }
        return (ModeShapeEngine)this.__IM.onGet((Object)this, "engine");
    }

    void __setengine(ModeShapeEngine modeShapeEngine) {
        if (!this.__Fengine) {
            this.engine = modeShapeEngine;
            return;
        }
        this.__IM.onSet((Object)this, "engine", (Object)modeShapeEngine);
    }

    public ModeshapeRepositoryFactory() {
        this(null);
    }

    private ModeshapeRepositoryFactory(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(LoggerFactory.getLogger(ModeshapeRepositoryFactory.class));
        this.__setengine(new ModeShapeEngine());
    }

    private void start() throws RepositoryException, InterruptedException {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() throws RepositoryException, InterruptedException {
        this.__getengine().start();
    }

    private Map getRepositoryConfiguration(String repositoryName) {
        Map map;
        if (!this.__MgetRepositoryConfiguration$java_lang_String) {
            return this.__M_getRepositoryConfiguration(repositoryName);
        }
        try {
            this.__IM.onEntry((Object)this, "getRepositoryConfiguration$java_lang_String", new Object[]{repositoryName});
            map = this.__M_getRepositoryConfiguration(repositoryName);
            this.__IM.onExit((Object)this, "getRepositoryConfiguration$java_lang_String", (Object)map);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRepositoryConfiguration$java_lang_String", throwable);
            throw throwable;
        }
        return map;
    }

    private Map __M_getRepositoryConfiguration(String repositoryName) {
        return this.__getapplicationConfiguration().getConfiguration(JCR).getConfiguration(repositoryName).asMap();
    }

    private void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        this.__getengine().shutdown();
    }

    public Repository getRepository(Map parameters) throws RepositoryException {
        Repository repository;
        if (!this.__MgetRepository$java_util_Map) {
            return this.__M_getRepository(parameters);
        }
        try {
            this.__IM.onEntry((Object)this, "getRepository$java_util_Map", new Object[]{parameters});
            repository = this.__M_getRepository(parameters);
            this.__IM.onExit((Object)this, "getRepository$java_util_Map", (Object)repository);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRepository$java_util_Map", throwable);
            throw throwable;
        }
        return repository;
    }

    private Repository __M_getRepository(Map parameters) throws RepositoryException {
        String name = (String)parameters.get("org.modeshape.jcr.RepositoryName");
        this.__getlogger().info("Accessing repository " + name);
        Map defaultParameters = this.getRepositoryConfiguration(name);
        defaultParameters.putAll(parameters);
        if (!this.__getengine().getRepositoryNames().contains(name)) {
            try {
                File configurationFile = new File(new File(this.__getapplicationConfiguration().getBaseDir(), "conf"), (String)defaultParameters.get("org.modeshape.jcr.URL"));
                this.__getengine().deploy(RepositoryConfiguration.read((File)configurationFile));
            }
            catch (ParsingException e) {
                this.__getlogger().error(e.getMessage(), (Throwable)e);
            }
            catch (FileNotFoundException e) {
                this.__getlogger().error(e.getMessage(), (Throwable)e);
            }
        }
        return this.__getengine().getRepository(name);
    }

    public Set<String> getRepositoryNames() throws RepositoryException {
        Set<String> set;
        if (!this.__MgetRepositoryNames) {
            return this.__M_getRepositoryNames();
        }
        try {
            this.__IM.onEntry((Object)this, "getRepositoryNames", new Object[0]);
            set = this.__M_getRepositoryNames();
            this.__IM.onExit((Object)this, "getRepositoryNames", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRepositoryNames", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<String> __M_getRepositoryNames() throws RepositoryException {
        return this.__getengine().getRepositoryNames();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("applicationConfiguration")) {
                this.__FapplicationConfiguration = true;
            }
            if (set.contains("engine")) {
                this.__Fengine = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("getRepositoryConfiguration$java_lang_String")) {
                this.__MgetRepositoryConfiguration$java_lang_String = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("getRepository$java_util_Map")) {
                this.__MgetRepository$java_util_Map = true;
            }
            if (set.contains("getRepositoryNames")) {
                this.__MgetRepositoryNames = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

