/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.framework.intances;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.MissingHandlerException;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.UnacceptableConfiguration;
import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Context;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Unbind;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.framework.intances.api.InstantiatedBy;

@Component
@Provides
@Instantiate
public class InstantiatedByManager
implements ConfigurationListener,
Pojo {
    InstanceManager __IM;
    boolean __MInstanceDeclaration___dispose;
    boolean __MInstanceDeclaration___dispose$java_lang_String;
    boolean __MInstanceDeclaration___matches$org_osgi_service_cm_Configuration;
    boolean __MInstanceDeclaration___matches$java_lang_String$java_lang_String;
    boolean __MInstanceDeclaration___create$org_osgi_service_cm_Configuration;
    boolean __MInstanceDeclaration___attachOrUpdate$org_osgi_service_cm_Configuration;
    private static final Logger LOGGER = LoggerFactory.getLogger(InstantiatedByManager.class);
    private boolean __Fcontext;
    @Context
    BundleContext context;
    private boolean __Fadmin;
    @Requires
    ConfigurationAdmin admin;
    private boolean __Fdeclarations;
    private List<InstanceDeclaration> declarations;
    private boolean __Flock;
    private final Lock lock;
    boolean __MbindFactory$org_apache_felix_ipojo_Factory;
    boolean __MunbindFactory$org_apache_felix_ipojo_Factory;
    boolean __MaddInstanceDeclaration$org_apache_felix_ipojo_Factory$java_lang_String;
    boolean __MgetConfigurationList;
    boolean __MgetDeclarationByFactory$org_apache_felix_ipojo_Factory;
    boolean __MgetDeclarationsByConfiguration$java_lang_String$java_lang_String;
    boolean __MconfigurationEvent$org_osgi_service_cm_ConfigurationEvent;
    boolean __Mfind$java_lang_String;

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    ConfigurationAdmin __getadmin() {
        if (!this.__Fadmin) {
            return this.admin;
        }
        return (ConfigurationAdmin)this.__IM.onGet((Object)this, "admin");
    }

    void __setadmin(ConfigurationAdmin configurationAdmin) {
        if (!this.__Fadmin) {
            this.admin = configurationAdmin;
            return;
        }
        this.__IM.onSet((Object)this, "admin", (Object)configurationAdmin);
    }

    List __getdeclarations() {
        if (!this.__Fdeclarations) {
            return this.declarations;
        }
        return (List)this.__IM.onGet((Object)this, "declarations");
    }

    void __setdeclarations(List list) {
        if (!this.__Fdeclarations) {
            this.declarations = list;
            return;
        }
        this.__IM.onSet((Object)this, "declarations", (Object)list);
    }

    Lock __getlock() {
        if (!this.__Flock) {
            return this.lock;
        }
        return (Lock)this.__IM.onGet((Object)this, "lock");
    }

    void __setlock(Lock lock) {
        if (!this.__Flock) {
            this.lock = lock;
            return;
        }
        this.__IM.onSet((Object)this, "lock", (Object)lock);
    }

    public InstantiatedByManager() {
        this(null);
    }

    private InstantiatedByManager(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setdeclarations(new ArrayList());
        this.__setlock(new ReentrantLock(true));
    }

    public void bindFactory(Factory factory) {
        if (!this.__MbindFactory$org_apache_felix_ipojo_Factory) {
            this.__M_bindFactory(factory);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindFactory$org_apache_felix_ipojo_Factory", new Object[]{factory});
            this.__M_bindFactory(factory);
            this.__IM.onExit((Object)this, "bindFactory$org_apache_felix_ipojo_Factory", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindFactory$org_apache_felix_ipojo_Factory", throwable);
            throw throwable;
        }
    }

    @Bind(aggregate=true)
    private void __M_bindFactory(Factory factory) {
        if (!(factory instanceof ComponentFactory)) {
            return;
        }
        String cn = factory.getClassName();
        if (cn == null) {
            return;
        }
        try {
            Class clazz = ((ComponentFactory)factory).loadClass(cn);
            InstantiatedBy annotation = clazz.getAnnotation(InstantiatedBy.class);
            if (annotation != null) {
                LOGGER.info("Factory annotated with `@InstantiatedBy` found : {}, configuration : {}", (Object)factory.getName(), (Object)annotation.value());
                this.addInstanceDeclaration(factory, annotation.value());
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Cannot load the component class {}", (Object)cn, (Object)e);
        }
    }

    public void unbindFactory(Factory factory) {
        if (!this.__MunbindFactory$org_apache_felix_ipojo_Factory) {
            this.__M_unbindFactory(factory);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindFactory$org_apache_felix_ipojo_Factory", new Object[]{factory});
            this.__M_unbindFactory(factory);
            this.__IM.onExit((Object)this, "unbindFactory$org_apache_felix_ipojo_Factory", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindFactory$org_apache_felix_ipojo_Factory", throwable);
            throw throwable;
        }
    }

    @Unbind
    private void __M_unbindFactory(Factory factory) {
        try {
            this.__getlock().lock();
            InstanceDeclaration declaration = this.getDeclarationByFactory(factory);
            if (declaration != null) {
                LOGGER.info("Disposing instance created by");
                declaration.dispose();
                this.__getdeclarations().remove(declaration);
            }
        }
        finally {
            this.__getlock().unlock();
        }
    }

    private void addInstanceDeclaration(Factory factory, String value) {
        if (!this.__MaddInstanceDeclaration$org_apache_felix_ipojo_Factory$java_lang_String) {
            this.__M_addInstanceDeclaration(factory, value);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addInstanceDeclaration$org_apache_felix_ipojo_Factory$java_lang_String", new Object[]{factory, value});
            this.__M_addInstanceDeclaration(factory, value);
            this.__IM.onExit((Object)this, "addInstanceDeclaration$org_apache_felix_ipojo_Factory$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addInstanceDeclaration$org_apache_felix_ipojo_Factory$java_lang_String", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_addInstanceDeclaration(Factory factory, String value) {
        try {
            this.__getlock().lock();
            InstanceDeclaration declaration = this.getDeclarationByFactory(factory);
            if (declaration != null) {
                declaration.dispose();
                this.__getdeclarations().remove(declaration);
            }
            declaration = new InstanceDeclaration(factory, value);
            this.__getdeclarations().add(declaration);
            Configuration[] configurations = this.getConfigurationList();
            if (configurations != null) {
                for (Configuration configuration : configurations) {
                    if (!declaration.matches(configuration)) continue;
                    LOGGER.debug("Found a matching configuration for " + factory.getName() + " => " + configuration.getPid());
                    declaration.attachOrUpdate(configuration);
                }
            }
        }
        finally {
            this.__getlock().unlock();
        }
    }

    private Configuration[] getConfigurationList() {
        Configuration[] configurationArray;
        if (!this.__MgetConfigurationList) {
            return this.__M_getConfigurationList();
        }
        try {
            this.__IM.onEntry((Object)this, "getConfigurationList", new Object[0]);
            configurationArray = this.__M_getConfigurationList();
            this.__IM.onExit((Object)this, "getConfigurationList", (Object)configurationArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getConfigurationList", throwable);
            throw throwable;
        }
        return configurationArray;
    }

    private Configuration[] __M_getConfigurationList() {
        Configuration[] configurations;
        try {
            configurations = this.__getadmin().listConfigurations(null);
        }
        catch (IOException | InvalidSyntaxException e) {
            throw new RuntimeException("Invalid Syntax Exception or IOException", e);
        }
        return configurations;
    }

    private InstanceDeclaration getDeclarationByFactory(Factory factory) {
        InstanceDeclaration instanceDeclaration;
        if (!this.__MgetDeclarationByFactory$org_apache_felix_ipojo_Factory) {
            return this.__M_getDeclarationByFactory(factory);
        }
        try {
            this.__IM.onEntry((Object)this, "getDeclarationByFactory$org_apache_felix_ipojo_Factory", new Object[]{factory});
            instanceDeclaration = this.__M_getDeclarationByFactory(factory);
            this.__IM.onExit((Object)this, "getDeclarationByFactory$org_apache_felix_ipojo_Factory", (Object)instanceDeclaration);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDeclarationByFactory$org_apache_felix_ipojo_Factory", throwable);
            throw throwable;
        }
        return instanceDeclaration;
    }

    private InstanceDeclaration __M_getDeclarationByFactory(Factory factory) {
        for (InstanceDeclaration declaration : this.__getdeclarations()) {
            if (!factory.equals(declaration.factory)) continue;
            return declaration;
        }
        return null;
    }

    private List<InstanceDeclaration> getDeclarationsByConfiguration(String pid, String factoryPid) {
        List<InstanceDeclaration> list;
        if (!this.__MgetDeclarationsByConfiguration$java_lang_String$java_lang_String) {
            return this.__M_getDeclarationsByConfiguration(pid, factoryPid);
        }
        try {
            this.__IM.onEntry((Object)this, "getDeclarationsByConfiguration$java_lang_String$java_lang_String", new Object[]{pid, factoryPid});
            list = this.__M_getDeclarationsByConfiguration(pid, factoryPid);
            this.__IM.onExit((Object)this, "getDeclarationsByConfiguration$java_lang_String$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDeclarationsByConfiguration$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<InstanceDeclaration> __M_getDeclarationsByConfiguration(String pid, String factoryPid) {
        ArrayList<InstanceDeclaration> result = new ArrayList<InstanceDeclaration>();
        for (InstanceDeclaration declaration : this.__getdeclarations()) {
            if (!declaration.matches(pid, factoryPid)) continue;
            result.add(declaration);
        }
        return result;
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (!this.__MconfigurationEvent$org_osgi_service_cm_ConfigurationEvent) {
            this.__M_configurationEvent(event);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "configurationEvent$org_osgi_service_cm_ConfigurationEvent", new Object[]{event});
            this.__M_configurationEvent(event);
            this.__IM.onExit((Object)this, "configurationEvent$org_osgi_service_cm_ConfigurationEvent", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "configurationEvent$org_osgi_service_cm_ConfigurationEvent", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void __M_configurationEvent(ConfigurationEvent event) {
        LOGGER.debug("event received : " + event.getPid() + " - " + event.getType());
        try {
            this.__getlock().lock();
            List<InstanceDeclaration> impacted = this.getDeclarationsByConfiguration(event.getPid(), event.getFactoryPid());
            if (impacted.isEmpty()) {
                return;
            }
            switch (event.getType()) {
                case 2: {
                    Iterator<InstanceDeclaration> iterator = impacted.iterator();
                    while (iterator.hasNext()) {
                        InstanceDeclaration declaration = iterator.next();
                        LOGGER.info("Configuration " + event.getPid() + " deleted");
                        declaration.dispose(event.getPid());
                    }
                    return;
                }
                case 1: {
                    Iterator<InstanceDeclaration> iterator = impacted.iterator();
                    while (iterator.hasNext()) {
                        InstanceDeclaration declaration = iterator.next();
                        Configuration configuration = this.find(event.getPid());
                        if (configuration == null) {
                            LOGGER.error("Weird case, a matching declaration was found, but cannot be found a second times, may be because of rapid changes in the config admin");
                            continue;
                        }
                        declaration.attachOrUpdate(configuration);
                    }
                    return;
                }
            }
            return;
        }
        finally {
            this.__getlock().unlock();
        }
    }

    private Configuration find(String pid) {
        Configuration configuration;
        if (!this.__Mfind$java_lang_String) {
            return this.__M_find(pid);
        }
        try {
            this.__IM.onEntry((Object)this, "find$java_lang_String", new Object[]{pid});
            configuration = this.__M_find(pid);
            this.__IM.onExit((Object)this, "find$java_lang_String", (Object)configuration);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "find$java_lang_String", throwable);
            throw throwable;
        }
        return configuration;
    }

    private Configuration __M_find(String pid) {
        Configuration[] configurations = this.getConfigurationList();
        if (configurations != null) {
            for (Configuration conf : configurations) {
                if (!conf.getPid().equals(pid)) continue;
                return conf;
            }
        }
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("admin")) {
                this.__Fadmin = true;
            }
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("declarations")) {
                this.__Fdeclarations = true;
            }
            if (set.contains("lock")) {
                this.__Flock = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("InstanceDeclaration___dispose")) {
                this.__MInstanceDeclaration___dispose = true;
            }
            if (set.contains("InstanceDeclaration___dispose$java_lang_String")) {
                this.__MInstanceDeclaration___dispose$java_lang_String = true;
            }
            if (set.contains("InstanceDeclaration___matches$org_osgi_service_cm_Configuration")) {
                this.__MInstanceDeclaration___matches$org_osgi_service_cm_Configuration = true;
            }
            if (set.contains("InstanceDeclaration___matches$java_lang_String$java_lang_String")) {
                this.__MInstanceDeclaration___matches$java_lang_String$java_lang_String = true;
            }
            if (set.contains("InstanceDeclaration___create$org_osgi_service_cm_Configuration")) {
                this.__MInstanceDeclaration___create$org_osgi_service_cm_Configuration = true;
            }
            if (set.contains("InstanceDeclaration___attachOrUpdate$org_osgi_service_cm_Configuration")) {
                this.__MInstanceDeclaration___attachOrUpdate$org_osgi_service_cm_Configuration = true;
            }
            if (set.contains("bindFactory$org_apache_felix_ipojo_Factory")) {
                this.__MbindFactory$org_apache_felix_ipojo_Factory = true;
            }
            if (set.contains("unbindFactory$org_apache_felix_ipojo_Factory")) {
                this.__MunbindFactory$org_apache_felix_ipojo_Factory = true;
            }
            if (set.contains("addInstanceDeclaration$org_apache_felix_ipojo_Factory$java_lang_String")) {
                this.__MaddInstanceDeclaration$org_apache_felix_ipojo_Factory$java_lang_String = true;
            }
            if (set.contains("getConfigurationList")) {
                this.__MgetConfigurationList = true;
            }
            if (set.contains("getDeclarationByFactory$org_apache_felix_ipojo_Factory")) {
                this.__MgetDeclarationByFactory$org_apache_felix_ipojo_Factory = true;
            }
            if (set.contains("getDeclarationsByConfiguration$java_lang_String$java_lang_String")) {
                this.__MgetDeclarationsByConfiguration$java_lang_String$java_lang_String = true;
            }
            if (set.contains("configurationEvent$org_osgi_service_cm_ConfigurationEvent")) {
                this.__MconfigurationEvent$org_osgi_service_cm_ConfigurationEvent = true;
            }
            if (set.contains("find$java_lang_String")) {
                this.__Mfind$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    private class InstanceDeclaration {
        private final Factory factory;
        private final String target;
        private Map<String, ComponentInstance> instances = new LinkedHashMap<String, ComponentInstance>();

        private InstanceDeclaration(Factory factory, String target) {
            this.factory = factory;
            this.target = target;
        }

        public void dispose() {
            if (!InstantiatedByManager.this.__MInstanceDeclaration___dispose) {
                this.__M_dispose();
                return;
            }
            try {
                InstantiatedByManager.this.__IM.onEntry((Object)this, "InstanceDeclaration___dispose", new Object[0]);
                this.__M_dispose();
                InstantiatedByManager.this.__IM.onExit((Object)this, "InstanceDeclaration___dispose", null);
            }
            catch (Throwable throwable) {
                InstantiatedByManager.this.__IM.onError((Object)this, "InstanceDeclaration___dispose", throwable);
                throw throwable;
            }
        }

        private void __M_dispose() {
            for (ComponentInstance instance : this.instances.values()) {
                LOGGER.info("Disposing " + instance.getInstanceName());
                instance.dispose();
            }
            this.instances.clear();
        }

        public void dispose(String string) {
            if (!InstantiatedByManager.this.__MInstanceDeclaration___dispose$java_lang_String) {
                this.__M_dispose(string);
                return;
            }
            try {
                InstantiatedByManager.this.__IM.onEntry((Object)this, "InstanceDeclaration___dispose$java_lang_String", new Object[]{string});
                this.__M_dispose(string);
                InstantiatedByManager.this.__IM.onExit((Object)this, "InstanceDeclaration___dispose$java_lang_String", null);
            }
            catch (Throwable throwable) {
                InstantiatedByManager.this.__IM.onError((Object)this, "InstanceDeclaration___dispose$java_lang_String", throwable);
                throw throwable;
            }
        }

        private void __M_dispose(String pid) {
            ComponentInstance instance = this.instances.remove(pid);
            if (instance != null) {
                LOGGER.info("Disposing " + instance.getInstanceName());
                instance.dispose();
            }
        }

        public boolean matches(Configuration configuration) {
            boolean bl;
            if (!InstantiatedByManager.this.__MInstanceDeclaration___matches$org_osgi_service_cm_Configuration) {
                return this.__M_matches(configuration);
            }
            try {
                InstantiatedByManager.this.__IM.onEntry((Object)this, "InstanceDeclaration___matches$org_osgi_service_cm_Configuration", new Object[]{configuration});
                bl = this.__M_matches(configuration);
                InstantiatedByManager.this.__IM.onExit((Object)this, "InstanceDeclaration___matches$org_osgi_service_cm_Configuration", (Object)new Boolean(bl));
            }
            catch (Throwable throwable) {
                InstantiatedByManager.this.__IM.onError((Object)this, "InstanceDeclaration___matches$org_osgi_service_cm_Configuration", throwable);
                throw throwable;
            }
            return bl;
        }

        private boolean __M_matches(Configuration configuration) {
            return this.matches(configuration.getPid(), configuration.getFactoryPid());
        }

        public boolean matches(String string, String string2) {
            boolean bl;
            if (!InstantiatedByManager.this.__MInstanceDeclaration___matches$java_lang_String$java_lang_String) {
                return this.__M_matches(string, string2);
            }
            try {
                InstantiatedByManager.this.__IM.onEntry((Object)this, "InstanceDeclaration___matches$java_lang_String$java_lang_String", new Object[]{string, string2});
                bl = this.__M_matches(string, string2);
                InstantiatedByManager.this.__IM.onExit((Object)this, "InstanceDeclaration___matches$java_lang_String$java_lang_String", (Object)new Boolean(bl));
            }
            catch (Throwable throwable) {
                InstantiatedByManager.this.__IM.onError((Object)this, "InstanceDeclaration___matches$java_lang_String$java_lang_String", throwable);
                throw throwable;
            }
            return bl;
        }

        private boolean __M_matches(String pid, String factoryPid) {
            return this.target.equals(pid) || this.target.equals(factoryPid);
        }

        private ComponentInstance create(Configuration configuration) {
            ComponentInstance componentInstance;
            if (!InstantiatedByManager.this.__MInstanceDeclaration___create$org_osgi_service_cm_Configuration) {
                return this.__M_create(configuration);
            }
            try {
                InstantiatedByManager.this.__IM.onEntry((Object)this, "InstanceDeclaration___create$org_osgi_service_cm_Configuration", new Object[]{configuration});
                componentInstance = this.__M_create(configuration);
                InstantiatedByManager.this.__IM.onExit((Object)this, "InstanceDeclaration___create$org_osgi_service_cm_Configuration", (Object)componentInstance);
            }
            catch (Throwable throwable) {
                InstantiatedByManager.this.__IM.onError((Object)this, "InstanceDeclaration___create$org_osgi_service_cm_Configuration", throwable);
                throw throwable;
            }
            return componentInstance;
        }

        private ComponentInstance __M_create(Configuration configuration) {
            try {
                return this.factory.createComponentInstance(configuration.getProperties());
            }
            catch (ConfigurationException | MissingHandlerException | UnacceptableConfiguration e) {
                LOGGER.error("Component creation failed from configuration {} ({})", new Object[]{configuration.getPid(), configuration.getProperties(), e});
                return null;
            }
        }

        public void attachOrUpdate(Configuration configuration) {
            if (!InstantiatedByManager.this.__MInstanceDeclaration___attachOrUpdate$org_osgi_service_cm_Configuration) {
                this.__M_attachOrUpdate(configuration);
                return;
            }
            try {
                InstantiatedByManager.this.__IM.onEntry((Object)this, "InstanceDeclaration___attachOrUpdate$org_osgi_service_cm_Configuration", new Object[]{configuration});
                this.__M_attachOrUpdate(configuration);
                InstantiatedByManager.this.__IM.onExit((Object)this, "InstanceDeclaration___attachOrUpdate$org_osgi_service_cm_Configuration", null);
            }
            catch (Throwable throwable) {
                InstantiatedByManager.this.__IM.onError((Object)this, "InstanceDeclaration___attachOrUpdate$org_osgi_service_cm_Configuration", throwable);
                throw throwable;
            }
        }

        private void __M_attachOrUpdate(Configuration configuration) {
            String pid = configuration.getPid();
            ComponentInstance instance = this.instances.get(pid);
            if (instance == null) {
                LOGGER.info("Attaching {} to factory {}", (Object)pid, (Object)this.factory.getName());
                instance = this.create(configuration);
                if (instance != null) {
                    LOGGER.info("Instance {} created from {}", (Object)instance.getInstanceName(), (Object)pid);
                    this.instances.put(pid, instance);
                }
            } else {
                instance.reconfigure(configuration.getProperties());
                LOGGER.info("Instance {} reconfigured from {}", (Object)instance.getInstanceName(), (Object)pid);
            }
        }
    }
}

