/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.mail;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mail {
    protected List<String> m_to = new ArrayList<String>(1);
    protected List<String> m_cc = new ArrayList<String>(0);
    protected List<String> m_replyTo = new ArrayList<String>(0);
    protected List<File> m_attachments = new ArrayList<File>();
    protected String m_subject = "no subject";
    protected String m_body = "";
    protected boolean m_read = false;
    protected String m_from;
    protected Date m_sent;
    protected String m_id;
    private String m_charset;
    private String m_mime;

    public Mail(String to, String subject, String body, List<File> attachments) {
        this.m_to.add(to);
        this.m_subject = subject;
        this.m_body = body;
        if (attachments != null && !attachments.isEmpty()) {
            this.m_attachments.addAll(attachments);
        }
    }

    public Mail(String to, String subject, String body) {
        this(to, subject, body, null);
    }

    public Mail() {
    }

    public Mail(Mail mail) throws FileNotFoundException {
        this.to(mail.to()).cc(mail.cc()).replyTo(mail.replyTo()).subject(mail.subject()).body(mail.body()).charset(mail.charset()).subType(mail.subType()).attach(mail.attachments()).read(mail.read()).sent(mail.sent()).from(mail.from()).id(mail.id());
    }

    public Mail from(String from) {
        this.m_from = from;
        return this;
    }

    public String from() {
        return this.m_from;
    }

    public Mail to(String to) {
        this.m_to.add(to);
        return this;
    }

    public Mail to(List<String> to) {
        this.m_to.addAll(to);
        return this;
    }

    public List<String> to() {
        return new ArrayList<String>(this.m_to);
    }

    public Mail removeTo(String to) {
        this.m_to.remove(to);
        return this;
    }

    public Mail cc(List<String> cc) {
        this.m_cc.addAll(cc);
        return this;
    }

    public Mail removeCC(String cc) {
        this.m_cc.remove(cc);
        return this;
    }

    public Mail cc(String cc) {
        if (cc != null) {
            this.m_cc.add(cc);
        }
        return this;
    }

    public List<String> cc() {
        return new ArrayList<String>(this.m_cc);
    }

    public Mail replyTo(String to) {
        this.m_replyTo.add(to);
        return this;
    }

    public Mail replyTo(List<String> reply) {
        this.m_replyTo.addAll(reply);
        return this;
    }

    public Mail removeReplyTo(String reply) {
        this.m_replyTo.remove(reply);
        return this;
    }

    public List<String> replyTo() {
        return new ArrayList<String>(this.m_replyTo);
    }

    public Mail attach(File file) throws NullPointerException, FileNotFoundException {
        if (file == null || !file.exists()) {
            if (file == null) {
                throw new NullPointerException("The given file is null");
            }
            throw new FileNotFoundException("The file " + file.getAbsolutePath() + " does not exist");
        }
        this.m_attachments.add(file);
        return this;
    }

    public Mail attach(List<File> files) throws NullPointerException, FileNotFoundException {
        if (files != null) {
            for (File f : files) {
                this.attach(f);
            }
        } else {
            throw new NullPointerException("The given file list is null");
        }
        return this;
    }

    public Mail removeAttachment(File attachment) {
        this.m_attachments.remove(attachment);
        return this;
    }

    public List<File> attachments() {
        return new ArrayList<File>(this.m_attachments);
    }

    public Mail subject(String subject) {
        this.m_subject = subject;
        return this;
    }

    public String subject() {
        return this.m_subject;
    }

    public Mail body(String body) {
        this.m_body = body;
        return this;
    }

    public String body() {
        return this.m_body;
    }

    public Mail charset(String charset) {
        this.m_charset = charset;
        return this;
    }

    public String charset() {
        return this.m_charset;
    }

    public Mail subType(String mime) {
        this.m_mime = mime;
        return this;
    }

    public String subType() {
        return this.m_mime;
    }

    public boolean read() {
        return this.m_read;
    }

    public Mail read(boolean r) {
        this.m_read = r;
        return this;
    }

    public Date sent() {
        return this.m_sent;
    }

    public Mail sent(Date s) {
        this.m_sent = s;
        return this;
    }

    public String id() {
        return this.m_id;
    }

    public Mail id(String id) {
        this.m_id = id;
        return this;
    }
}

