/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.mailer;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Authenticator;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.net.ssl.SSLSocketFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.Updated;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.chameleon.mail.Mail;
import org.ow2.chameleon.mail.MailSenderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.configuration.ApplicationConfiguration;

@Component
@Provides
@Instantiate
public class Smtp
implements MailSenderService,
Pojo {
    InstanceManager __IM;
    boolean __M1___getPasswordAuthentication;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Smtp.class.getName());
    public static final String MOCK_SERVER_NAME = "mock";
    public static final String DEFAULT_FROM = "mock-mailer@wisdom-framework.org";
    private static final String CONFHOST = "mail.smtp.host";
    private static final String CONFPORT = "mail.smtp.port";
    private static final String CONFAUTH = "mail.smtp.auth";
    private static final String SEPARATOR = "\t----";
    private boolean __Fconfiguration;
    @Requires
    ApplicationConfiguration configuration;
    private boolean __Fproperties;
    private Properties properties;
    private boolean __Fdebug;
    private boolean debug;
    private boolean __Ffrom;
    @ServiceProperty(name="org.ow2.chameleon.mail.sender")
    protected String from;
    private boolean __FfromName;
    protected String fromName;
    private boolean __Fport;
    protected int port;
    private boolean __Fhost;
    protected String host;
    private boolean __Fusername;
    protected String username;
    private boolean __Fpassword;
    protected String password;
    private boolean __FsslAuthentication;
    private Authenticator sslAuthentication;
    private boolean __FuseMock;
    protected boolean useMock;
    private boolean __FuseSmtps;
    protected Boolean useSmtps;
    private boolean __Fconnection;
    protected Connection connection;
    boolean __Mconfigure;
    boolean __MmanageConnectionType;
    boolean __Mreconfigure;
    boolean __Msend$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    boolean __Msend$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_util_List;
    boolean __Msend$org_ow2_chameleon_mail_Mail;
    boolean __MaddBodyToMessage$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage;
    boolean __MsendMessageWithMockServer$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage;

    ApplicationConfiguration __getconfiguration() {
        if (!this.__Fconfiguration) {
            return this.configuration;
        }
        return (ApplicationConfiguration)this.__IM.onGet((Object)this, "configuration");
    }

    void __setconfiguration(ApplicationConfiguration applicationConfiguration) {
        if (!this.__Fconfiguration) {
            this.configuration = applicationConfiguration;
            return;
        }
        this.__IM.onSet((Object)this, "configuration", (Object)applicationConfiguration);
    }

    Properties __getproperties() {
        if (!this.__Fproperties) {
            return this.properties;
        }
        return (Properties)this.__IM.onGet((Object)this, "properties");
    }

    void __setproperties(Properties properties) {
        if (!this.__Fproperties) {
            this.properties = properties;
            return;
        }
        this.__IM.onSet((Object)this, "properties", (Object)properties);
    }

    boolean __getdebug() {
        if (!this.__Fdebug) {
            return this.debug;
        }
        Object object = this.__IM.onGet((Object)this, "debug");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setdebug(boolean bl) {
        if (!this.__Fdebug) {
            this.debug = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "debug", (Object)bl2);
    }

    String __getfrom() {
        if (!this.__Ffrom) {
            return this.from;
        }
        return (String)this.__IM.onGet((Object)this, "from");
    }

    void __setfrom(String string) {
        if (!this.__Ffrom) {
            this.from = string;
            return;
        }
        this.__IM.onSet((Object)this, "from", (Object)string);
    }

    String __getfromName() {
        if (!this.__FfromName) {
            return this.fromName;
        }
        return (String)this.__IM.onGet((Object)this, "fromName");
    }

    void __setfromName(String string) {
        if (!this.__FfromName) {
            this.fromName = string;
            return;
        }
        this.__IM.onSet((Object)this, "fromName", (Object)string);
    }

    int __getport() {
        if (!this.__Fport) {
            return this.port;
        }
        Object object = this.__IM.onGet((Object)this, "port");
        Integer n = (Integer)object;
        return n;
    }

    void __setport(int n) {
        if (!this.__Fport) {
            this.port = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "port", (Object)n2);
    }

    String __gethost() {
        if (!this.__Fhost) {
            return this.host;
        }
        return (String)this.__IM.onGet((Object)this, "host");
    }

    void __sethost(String string) {
        if (!this.__Fhost) {
            this.host = string;
            return;
        }
        this.__IM.onSet((Object)this, "host", (Object)string);
    }

    String __getusername() {
        if (!this.__Fusername) {
            return this.username;
        }
        return (String)this.__IM.onGet((Object)this, "username");
    }

    void __setusername(String string) {
        if (!this.__Fusername) {
            this.username = string;
            return;
        }
        this.__IM.onSet((Object)this, "username", (Object)string);
    }

    String __getpassword() {
        if (!this.__Fpassword) {
            return this.password;
        }
        return (String)this.__IM.onGet((Object)this, "password");
    }

    void __setpassword(String string) {
        if (!this.__Fpassword) {
            this.password = string;
            return;
        }
        this.__IM.onSet((Object)this, "password", (Object)string);
    }

    Authenticator __getsslAuthentication() {
        if (!this.__FsslAuthentication) {
            return this.sslAuthentication;
        }
        return (Authenticator)this.__IM.onGet((Object)this, "sslAuthentication");
    }

    void __setsslAuthentication(Authenticator authenticator) {
        if (!this.__FsslAuthentication) {
            this.sslAuthentication = authenticator;
            return;
        }
        this.__IM.onSet((Object)this, "sslAuthentication", (Object)authenticator);
    }

    boolean __getuseMock() {
        if (!this.__FuseMock) {
            return this.useMock;
        }
        Object object = this.__IM.onGet((Object)this, "useMock");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setuseMock(boolean bl) {
        if (!this.__FuseMock) {
            this.useMock = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "useMock", (Object)bl2);
    }

    Boolean __getuseSmtps() {
        if (!this.__FuseSmtps) {
            return this.useSmtps;
        }
        return (Boolean)this.__IM.onGet((Object)this, "useSmtps");
    }

    void __setuseSmtps(Boolean bl) {
        if (!this.__FuseSmtps) {
            this.useSmtps = bl;
            return;
        }
        this.__IM.onSet((Object)this, "useSmtps", (Object)bl);
    }

    Connection __getconnection() {
        if (!this.__Fconnection) {
            return this.connection;
        }
        return (Connection)((Object)this.__IM.onGet((Object)this, "connection"));
    }

    void __setconnection(Connection connection) {
        if (!this.__Fconnection) {
            this.connection = connection;
            return;
        }
        this.__IM.onSet((Object)this, "connection", (Object)connection);
    }

    public Smtp() {
        this(null);
    }

    private Smtp(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    protected void configure() {
        if (!this.__Mconfigure) {
            this.__M_configure();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "configure", new Object[0]);
            this.__M_configure();
            this.__IM.onExit((Object)this, "configure", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "configure", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_configure() {
        this.__sethost(this.__getconfiguration().getWithDefault(CONFHOST, MOCK_SERVER_NAME));
        this.__setfrom(this.__getconfiguration().getWithDefault("mail.smtp.from", DEFAULT_FROM));
        this.__setfromName(this.__getconfiguration().getWithDefault("mail.smtp.from-name", null));
        this.__setuseMock(MOCK_SERVER_NAME.equals(this.__gethost()));
        this.__setproperties(new Properties());
        this.__setuseSmtps(this.__getconfiguration().getBooleanWithDefault("mail.smtps", Boolean.valueOf(false)));
        if (!this.__getuseSmtps().booleanValue()) {
            this.__setport(this.__getconfiguration().getIntegerWithDefault(CONFPORT, Integer.valueOf(25)));
        } else {
            this.__setport(this.__getconfiguration().getIntegerWithDefault(CONFPORT, Integer.valueOf(465)));
        }
        this.__getproperties().put(CONFHOST, this.__gethost());
        this.__getproperties().put(CONFPORT, (Object)this.__getport());
        this.__getproperties().put("mail.smtps.quitwait", this.__getconfiguration().getBooleanWithDefault("mail.smtp.quitwait", Boolean.valueOf(false)));
        List trustedServers = this.__getconfiguration().getList("mail.tls.trustedservers");
        if (!trustedServers.isEmpty()) {
            this.__getproperties().put("mail.smtp.ssl.trust", Joiner.on((char)',').join((Iterable)trustedServers));
        }
        this.__setconnection(Connection.valueOf(this.__getconfiguration().getWithDefault("mail.smtp.connection", Connection.NO_AUTH.toString())));
        this.__setusername(this.__getconfiguration().get("mail.smtp.username"));
        this.__setpassword(this.__getconfiguration().get("mail.smtp.password"));
        this.__setdebug(this.__getconfiguration().getBooleanWithDefault("mail.smtp.debug", Boolean.valueOf(false)));
        this.manageConnectionType();
        LOGGER.info("Configuring Wisdom Mailer with:");
        Enumeration<?> enumeration = this.__getproperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            LOGGER.info("\t" + name + ": " + this.__getproperties().get(name));
        }
        if (this.__getusername() != null) {
            LOGGER.info("\tusername: " + this.__getusername());
        }
        if (this.__getpassword() != null) {
            LOGGER.info("\tpassword set but not displayed");
        }
        LOGGER.info("\tfrom: " + this.__getfrom());
    }

    private void manageConnectionType() {
        if (!this.__MmanageConnectionType) {
            this.__M_manageConnectionType();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "manageConnectionType", new Object[0]);
            this.__M_manageConnectionType();
            this.__IM.onExit((Object)this, "manageConnectionType", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "manageConnectionType", throwable);
            throw throwable;
        }
    }

    private void __M_manageConnectionType() {
        switch (this.__getconnection()) {
            case SSL: {
                this.__getproperties().put(CONFAUTH, Boolean.toString(true));
                this.__getproperties().put("mail.smtp.socketFactory.port", Integer.toString(this.__getport()));
                this.__getproperties().put("mail.smtp.socketFactory.class", SSLSocketFactory.class.getName());
                this.__setsslAuthentication(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        PasswordAuthentication passwordAuthentication;
                        if (!Smtp.this.__M1___getPasswordAuthentication) {
                            return this.__M_getPasswordAuthentication();
                        }
                        try {
                            Smtp.this.__IM.onEntry((Object)this, "1___getPasswordAuthentication", new Object[0]);
                            passwordAuthentication = this.__M_getPasswordAuthentication();
                            Smtp.this.__IM.onExit((Object)this, "1___getPasswordAuthentication", (Object)passwordAuthentication);
                        }
                        catch (Throwable throwable) {
                            Smtp.this.__IM.onError((Object)this, "1___getPasswordAuthentication", throwable);
                            throw throwable;
                        }
                        return passwordAuthentication;
                    }

                    private PasswordAuthentication __M_getPasswordAuthentication() {
                        return new PasswordAuthentication(Smtp.this.__getusername(), Smtp.this.__getpassword());
                    }
                });
                break;
            }
            case TLS: {
                this.__getproperties().put(CONFAUTH, Boolean.toString(true));
                this.__getproperties().put("mail.smtp.starttls.enable", Boolean.toString(true));
                break;
            }
            default: {
                this.__getproperties().put(CONFAUTH, Boolean.toString(false));
            }
        }
    }

    public void reconfigure() {
        if (!this.__Mreconfigure) {
            this.__M_reconfigure();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "reconfigure", new Object[0]);
            this.__M_reconfigure();
            this.__IM.onExit((Object)this, "reconfigure", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "reconfigure", throwable);
            throw throwable;
        }
    }

    @Updated
    private void __M_reconfigure() {
        LOGGER.info("Reconfiguring the Wisdom Mailer");
        this.__setuseMock(false);
        this.configure();
    }

    @Override
    public void send(String to, String cc, String subject, String body) throws Exception {
        if (!this.__Msend$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__M_send(to, cc, subject, body);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "send$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{to, cc, subject, body});
            this.__M_send(to, cc, subject, body);
            this.__IM.onExit((Object)this, "send$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "send$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_send(String to, String cc, String subject, String body) throws Exception {
        this.send(to, cc, subject, body, null);
    }

    @Override
    public void send(String to, String cc, String subject, String body, List<File> attachments) throws Exception {
        if (!this.__Msend$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_util_List) {
            this.__M_send(to, cc, subject, body, attachments);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "send$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_util_List", new Object[]{to, cc, subject, body, attachments});
            this.__M_send(to, cc, subject, body, attachments);
            this.__IM.onExit((Object)this, "send$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_util_List", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "send$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_util_List", throwable);
            throw throwable;
        }
    }

    private void __M_send(String to, String cc, String subject, String body, List<File> attachments) throws Exception {
        if (attachments != null && !attachments.isEmpty()) {
            this.send(new Mail().to(to).cc(cc).subject(subject).body(body).attach(attachments));
        } else {
            this.send(new Mail().to(to).cc(cc).subject(subject).body(body));
        }
    }

    @Override
    public void send(Mail mail) throws MessagingException {
        if (!this.__Msend$org_ow2_chameleon_mail_Mail) {
            this.__M_send(mail);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "send$org_ow2_chameleon_mail_Mail", new Object[]{mail});
            this.__M_send(mail);
            this.__IM.onExit((Object)this, "send$org_ow2_chameleon_mail_Mail", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "send$org_ow2_chameleon_mail_Mail", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_send(Mail mail) throws MessagingException {
        if (mail.to() == null || mail.to().isEmpty()) {
            throw new IllegalArgumentException("The given 'to' is null or empty");
        }
        if (mail.from() == null) {
            mail.from(this.__getfrom());
        }
        Service transport = null;
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Smtp.class.getClassLoader());
            Session session = Session.getDefaultInstance(this.__getproperties(), this.__getsslAuthentication());
            session.setDebug(this.__getdebug());
            MimeMessage msg = new MimeMessage(session);
            if (this.__getfromName() != null) {
                try {
                    msg.setFrom(new InternetAddress(mail.from(), this.__getfromName()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Bad encoding to set the sender name", e);
                }
            } else {
                msg.setFrom(new InternetAddress(mail.from()));
            }
            msg.setRecipients(Message.RecipientType.TO, Smtp.convert(mail.to()));
            msg.setRecipients(Message.RecipientType.CC, Smtp.convert(mail.cc()));
            msg.setSubject(mail.subject());
            Date sent = new Date();
            msg.setSentDate(sent);
            mail.sent(sent);
            this.addBodyToMessage(mail, msg);
            if (this.__getuseMock()) {
                this.sendMessageWithMockServer(mail, msg);
                return;
            }
            transport = this.__getuseSmtps() != false ? session.getTransport("smtps") : session.getTransport("smtp");
            if (this.__getconnection() == Connection.TLS) {
                transport.connect(this.__gethost(), this.__getport(), this.__getusername(), this.__getpassword());
            } else {
                transport.connect();
            }
            ((Transport)transport).sendMessage(msg, msg.getAllRecipients());
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
            if (transport != null) {
                transport.close();
            }
        }
    }

    private void addBodyToMessage(Mail mail, MimeMessage msg) throws MessagingException {
        if (!this.__MaddBodyToMessage$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage) {
            this.__M_addBodyToMessage(mail, msg);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addBodyToMessage$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage", new Object[]{mail, msg});
            this.__M_addBodyToMessage(mail, msg);
            this.__IM.onExit((Object)this, "addBodyToMessage$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addBodyToMessage$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage", throwable);
            throw throwable;
        }
    }

    private void __M_addBodyToMessage(Mail mail, MimeMessage msg) throws MessagingException {
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart body = new MimeBodyPart();
        if (mail.subType() != null) {
            body.setText(mail.body(), mail.charset(), mail.subType());
        } else {
            body.setText(mail.body(), mail.charset(), "plain");
        }
        ((Multipart)mp).addBodyPart(body);
        List<File> attachments = mail.attachments();
        if (attachments != null && !attachments.isEmpty()) {
            for (File file : attachments) {
                MimeBodyPart part = new MimeBodyPart();
                FileDataSource source = new FileDataSource(file);
                part.setDataHandler(new DataHandler(source));
                part.setFileName(file.getName());
                ((Multipart)mp).addBodyPart(part);
            }
        }
        msg.setContent(mp);
    }

    private void sendMessageWithMockServer(Mail mail, MimeMessage msg) throws MessagingException {
        if (!this.__MsendMessageWithMockServer$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage) {
            this.__M_sendMessageWithMockServer(mail, msg);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "sendMessageWithMockServer$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage", new Object[]{mail, msg});
            this.__M_sendMessageWithMockServer(mail, msg);
            this.__IM.onExit((Object)this, "sendMessageWithMockServer$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "sendMessageWithMockServer$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage", throwable);
            throw throwable;
        }
    }

    private void __M_sendMessageWithMockServer(Mail mail, MimeMessage msg) throws MessagingException {
        Enumeration enumeration = msg.getAllHeaders();
        LOGGER.info("Sending mail:");
        while (enumeration.hasMoreElements()) {
            Header header = (Header)enumeration.nextElement();
            LOGGER.info("\t" + header.getName() + " = " + header.getValue());
        }
        LOGGER.info("\tContent-Type = " + msg.getContentType());
        LOGGER.info("\tEncoding = " + msg.getEncoding());
        LOGGER.info(SEPARATOR);
        LOGGER.info(mail.body());
        LOGGER.info(SEPARATOR);
        LOGGER.info(SEPARATOR);
    }

    public static InternetAddress[] convert(List<String> addresses) throws AddressException {
        ArrayList<InternetAddress> list = new ArrayList<InternetAddress>();
        for (String ad : addresses) {
            list.add(new InternetAddress(ad));
        }
        return list.toArray(new InternetAddress[addresses.size()]);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("configuration")) {
                this.__Fconfiguration = true;
            }
            if (set.contains("connection")) {
                this.__Fconnection = true;
            }
            if (set.contains("debug")) {
                this.__Fdebug = true;
            }
            if (set.contains("from")) {
                this.__Ffrom = true;
            }
            if (set.contains("fromName")) {
                this.__FfromName = true;
            }
            if (set.contains("host")) {
                this.__Fhost = true;
            }
            if (set.contains("password")) {
                this.__Fpassword = true;
            }
            if (set.contains("port")) {
                this.__Fport = true;
            }
            if (set.contains("properties")) {
                this.__Fproperties = true;
            }
            if (set.contains("sslAuthentication")) {
                this.__FsslAuthentication = true;
            }
            if (set.contains("useMock")) {
                this.__FuseMock = true;
            }
            if (set.contains("useSmtps")) {
                this.__FuseSmtps = true;
            }
            if (set.contains("username")) {
                this.__Fusername = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("1___getPasswordAuthentication")) {
                this.__M1___getPasswordAuthentication = true;
            }
            if (set.contains("configure")) {
                this.__Mconfigure = true;
            }
            if (set.contains("manageConnectionType")) {
                this.__MmanageConnectionType = true;
            }
            if (set.contains("reconfigure")) {
                this.__Mreconfigure = true;
            }
            if (set.contains("send$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__Msend$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("send$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_util_List")) {
                this.__Msend$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_util_List = true;
            }
            if (set.contains("send$org_ow2_chameleon_mail_Mail")) {
                this.__Msend$org_ow2_chameleon_mail_Mail = true;
            }
            if (set.contains("addBodyToMessage$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage")) {
                this.__MaddBodyToMessage$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage = true;
            }
            if (set.contains("sendMessageWithMockServer$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage")) {
                this.__MsendMessageWithMockServer$org_ow2_chameleon_mail_Mail$javax_mail_internet_MimeMessage = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    public static enum Connection {
        NO_AUTH,
        TLS,
        SSL;

    }
}

