/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.dashboard;

import com.codahale.metrics.Counter;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Context;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.wisdom.api.DefaultController;
import org.wisdom.api.annotations.Controller;
import org.wisdom.api.annotations.Path;
import org.wisdom.api.annotations.Route;
import org.wisdom.api.annotations.View;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.content.Json;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Result;
import org.wisdom.api.http.websockets.Publisher;
import org.wisdom.api.security.Authenticated;
import org.wisdom.api.templates.Template;
import org.wisdom.monitor.extensions.dashboard.CpuGaugeSet;
import org.wisdom.monitor.extensions.dashboard.HealthState;
import org.wisdom.monitor.extensions.dashboard.HttpMetricFilter;
import org.wisdom.monitor.extensions.dashboard.RuntimeGaugeSet;
import org.wisdom.monitor.service.HealthCheck;
import org.wisdom.monitor.service.MonitorExtension;

@Path(value="/monitor/dashboard")
@Authenticated(value="Monitor-Authenticator")
@Controller
public class DashboardExtension
extends DefaultController
implements MonitorExtension,
Pojo {
    InstanceManager __IM;
    boolean __M1___run;
    boolean __M2___matches$java_lang_String$com_codahale_metrics_Metric;
    private boolean __Fpublisher;
    @Requires
    Publisher publisher;
    private boolean __Fconfiguration;
    @Requires
    ApplicationConfiguration configuration;
    private boolean __Fjson;
    @Requires
    Json json;
    private boolean __Fscheduler;
    @Requires(filter="(name=wisdom-system-scheduler)", proxy=false)
    protected ScheduledExecutorService scheduler;
    private boolean __FhealthChecks;
    @Requires(specification=HealthCheck.class, optional=true)
    List<HealthCheck> healthChecks;
    private boolean __Fmonitor;
    @View(value="monitor/dashboard")
    Template monitor;
    private boolean __Fbc;
    @Context
    BundleContext bc;
    private boolean __Fregistry;
    final MetricRegistry registry;
    private boolean __Ftask;
    private ScheduledFuture task;
    private boolean __FhttpMetricFilter;
    private HttpMetricFilter httpMetricFilter;
    private boolean __Freg;
    private ServiceRegistration<MetricRegistry> reg;
    boolean __Mstart;
    boolean __Mmetrics;
    boolean __MgetData;
    boolean __MgetHealth;
    boolean __Mthreads;
    boolean __Mstack$java_lang_StackTraceElement__;
    boolean __Mstop;
    boolean __Mindex;
    boolean __Mlabel;
    boolean __Murl;
    boolean __Mcategory;

    Publisher __getpublisher() {
        if (!this.__Fpublisher) {
            return this.publisher;
        }
        return (Publisher)this.__IM.onGet((Object)this, "publisher");
    }

    void __setpublisher(Publisher publisher) {
        if (!this.__Fpublisher) {
            this.publisher = publisher;
            return;
        }
        this.__IM.onSet((Object)this, "publisher", (Object)publisher);
    }

    ApplicationConfiguration __getconfiguration() {
        if (!this.__Fconfiguration) {
            return this.configuration;
        }
        return (ApplicationConfiguration)this.__IM.onGet((Object)this, "configuration");
    }

    void __setconfiguration(ApplicationConfiguration applicationConfiguration) {
        if (!this.__Fconfiguration) {
            this.configuration = applicationConfiguration;
            return;
        }
        this.__IM.onSet((Object)this, "configuration", (Object)applicationConfiguration);
    }

    Json __getjson() {
        if (!this.__Fjson) {
            return this.json;
        }
        return (Json)this.__IM.onGet((Object)this, "json");
    }

    void __setjson(Json json) {
        if (!this.__Fjson) {
            this.json = json;
            return;
        }
        this.__IM.onSet((Object)this, "json", (Object)json);
    }

    ScheduledExecutorService __getscheduler() {
        if (!this.__Fscheduler) {
            return this.scheduler;
        }
        return (ScheduledExecutorService)this.__IM.onGet((Object)this, "scheduler");
    }

    void __setscheduler(ScheduledExecutorService scheduledExecutorService) {
        if (!this.__Fscheduler) {
            this.scheduler = scheduledExecutorService;
            return;
        }
        this.__IM.onSet((Object)this, "scheduler", (Object)scheduledExecutorService);
    }

    List __gethealthChecks() {
        if (!this.__FhealthChecks) {
            return this.healthChecks;
        }
        return (List)this.__IM.onGet((Object)this, "healthChecks");
    }

    void __sethealthChecks(List list) {
        if (!this.__FhealthChecks) {
            this.healthChecks = list;
            return;
        }
        this.__IM.onSet((Object)this, "healthChecks", (Object)list);
    }

    Template __getmonitor() {
        if (!this.__Fmonitor) {
            return this.monitor;
        }
        return (Template)this.__IM.onGet((Object)this, "monitor");
    }

    void __setmonitor(Template template) {
        if (!this.__Fmonitor) {
            this.monitor = template;
            return;
        }
        this.__IM.onSet((Object)this, "monitor", (Object)template);
    }

    BundleContext __getbc() {
        if (!this.__Fbc) {
            return this.bc;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "bc");
    }

    void __setbc(BundleContext bundleContext) {
        if (!this.__Fbc) {
            this.bc = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "bc", (Object)bundleContext);
    }

    MetricRegistry __getregistry() {
        if (!this.__Fregistry) {
            return this.registry;
        }
        return (MetricRegistry)this.__IM.onGet((Object)this, "registry");
    }

    void __setregistry(MetricRegistry metricRegistry) {
        if (!this.__Fregistry) {
            this.registry = metricRegistry;
            return;
        }
        this.__IM.onSet((Object)this, "registry", (Object)metricRegistry);
    }

    ScheduledFuture __gettask() {
        if (!this.__Ftask) {
            return this.task;
        }
        return (ScheduledFuture)this.__IM.onGet((Object)this, "task");
    }

    void __settask(ScheduledFuture scheduledFuture) {
        if (!this.__Ftask) {
            this.task = scheduledFuture;
            return;
        }
        this.__IM.onSet((Object)this, "task", (Object)scheduledFuture);
    }

    HttpMetricFilter __gethttpMetricFilter() {
        if (!this.__FhttpMetricFilter) {
            return this.httpMetricFilter;
        }
        return (HttpMetricFilter)this.__IM.onGet((Object)this, "httpMetricFilter");
    }

    void __sethttpMetricFilter(HttpMetricFilter httpMetricFilter) {
        if (!this.__FhttpMetricFilter) {
            this.httpMetricFilter = httpMetricFilter;
            return;
        }
        this.__IM.onSet((Object)this, "httpMetricFilter", (Object)httpMetricFilter);
    }

    ServiceRegistration __getreg() {
        if (!this.__Freg) {
            return this.reg;
        }
        return (ServiceRegistration)this.__IM.onGet((Object)this, "reg");
    }

    void __setreg(ServiceRegistration serviceRegistration) {
        if (!this.__Freg) {
            this.reg = serviceRegistration;
            return;
        }
        this.__IM.onSet((Object)this, "reg", (Object)serviceRegistration);
    }

    public DashboardExtension() {
        this(null);
    }

    private DashboardExtension(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setregistry(new MetricRegistry());
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        this.logger().info("Registering JVM metrics");
        this.__getregistry().register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
        this.__getregistry().register("jvm.garbage", (Metric)new GarbageCollectorMetricSet());
        this.__getregistry().register("jvm.threads", (Metric)new ThreadStatesGaugeSet());
        this.__getregistry().register("jvm.buffers", (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        this.__getregistry().register("jvm.cpu", (Metric)new CpuGaugeSet());
        this.__getregistry().register("jvm.runtime", (Metric)new RuntimeGaugeSet());
        if (this.__getconfiguration().getBooleanWithDefault("monitor.http.enabled", Boolean.valueOf(true)).booleanValue()) {
            this.logger().info("Registering HTTP metrics");
            this.__sethttpMetricFilter(new HttpMetricFilter(this.__getbc(), this.__getconfiguration(), this.__getregistry()));
            this.__gethttpMetricFilter().start();
        }
        if (this.__getconfiguration().getBooleanWithDefault("monitor.jmx.enabled", Boolean.valueOf(true)).booleanValue()) {
            this.logger().info("Initializing Metrics JMX reporting");
            JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.__getregistry()).build();
            jmxReporter.start();
        }
        if (this.__getconfiguration().getBooleanWithDefault("monitor.graphite.enabled", Boolean.valueOf(false)).booleanValue()) {
            this.logger().info("Initializing Metrics Graphite reporting");
            String graphiteHost = this.__getconfiguration().getOrDie("monitor.graphite.host");
            int graphitePort = this.__getconfiguration().getIntegerOrDie("monitor.graphite.port");
            Graphite graphite = new Graphite(new InetSocketAddress(graphiteHost, graphitePort));
            GraphiteReporter graphiteReporter = GraphiteReporter.forRegistry((MetricRegistry)this.__getregistry()).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(graphite);
            graphiteReporter.start(1L, TimeUnit.MINUTES);
        }
        this.logger().info("Registering the metric registry as service");
        this.__setreg(this.__getbc().registerService(MetricRegistry.class, (Object)this.__getregistry(), null));
        this.__settask(this.__getscheduler().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (!DashboardExtension.this.__M1___run) {
                    this.__M_run();
                    return;
                }
                try {
                    DashboardExtension.this.__IM.onEntry((Object)this, "1___run", new Object[0]);
                    this.__M_run();
                    DashboardExtension.this.__IM.onExit((Object)this, "1___run", null);
                }
                catch (Throwable throwable) {
                    DashboardExtension.this.__IM.onError((Object)this, "1___run", throwable);
                    throw throwable;
                }
            }

            private void __M_run() {
                DashboardExtension.this.__getpublisher().publish("/monitor/update", DashboardExtension.this.__getjson().toJson((Object)DashboardExtension.this.getData()));
            }
        }, 0L, 10L, TimeUnit.SECONDS));
    }

    @Route(uri="/metrics", method=HttpMethod.GET)
    public Result metrics() {
        Result result;
        if (!this.__Mmetrics) {
            return this.__M_metrics();
        }
        try {
            this.__IM.onEntry((Object)this, "metrics", new Object[0]);
            result = this.__M_metrics();
            this.__IM.onExit((Object)this, "metrics", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "metrics", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_metrics() {
        return DashboardExtension.ok(this.getData()).json();
    }

    private ImmutableMap<String, ?> getData() {
        ImmutableMap<String, ?> immutableMap;
        if (!this.__MgetData) {
            return this.__M_getData();
        }
        try {
            this.__IM.onEntry((Object)this, "getData", new Object[0]);
            immutableMap = this.__M_getData();
            this.__IM.onExit((Object)this, "getData", immutableMap);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getData", throwable);
            throw throwable;
        }
        return immutableMap;
    }

    private ImmutableMap<String, ?> __M_getData() {
        long active = 0L;
        Counter counter = this.__getregistry().counter("http.activeRequests");
        if (counter != null) {
            active = counter.getCount();
        }
        return ImmutableMap.builder().put((Object)"gauges", (Object)this.__getregistry().getGauges()).put((Object)"activeRequests", (Object)active).put((Object)"timers", (Object)this.__getregistry().getTimers()).put((Object)"counters", (Object)this.__getregistry().getCounters()).put((Object)"meters", (Object)this.__getregistry().getMeters()).put((Object)"histograms", (Object)this.__getregistry().getHistograms()).put((Object)"health", this.getHealth()).build();
    }

    private SortedMap<String, HealthState> getHealth() {
        SortedMap<String, HealthState> sortedMap;
        if (!this.__MgetHealth) {
            return this.__M_getHealth();
        }
        try {
            this.__IM.onEntry((Object)this, "getHealth", new Object[0]);
            sortedMap = this.__M_getHealth();
            this.__IM.onExit((Object)this, "getHealth", sortedMap);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getHealth", throwable);
            throw throwable;
        }
        return sortedMap;
    }

    private SortedMap<String, HealthState> __M_getHealth() {
        TreeMap<String, HealthState> map = new TreeMap<String, HealthState>();
        for (HealthCheck hc : this.__gethealthChecks()) {
            try {
                if (hc.check()) {
                    map.put(hc.name(), HealthState.ok());
                    continue;
                }
                map.put(hc.name(), HealthState.ko());
            }
            catch (Exception e) {
                map.put(hc.name(), HealthState.ko(e));
            }
        }
        return map;
    }

    @Route(uri="/threads", method=HttpMethod.GET)
    public Result threads() {
        Result result;
        if (!this.__Mthreads) {
            return this.__M_threads();
        }
        try {
            this.__IM.onEntry((Object)this, "threads", new Object[0]);
            result = this.__M_threads();
            this.__IM.onExit((Object)this, "threads", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "threads", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_threads() {
        ArrayNode array = this.__getjson().newArray();
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        for (long id : bean.getAllThreadIds()) {
            ObjectNode node = this.__getjson().newObject();
            ThreadInfo ti = bean.getThreadInfo(id, 10);
            node.put("threadName", ti.getThreadName()).put("threadId", ti.getThreadId()).put("blockedTime", ti.getBlockedTime()).put("blockedCount", ti.getBlockedCount()).put("lockName", ti.getLockName()).put("waitedTime", ti.getWaitedTime()).put("waitedCount", ti.getWaitedCount()).put("threadState", ti.getThreadState().toString()).put("stack", this.stack(ti.getStackTrace()));
            array.add((JsonNode)node);
        }
        return DashboardExtension.ok((JsonNode)array);
    }

    private String stack(StackTraceElement[] stackTrace) {
        String string;
        if (!this.__Mstack$java_lang_StackTraceElement__) {
            return this.__M_stack(stackTrace);
        }
        try {
            this.__IM.onEntry((Object)this, "stack$java_lang_StackTraceElement__", new Object[]{stackTrace});
            string = this.__M_stack(stackTrace);
            this.__IM.onExit((Object)this, "stack$java_lang_StackTraceElement__", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stack$java_lang_StackTraceElement__", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_stack(StackTraceElement[] stackTrace) {
        StringBuilder stack = new StringBuilder();
        for (StackTraceElement element : stackTrace) {
            if (stack.length() != 0) {
                stack.append('\n');
            }
            stack.append(element.getClassName()).append(".").append(element.getMethodName()).append(" (").append(element.getFileName()).append(':').append(element.getLineNumber()).append(')');
        }
        return stack.toString();
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        if (this.__getreg() != null) {
            this.__getreg().unregister();
            this.__setreg(null);
        }
        if (this.__gettask() != null && !this.__gettask().isCancelled()) {
            this.__gettask().cancel(true);
        }
        if (this.__gethttpMetricFilter() != null) {
            this.__gethttpMetricFilter().stop();
        }
        this.__getregistry().removeMatching(new MetricFilter(){

            public boolean matches(String string, Metric metric) {
                boolean bl;
                if (!DashboardExtension.this.__M2___matches$java_lang_String$com_codahale_metrics_Metric) {
                    return this.__M_matches(string, metric);
                }
                try {
                    DashboardExtension.this.__IM.onEntry((Object)this, "2___matches$java_lang_String$com_codahale_metrics_Metric", new Object[]{string, metric});
                    bl = this.__M_matches(string, metric);
                    DashboardExtension.this.__IM.onExit((Object)this, "2___matches$java_lang_String$com_codahale_metrics_Metric", (Object)new Boolean(bl));
                }
                catch (Throwable throwable) {
                    DashboardExtension.this.__IM.onError((Object)this, "2___matches$java_lang_String$com_codahale_metrics_Metric", throwable);
                    throw throwable;
                }
                return bl;
            }

            private boolean __M_matches(String s, Metric metric) {
                return true;
            }
        });
    }

    @Route(uri="", method=HttpMethod.GET)
    public Result index() {
        Result result;
        if (!this.__Mindex) {
            return this.__M_index();
        }
        try {
            this.__IM.onEntry((Object)this, "index", new Object[0]);
            result = this.__M_index();
            this.__IM.onExit((Object)this, "index", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "index", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_index() {
        return DashboardExtension.ok((Object)this.render(this.__getmonitor()));
    }

    @Override
    public String label() {
        String string;
        if (!this.__Mlabel) {
            return this.__M_label();
        }
        try {
            this.__IM.onEntry((Object)this, "label", new Object[0]);
            string = this.__M_label();
            this.__IM.onExit((Object)this, "label", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "label", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_label() {
        return "Dashboard";
    }

    @Override
    public String url() {
        String string;
        if (!this.__Murl) {
            return this.__M_url();
        }
        try {
            this.__IM.onEntry((Object)this, "url", new Object[0]);
            string = this.__M_url();
            this.__IM.onExit((Object)this, "url", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "url", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_url() {
        return "/monitor/dashboard";
    }

    @Override
    public String category() {
        String string;
        if (!this.__Mcategory) {
            return this.__M_category();
        }
        try {
            this.__IM.onEntry((Object)this, "category", new Object[0]);
            string = this.__M_category();
            this.__IM.onExit((Object)this, "category", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "category", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_category() {
        return "root";
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("bc")) {
                this.__Fbc = true;
            }
            if (set.contains("configuration")) {
                this.__Fconfiguration = true;
            }
            if (set.contains("healthChecks")) {
                this.__FhealthChecks = true;
            }
            if (set.contains("httpMetricFilter")) {
                this.__FhttpMetricFilter = true;
            }
            if (set.contains("json")) {
                this.__Fjson = true;
            }
            if (set.contains("monitor")) {
                this.__Fmonitor = true;
            }
            if (set.contains("publisher")) {
                this.__Fpublisher = true;
            }
            if (set.contains("reg")) {
                this.__Freg = true;
            }
            if (set.contains("registry")) {
                this.__Fregistry = true;
            }
            if (set.contains("scheduler")) {
                this.__Fscheduler = true;
            }
            if (set.contains("task")) {
                this.__Ftask = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("1___run")) {
                this.__M1___run = true;
            }
            if (set.contains("2___matches$java_lang_String$com_codahale_metrics_Metric")) {
                this.__M2___matches$java_lang_String$com_codahale_metrics_Metric = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("metrics")) {
                this.__Mmetrics = true;
            }
            if (set.contains("getData")) {
                this.__MgetData = true;
            }
            if (set.contains("getHealth")) {
                this.__MgetHealth = true;
            }
            if (set.contains("threads")) {
                this.__Mthreads = true;
            }
            if (set.contains("stack$java_lang_StackTraceElement__")) {
                this.__Mstack$java_lang_StackTraceElement__ = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("index")) {
                this.__Mindex = true;
            }
            if (set.contains("label")) {
                this.__Mlabel = true;
            }
            if (set.contains("url")) {
                this.__Murl = true;
            }
            if (set.contains("category")) {
                this.__Mcategory = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

