/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.dashboard;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.api.http.Result;
import org.wisdom.api.http.Status;
import org.wisdom.api.interception.Filter;
import org.wisdom.api.interception.RequestContext;
import org.wisdom.api.router.Route;

public class HttpMetricFilter
implements Filter,
Status {
    private final BundleContext context;
    private final Pattern interceptionPattern;
    private final Integer interceptionPriority;
    private ServiceRegistration<Filter> reg;
    private ConcurrentMap<Integer, Meter> metersByStatusCode;
    private Meter otherMeter;
    private Counter activeRequests;
    private Timer requestTimer;

    public HttpMetricFilter(BundleContext context, ApplicationConfiguration configuration, MetricRegistry registry) {
        this.context = context;
        Map<Integer, String> meterNamesByStatusCode = HttpMetricFilter.createMeterNamesByStatusCode();
        this.interceptionPattern = Pattern.compile(configuration.getWithDefault("monitor.http.interception", ".*"));
        this.interceptionPriority = configuration.getIntegerWithDefault("monitor.http.priority", Integer.valueOf(10000));
        this.metersByStatusCode = new ConcurrentHashMap<Integer, Meter>(meterNamesByStatusCode.size());
        for (Map.Entry<Integer, String> entry : meterNamesByStatusCode.entrySet()) {
            this.metersByStatusCode.put(entry.getKey(), registry.meter("http.responseCodes." + entry.getValue()));
        }
        this.otherMeter = registry.meter("http.responseCodes.others");
        this.activeRequests = registry.counter("http.activeRequests");
        this.requestTimer = registry.timer("http.requests");
    }

    private static Map<Integer, String> createMeterNamesByStatusCode() {
        HashMap<Integer, String> meterNamesByStatusCode = new HashMap<Integer, String>(6);
        meterNamesByStatusCode.put(200, "ok");
        meterNamesByStatusCode.put(304, "notModified");
        meterNamesByStatusCode.put(400, "badRequest");
        meterNamesByStatusCode.put(404, "notFound");
        meterNamesByStatusCode.put(500, "serverError");
        return meterNamesByStatusCode;
    }

    public void start() {
        this.reg = this.context.registerService(Filter.class, (Object)this, null);
    }

    public void stop() {
        if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result call(Route route, RequestContext context) throws Exception {
        this.activeRequests.inc();
        Timer.Context ctxt = this.requestTimer.time();
        Result result = null;
        try {
            Result result2 = result = context.proceed();
            return result2;
        }
        finally {
            ctxt.stop();
            this.activeRequests.dec();
            this.markMeterForStatusCode(result);
        }
    }

    private void markMeterForStatusCode(Result result) {
        if (result == null) {
            this.otherMeter.mark();
            return;
        }
        Meter metric = (Meter)this.metersByStatusCode.get(result.getStatusCode());
        if (metric != null) {
            metric.mark();
        } else {
            this.otherMeter.mark();
        }
    }

    public Pattern uri() {
        return this.interceptionPattern;
    }

    public int priority() {
        return this.interceptionPriority;
    }
}

