/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.executors;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.wisdom.api.DefaultController;
import org.wisdom.api.annotations.Controller;
import org.wisdom.api.annotations.Route;
import org.wisdom.api.annotations.View;
import org.wisdom.api.concurrent.ManagedExecutorService;
import org.wisdom.api.concurrent.ManagedScheduledExecutorService;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Result;
import org.wisdom.api.security.Authenticated;
import org.wisdom.api.templates.Template;
import org.wisdom.monitor.service.MonitorExtension;

@Authenticated(value="Monitor-Authenticator")
@Controller
public class ExecutorExtension
extends DefaultController
implements MonitorExtension,
Pojo {
    InstanceManager __IM;
    boolean __M1___getMetrics;
    boolean __M2___getMetrics;
    private boolean __Fexecutors;
    @Requires
    ManagedExecutorService[] executors;
    private boolean __Fschedulers;
    @Requires
    ManagedScheduledExecutorService[] schedulers;
    private boolean __Fmetrics;
    @Requires
    MetricRegistry metrics;
    private boolean __Ftemplate;
    @View(value="monitor/executors")
    Template template;
    boolean __Mstart;
    boolean __MmetricsForExecutor$org_wisdom_api_concurrent_ManagedExecutorService;
    boolean __MgetExecutors;
    boolean __MgetSchedulers;
    boolean __Mindex;
    boolean __Mdata;
    boolean __MgetExecutorsAsMap$org_wisdom_api_concurrent_ManagedExecutorService__;
    boolean __MgetHungTasks;
    boolean __MgetCompletedTasks;
    boolean __Mlabel;
    boolean __Murl;
    boolean __Mcategory;

    ManagedExecutorService[] __getexecutors() {
        if (!this.__Fexecutors) {
            return this.executors;
        }
        return (ManagedExecutorService[])this.__IM.onGet((Object)this, "executors");
    }

    void __setexecutors(ManagedExecutorService[] managedExecutorServiceArray) {
        if (!this.__Fexecutors) {
            this.executors = managedExecutorServiceArray;
            return;
        }
        this.__IM.onSet((Object)this, "executors", (Object)managedExecutorServiceArray);
    }

    ManagedScheduledExecutorService[] __getschedulers() {
        if (!this.__Fschedulers) {
            return this.schedulers;
        }
        return (ManagedScheduledExecutorService[])this.__IM.onGet((Object)this, "schedulers");
    }

    void __setschedulers(ManagedScheduledExecutorService[] managedScheduledExecutorServiceArray) {
        if (!this.__Fschedulers) {
            this.schedulers = managedScheduledExecutorServiceArray;
            return;
        }
        this.__IM.onSet((Object)this, "schedulers", (Object)managedScheduledExecutorServiceArray);
    }

    MetricRegistry __getmetrics() {
        if (!this.__Fmetrics) {
            return this.metrics;
        }
        return (MetricRegistry)this.__IM.onGet((Object)this, "metrics");
    }

    void __setmetrics(MetricRegistry metricRegistry) {
        if (!this.__Fmetrics) {
            this.metrics = metricRegistry;
            return;
        }
        this.__IM.onSet((Object)this, "metrics", (Object)metricRegistry);
    }

    Template __gettemplate() {
        if (!this.__Ftemplate) {
            return this.template;
        }
        return (Template)this.__IM.onGet((Object)this, "template");
    }

    void __settemplate(Template template) {
        if (!this.__Ftemplate) {
            this.template = template;
            return;
        }
        this.__IM.onSet((Object)this, "template", (Object)template);
    }

    public ExecutorExtension() {
        this(null);
    }

    private ExecutorExtension(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        this.__getmetrics().register("executors", (Metric)new MetricSet(){

            public Map<String, Metric> getMetrics() {
                Map<String, Metric> map;
                if (!ExecutorExtension.this.__M1___getMetrics) {
                    return this.__M_getMetrics();
                }
                try {
                    ExecutorExtension.this.__IM.onEntry((Object)this, "1___getMetrics", new Object[0]);
                    map = this.__M_getMetrics();
                    ExecutorExtension.this.__IM.onExit((Object)this, "1___getMetrics", map);
                }
                catch (Throwable throwable) {
                    ExecutorExtension.this.__IM.onError((Object)this, "1___getMetrics", throwable);
                    throw throwable;
                }
                return map;
            }

            private Map<String, Metric> __M_getMetrics() {
                return ImmutableMap.of((Object)"executors.count", (Object)new Gauge<Integer>(){

                    public Integer getValue() {
                        return ExecutorExtension.this.getExecutors().length;
                    }
                }, (Object)"schedulers.count", (Object)new Gauge<Integer>(){

                    public Integer getValue() {
                        return ExecutorExtension.this.getSchedulers().length;
                    }
                }, (Object)"hung.count", (Object)new Gauge<Integer>(){

                    public Integer getValue() {
                        return ExecutorExtension.this.getHungTasks();
                    }
                }, (Object)"completed.count", (Object)new Gauge<Integer>(){

                    public Integer getValue() {
                        return ExecutorExtension.this.getCompletedTasks();
                    }
                });
            }
        });
        for (ManagedExecutorService managedExecutorService : this.__getexecutors()) {
            this.__getmetrics().register(managedExecutorService.name(), (Metric)this.metricsForExecutor(managedExecutorService));
        }
        for (ManagedExecutorService managedExecutorService : this.__getschedulers()) {
            this.__getmetrics().register(managedExecutorService.name(), (Metric)this.metricsForExecutor(managedExecutorService));
        }
    }

    private MetricSet metricsForExecutor(ManagedExecutorService executor) {
        MetricSet metricSet;
        if (!this.__MmetricsForExecutor$org_wisdom_api_concurrent_ManagedExecutorService) {
            return this.__M_metricsForExecutor(executor);
        }
        try {
            this.__IM.onEntry((Object)this, "metricsForExecutor$org_wisdom_api_concurrent_ManagedExecutorService", new Object[]{executor});
            metricSet = this.__M_metricsForExecutor(executor);
            this.__IM.onExit((Object)this, "metricsForExecutor$org_wisdom_api_concurrent_ManagedExecutorService", (Object)metricSet);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "metricsForExecutor$org_wisdom_api_concurrent_ManagedExecutorService", throwable);
            throw throwable;
        }
        return metricSet;
    }

    private MetricSet __M_metricsForExecutor(final ManagedExecutorService executor) {
        return new MetricSet(){

            public Map<String, Metric> getMetrics() {
                Map<String, Metric> map;
                if (!ExecutorExtension.this.__M2___getMetrics) {
                    return this.__M_getMetrics();
                }
                try {
                    ExecutorExtension.this.__IM.onEntry((Object)this, "2___getMetrics", new Object[0]);
                    map = this.__M_getMetrics();
                    ExecutorExtension.this.__IM.onExit((Object)this, "2___getMetrics", map);
                }
                catch (Throwable throwable) {
                    ExecutorExtension.this.__IM.onError((Object)this, "2___getMetrics", throwable);
                    throw throwable;
                }
                return map;
            }

            private Map<String, Metric> __M_getMetrics() {
                return ImmutableMap.builder().put((Object)"queue", (Object)new Gauge<Integer>(){

                    public Integer getValue() {
                        return executor.getQueue().size();
                    }
                }).put((Object)"completed", (Object)new Counter(){

                    public long getCount() {
                        return executor.getCompletedTaskCount();
                    }
                }).put((Object)"hung", (Object)new Gauge<Integer>(){

                    public Integer getValue() {
                        return executor.getHungTasks().size();
                    }
                }).put((Object)"active", (Object)new Gauge<Integer>(){

                    public Integer getValue() {
                        return executor.getActiveCount();
                    }
                }).put((Object)"pool", (Object)new Gauge<Integer>(){

                    public Integer getValue() {
                        return executor.getPoolSize();
                    }
                }).put((Object)"largest", (Object)new Gauge<Integer>(){

                    public Integer getValue() {
                        return executor.getLargestPoolSize();
                    }
                }).put((Object)"max_exec", (Object)new Gauge<Long>(){

                    public Long getValue() {
                        return executor.getExecutionTimeStatistics().getMaximumExecutionTime();
                    }
                }).put((Object)"total", (Object)new Gauge<Long>(){

                    public Long getValue() {
                        return executor.getExecutionTimeStatistics().getTotalExecutionTime();
                    }
                }).put((Object)"min_exec", (Object)new Gauge<Long>(){

                    public Long getValue() {
                        return executor.getExecutionTimeStatistics().getMinimumExecutionTime();
                    }
                }).put((Object)"avg", (Object)new Gauge<Double>(){

                    public Double getValue() {
                        return executor.getExecutionTimeStatistics().getAverageExecutionTime();
                    }
                }).build();
            }
        };
    }

    private ManagedExecutorService[] getExecutors() {
        ManagedExecutorService[] managedExecutorServiceArray;
        if (!this.__MgetExecutors) {
            return this.__M_getExecutors();
        }
        try {
            this.__IM.onEntry((Object)this, "getExecutors", new Object[0]);
            managedExecutorServiceArray = this.__M_getExecutors();
            this.__IM.onExit((Object)this, "getExecutors", (Object)managedExecutorServiceArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getExecutors", throwable);
            throw throwable;
        }
        return managedExecutorServiceArray;
    }

    private ManagedExecutorService[] __M_getExecutors() {
        return this.__getexecutors();
    }

    private ManagedScheduledExecutorService[] getSchedulers() {
        ManagedScheduledExecutorService[] managedScheduledExecutorServiceArray;
        if (!this.__MgetSchedulers) {
            return this.__M_getSchedulers();
        }
        try {
            this.__IM.onEntry((Object)this, "getSchedulers", new Object[0]);
            managedScheduledExecutorServiceArray = this.__M_getSchedulers();
            this.__IM.onExit((Object)this, "getSchedulers", (Object)managedScheduledExecutorServiceArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getSchedulers", throwable);
            throw throwable;
        }
        return managedScheduledExecutorServiceArray;
    }

    private ManagedScheduledExecutorService[] __M_getSchedulers() {
        return this.__getschedulers();
    }

    @Route(uri="/monitor/executors", method=HttpMethod.GET)
    public Result index() {
        Result result;
        if (!this.__Mindex) {
            return this.__M_index();
        }
        try {
            this.__IM.onEntry((Object)this, "index", new Object[0]);
            result = this.__M_index();
            this.__IM.onExit((Object)this, "index", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "index", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_index() {
        return ExecutorExtension.ok((Object)this.render(this.__gettemplate()));
    }

    @Route(uri="/monitor/executors.json", method=HttpMethod.GET)
    public Result data() {
        Result result;
        if (!this.__Mdata) {
            return this.__M_data();
        }
        try {
            this.__IM.onEntry((Object)this, "data", new Object[0]);
            result = this.__M_data();
            this.__IM.onExit((Object)this, "data", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "data", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_data() {
        return ExecutorExtension.ok((Object)ImmutableMap.builder().put((Object)"executors", this.getExecutorsAsMap(this.__getexecutors())).put((Object)"schedulers", this.getExecutorsAsMap((ManagedExecutorService[])this.__getschedulers())).put((Object)"hung", (Object)this.getHungTasks()).put((Object)"completed", (Object)this.getCompletedTasks()).build());
    }

    private Map<String, ManagedExecutorService> getExecutorsAsMap(ManagedExecutorService[] exec) {
        Map<String, ManagedExecutorService> map;
        if (!this.__MgetExecutorsAsMap$org_wisdom_api_concurrent_ManagedExecutorService__) {
            return this.__M_getExecutorsAsMap(exec);
        }
        try {
            this.__IM.onEntry((Object)this, "getExecutorsAsMap$org_wisdom_api_concurrent_ManagedExecutorService__", new Object[]{exec});
            map = this.__M_getExecutorsAsMap(exec);
            this.__IM.onExit((Object)this, "getExecutorsAsMap$org_wisdom_api_concurrent_ManagedExecutorService__", map);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getExecutorsAsMap$org_wisdom_api_concurrent_ManagedExecutorService__", throwable);
            throw throwable;
        }
        return map;
    }

    private Map<String, ManagedExecutorService> __M_getExecutorsAsMap(ManagedExecutorService[] exec) {
        LinkedHashMap<String, ManagedExecutorService> map = new LinkedHashMap<String, ManagedExecutorService>();
        for (ManagedExecutorService svc : exec) {
            map.put(svc.name(), svc);
        }
        return map;
    }

    private int getHungTasks() {
        int n;
        if (!this.__MgetHungTasks) {
            return this.__M_getHungTasks();
        }
        try {
            this.__IM.onEntry((Object)this, "getHungTasks", new Object[0]);
            n = this.__M_getHungTasks();
            this.__IM.onExit((Object)this, "getHungTasks", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getHungTasks", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_getHungTasks() {
        int count = 0;
        for (ManagedExecutorService managedExecutorService : this.__getexecutors()) {
            count += managedExecutorService.getHungTasks().size();
        }
        for (ManagedExecutorService managedExecutorService : this.__getschedulers()) {
            count += managedExecutorService.getHungTasks().size();
        }
        return count;
    }

    private int getCompletedTasks() {
        int n;
        if (!this.__MgetCompletedTasks) {
            return this.__M_getCompletedTasks();
        }
        try {
            this.__IM.onEntry((Object)this, "getCompletedTasks", new Object[0]);
            n = this.__M_getCompletedTasks();
            this.__IM.onExit((Object)this, "getCompletedTasks", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCompletedTasks", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_getCompletedTasks() {
        int count = 0;
        for (ManagedExecutorService managedExecutorService : this.__getexecutors()) {
            count = (int)((long)count + managedExecutorService.getCompletedTaskCount());
        }
        for (ManagedExecutorService managedExecutorService : this.__getschedulers()) {
            count = (int)((long)count + managedExecutorService.getCompletedTaskCount());
        }
        return count;
    }

    @Override
    public String label() {
        String string;
        if (!this.__Mlabel) {
            return this.__M_label();
        }
        try {
            this.__IM.onEntry((Object)this, "label", new Object[0]);
            string = this.__M_label();
            this.__IM.onExit((Object)this, "label", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "label", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_label() {
        return "Executors";
    }

    @Override
    public String url() {
        String string;
        if (!this.__Murl) {
            return this.__M_url();
        }
        try {
            this.__IM.onEntry((Object)this, "url", new Object[0]);
            string = this.__M_url();
            this.__IM.onExit((Object)this, "url", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "url", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_url() {
        return "/monitor/executors";
    }

    @Override
    public String category() {
        String string;
        if (!this.__Mcategory) {
            return this.__M_category();
        }
        try {
            this.__IM.onEntry((Object)this, "category", new Object[0]);
            string = this.__M_category();
            this.__IM.onExit((Object)this, "category", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "category", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_category() {
        return "wisdom";
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("executors")) {
                this.__Fexecutors = true;
            }
            if (set.contains("metrics")) {
                this.__Fmetrics = true;
            }
            if (set.contains("schedulers")) {
                this.__Fschedulers = true;
            }
            if (set.contains("template")) {
                this.__Ftemplate = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("1___getMetrics")) {
                this.__M1___getMetrics = true;
            }
            if (set.contains("2___getMetrics")) {
                this.__M2___getMetrics = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("metricsForExecutor$org_wisdom_api_concurrent_ManagedExecutorService")) {
                this.__MmetricsForExecutor$org_wisdom_api_concurrent_ManagedExecutorService = true;
            }
            if (set.contains("getExecutors")) {
                this.__MgetExecutors = true;
            }
            if (set.contains("getSchedulers")) {
                this.__MgetSchedulers = true;
            }
            if (set.contains("index")) {
                this.__Mindex = true;
            }
            if (set.contains("data")) {
                this.__Mdata = true;
            }
            if (set.contains("getExecutorsAsMap$org_wisdom_api_concurrent_ManagedExecutorService__")) {
                this.__MgetExecutorsAsMap$org_wisdom_api_concurrent_ManagedExecutorService__ = true;
            }
            if (set.contains("getHungTasks")) {
                this.__MgetHungTasks = true;
            }
            if (set.contains("getCompletedTasks")) {
                this.__MgetCompletedTasks = true;
            }
            if (set.contains("label")) {
                this.__Mlabel = true;
            }
            if (set.contains("url")) {
                this.__Murl = true;
            }
            if (set.contains("category")) {
                this.__Mcategory = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

