/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.ipojo;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.HandlerFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class FactoryModel {
    private final Factory factory;

    public static List<FactoryModel> factories(BundleContext context) {
        ArrayList<FactoryModel> factories = new ArrayList<FactoryModel>();
        try {
            for (ServiceReference ref : context.getServiceReferences(Factory.class, null)) {
                factories.add(new FactoryModel((Factory)context.getService(ref)));
            }
            for (ServiceReference ref : context.getServiceReferences(HandlerFactory.class, null)) {
                factories.add(new FactoryModel((Factory)context.getService(ref)));
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return factories;
    }

    protected FactoryModel(Factory factory) {
        this.factory = factory;
    }

    public String getName() {
        if (this.factory.getVersion() == null) {
            return this.factory.getName();
        }
        return this.factory.getName() + " - " + this.factory.getVersion();
    }

    public boolean isHandler() {
        return this.factory instanceof HandlerFactory;
    }

    public String getArchitecture() {
        return this.factory.getDescription().toString();
    }

    public String getHandlerName() {
        if (this.factory instanceof HandlerFactory) {
            return ((HandlerFactory)this.factory).getHandlerName();
        }
        return null;
    }

    public String getState() {
        if (this.factory.getState() == 0) {
            return "INVALID";
        }
        return "VALID";
    }
}

