/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.ipojo;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Context;
import org.apache.felix.ipojo.extender.InstanceDeclaration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.wisdom.api.DefaultController;
import org.wisdom.api.annotations.Controller;
import org.wisdom.api.annotations.Path;
import org.wisdom.api.annotations.Route;
import org.wisdom.api.annotations.View;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Result;
import org.wisdom.api.security.Authenticated;
import org.wisdom.api.templates.Template;
import org.wisdom.monitor.extensions.ipojo.FactoryModel;
import org.wisdom.monitor.extensions.ipojo.InstanceModel;
import org.wisdom.monitor.service.MonitorExtension;

@Path(value="/monitor/ipojo")
@Authenticated(value="Monitor-Authenticator")
@Controller
public class IPOJOController
extends DefaultController
implements MonitorExtension,
Pojo {
    InstanceManager __IM;
    private boolean __Fipojo;
    @View(value="monitor/ipojo")
    Template ipojo;
    private boolean __Fcontext;
    @Context
    BundleContext context;
    boolean __Mipojo;
    boolean __Mdata;
    boolean __MgetUnboundDeclarationCount;
    boolean __Mlabel;
    boolean __Murl;
    boolean __Mcategory;

    Template __getipojo() {
        if (!this.__Fipojo) {
            return this.ipojo;
        }
        return (Template)this.__IM.onGet((Object)this, "ipojo");
    }

    void __setipojo(Template template) {
        if (!this.__Fipojo) {
            this.ipojo = template;
            return;
        }
        this.__IM.onSet((Object)this, "ipojo", (Object)template);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    public IPOJOController() {
        this(null);
    }

    private IPOJOController(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    @Route(uri="/", method=HttpMethod.GET)
    public Result ipojo() {
        Result result;
        if (!this.__Mipojo) {
            return this.__M_ipojo();
        }
        try {
            this.__IM.onEntry((Object)this, "ipojo", new Object[0]);
            result = this.__M_ipojo();
            this.__IM.onExit((Object)this, "ipojo", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "ipojo", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_ipojo() {
        return IPOJOController.ok((Object)this.render(this.__getipojo()));
    }

    @Route(uri=".json", method=HttpMethod.GET)
    public Result data() {
        Result result;
        if (!this.__Mdata) {
            return this.__M_data();
        }
        try {
            this.__IM.onEntry((Object)this, "data", new Object[0]);
            result = this.__M_data();
            this.__IM.onExit((Object)this, "data", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "data", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_data() {
        List<InstanceModel> instances = InstanceModel.instances(this.__getcontext());
        List<FactoryModel> factories = FactoryModel.factories(this.__getcontext());
        int valid = 0;
        int invalid = 0;
        int stopped = 0;
        for (InstanceModel model : instances) {
            if (model.getState().equals("VALID")) {
                ++valid;
                continue;
            }
            if (model.getState().equals("INVALID")) {
                ++invalid;
                continue;
            }
            if (!model.getState().equals("STOPPED")) continue;
            ++stopped;
        }
        return IPOJOController.ok((Object)ImmutableMap.builder().put((Object)"instances", instances).put((Object)"factories", factories).put((Object)"valid", (Object)valid).put((Object)"invalid", (Object)invalid).put((Object)"stopped", (Object)stopped).put((Object)"unbound", (Object)Integer.toString(this.getUnboundDeclarationCount())).build()).json();
    }

    private int getUnboundDeclarationCount() {
        int n;
        if (!this.__MgetUnboundDeclarationCount) {
            return this.__M_getUnboundDeclarationCount();
        }
        try {
            this.__IM.onEntry((Object)this, "getUnboundDeclarationCount", new Object[0]);
            n = this.__M_getUnboundDeclarationCount();
            this.__IM.onExit((Object)this, "getUnboundDeclarationCount", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getUnboundDeclarationCount", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_getUnboundDeclarationCount() {
        int count = 0;
        try {
            Collection list = this.__getcontext().getServiceReferences(InstanceDeclaration.class, null);
            for (ServiceReference ref : list) {
                InstanceDeclaration declaration = (InstanceDeclaration)this.__getcontext().getService(ref);
                if (declaration.getStatus().isBound()) continue;
                ++count;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return count;
    }

    @Override
    public String label() {
        String string;
        if (!this.__Mlabel) {
            return this.__M_label();
        }
        try {
            this.__IM.onEntry((Object)this, "label", new Object[0]);
            string = this.__M_label();
            this.__IM.onExit((Object)this, "label", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "label", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_label() {
        return "iPOJO";
    }

    @Override
    public String url() {
        String string;
        if (!this.__Murl) {
            return this.__M_url();
        }
        try {
            this.__IM.onEntry((Object)this, "url", new Object[0]);
            string = this.__M_url();
            this.__IM.onExit((Object)this, "url", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "url", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_url() {
        return "/monitor/ipojo/";
    }

    @Override
    public String category() {
        String string;
        if (!this.__Mcategory) {
            return this.__M_category();
        }
        try {
            this.__IM.onEntry((Object)this, "category", new Object[0]);
            string = this.__M_category();
            this.__IM.onExit((Object)this, "category", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "category", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_category() {
        return "osgi";
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("ipojo")) {
                this.__Fipojo = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("ipojo")) {
                this.__Mipojo = true;
            }
            if (set.contains("data")) {
                this.__Mdata = true;
            }
            if (set.contains("getUnboundDeclarationCount")) {
                this.__MgetUnboundDeclarationCount = true;
            }
            if (set.contains("label")) {
                this.__Mlabel = true;
            }
            if (set.contains("url")) {
                this.__Murl = true;
            }
            if (set.contains("category")) {
                this.__Mcategory = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

