/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.logger;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import java.util.ArrayList;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.DefaultController;
import org.wisdom.api.annotations.Controller;
import org.wisdom.api.annotations.Parameter;
import org.wisdom.api.annotations.Route;
import org.wisdom.api.annotations.View;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Result;
import org.wisdom.api.security.Authenticated;
import org.wisdom.api.templates.Template;
import org.wisdom.monitor.extensions.logger.LoggerModel;
import org.wisdom.monitor.service.MonitorExtension;

@Authenticated(value="Monitor-Authenticator")
@Controller
public class LoggerExtension
extends DefaultController
implements MonitorExtension,
Pojo {
    InstanceManager __IM;
    private boolean __Ftemplate;
    @View(value="monitor/loggers")
    Template template;
    boolean __Mindex;
    boolean __Mloggers;
    boolean __MsetLevel$java_lang_String$java_lang_String;
    boolean __Mlabel;
    boolean __Murl;
    boolean __Mcategory;

    Template __gettemplate() {
        if (!this.__Ftemplate) {
            return this.template;
        }
        return (Template)this.__IM.onGet((Object)this, "template");
    }

    void __settemplate(Template template) {
        if (!this.__Ftemplate) {
            this.template = template;
            return;
        }
        this.__IM.onSet((Object)this, "template", (Object)template);
    }

    public LoggerExtension() {
        this(null);
    }

    private LoggerExtension(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    @Route(uri="/monitor/logs", method=HttpMethod.GET)
    public Result index() {
        Result result;
        if (!this.__Mindex) {
            return this.__M_index();
        }
        try {
            this.__IM.onEntry((Object)this, "index", new Object[0]);
            result = this.__M_index();
            this.__IM.onExit((Object)this, "index", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "index", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_index() {
        return LoggerExtension.ok((Object)this.render(this.__gettemplate()));
    }

    @Route(uri="/monitor/logs/loggers", method=HttpMethod.GET)
    public Result loggers() {
        Result result;
        if (!this.__Mloggers) {
            return this.__M_loggers();
        }
        try {
            this.__IM.onEntry((Object)this, "loggers", new Object[0]);
            result = this.__M_loggers();
            this.__IM.onExit((Object)this, "loggers", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loggers", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_loggers() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        ArrayList<LoggerModel> loggers = new ArrayList<LoggerModel>();
        for (Logger logger : context.getLoggerList()) {
            loggers.add(new LoggerModel(logger));
        }
        return LoggerExtension.ok(loggers).json();
    }

    @Route(uri="/monitor/logs/{name}", method=HttpMethod.PUT)
    public Result setLevel(@Parameter(value="name") String loggerName, @Parameter(value="level") String level) {
        Result result;
        if (!this.__MsetLevel$java_lang_String$java_lang_String) {
            return this.__M_setLevel(loggerName, level);
        }
        try {
            this.__IM.onEntry((Object)this, "setLevel$java_lang_String$java_lang_String", new Object[]{loggerName, level});
            result = this.__M_setLevel(loggerName, level);
            this.__IM.onExit((Object)this, "setLevel$java_lang_String$java_lang_String", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setLevel$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_setLevel(String loggerName, String level) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger logger = context.getLogger(loggerName);
        if (logger != null) {
            this.logger().info("Setting the log level of {} to {}", (Object)loggerName, (Object)level);
            logger.setLevel(Level.toLevel((String)level));
            return this.loggers();
        }
        this.logger().warn("Cannot set the level of logger {} - the logger does not exist", (Object)loggerName);
        return LoggerExtension.notFound();
    }

    @Override
    public String label() {
        String string;
        if (!this.__Mlabel) {
            return this.__M_label();
        }
        try {
            this.__IM.onEntry((Object)this, "label", new Object[0]);
            string = this.__M_label();
            this.__IM.onExit((Object)this, "label", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "label", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_label() {
        return "Loggers";
    }

    @Override
    public String url() {
        String string;
        if (!this.__Murl) {
            return this.__M_url();
        }
        try {
            this.__IM.onEntry((Object)this, "url", new Object[0]);
            string = this.__M_url();
            this.__IM.onExit((Object)this, "url", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "url", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_url() {
        return "/monitor/logs";
    }

    @Override
    public String category() {
        String string;
        if (!this.__Mcategory) {
            return this.__M_category();
        }
        try {
            this.__IM.onEntry((Object)this, "category", new Object[0]);
            string = this.__M_category();
            this.__IM.onExit((Object)this, "category", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "category", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_category() {
        return "Wisdom";
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("template")) {
            this.__Ftemplate = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("index")) {
                this.__Mindex = true;
            }
            if (set.contains("loggers")) {
                this.__Mloggers = true;
            }
            if (set.contains("setLevel$java_lang_String$java_lang_String")) {
                this.__MsetLevel$java_lang_String$java_lang_String = true;
            }
            if (set.contains("label")) {
                this.__Mlabel = true;
            }
            if (set.contains("url")) {
                this.__Murl = true;
            }
            if (set.contains("category")) {
                this.__Mcategory = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

