/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.osgi;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.wisdom.monitor.extensions.osgi.BundleStates;

public class BundleModel {
    private final Bundle bundle;

    public BundleModel(Bundle bundle) {
        this.bundle = bundle;
    }

    public static List<BundleModel> bundles(BundleContext context) {
        ArrayList<BundleModel> bundles = new ArrayList<BundleModel>();
        for (Bundle bundle : context.getBundles()) {
            bundles.add(new BundleModel(bundle));
        }
        return bundles;
    }

    public String getState() {
        return BundleStates.from(this.bundle);
    }

    public long getId() {
        return this.bundle.getBundleId();
    }

    public String getName() {
        return this.bundle.getSymbolicName() + " - " + this.bundle.getVersion();
    }

    public Map<String, String> getHeaders() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Enumeration enumeration = this.bundle.getHeaders().keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            map.put(key, (String)this.bundle.getHeaders().get(key));
        }
        return map;
    }
}

