/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.osgi;

import com.google.common.collect.ImmutableMap;
import java.util.Dictionary;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Context;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.wisdom.api.DefaultController;
import org.wisdom.api.annotations.Controller;
import org.wisdom.api.annotations.DefaultValue;
import org.wisdom.api.annotations.FormParameter;
import org.wisdom.api.annotations.Parameter;
import org.wisdom.api.annotations.Path;
import org.wisdom.api.annotations.Route;
import org.wisdom.api.annotations.View;
import org.wisdom.api.http.FileItem;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Result;
import org.wisdom.api.http.Results;
import org.wisdom.api.security.Authenticated;
import org.wisdom.api.templates.Template;
import org.wisdom.monitor.extensions.osgi.BundleModel;
import org.wisdom.monitor.service.MonitorExtension;

@Path(value="/monitor/osgi/bundle")
@Authenticated(value="Monitor-Authenticator")
@Controller
public class BundleMonitorExtension
extends DefaultController
implements MonitorExtension,
Pojo {
    InstanceManager __IM;
    boolean __M1___call;
    boolean __M2___call;
    boolean __M3___call;
    boolean __MBundleEventCounter___start;
    boolean __MBundleEventCounter___reset;
    boolean __MBundleEventCounter___stop;
    boolean __MBundleEventCounter___bundleChanged$org_osgi_framework_BundleEvent;
    boolean __MBundleEventCounter___get;
    private boolean __Fbundles;
    @View(value="monitor/bundles")
    Template bundles;
    private boolean __Fcontext;
    @Context
    BundleContext context;
    private boolean __Fcounter;
    private BundleEventCounter counter;
    boolean __Mstart;
    boolean __Mstop;
    boolean __Mbundle;
    boolean __Mbundles;
    boolean __MgetInstalledBundleCount$java_util_List;
    boolean __MgetActiveBundleCount$java_util_List;
    boolean __MtoggleBundle$long;
    boolean __MupdateBundle$long;
    boolean __MinstallBundle$org_wisdom_api_http_FileItem$boolean;
    boolean __MuninstallBundle$long;
    boolean __Mlabel;
    boolean __Murl;
    boolean __Mcategory;

    Template __getbundles() {
        if (!this.__Fbundles) {
            return this.bundles;
        }
        return (Template)this.__IM.onGet((Object)this, "bundles");
    }

    void __setbundles(Template template) {
        if (!this.__Fbundles) {
            this.bundles = template;
            return;
        }
        this.__IM.onSet((Object)this, "bundles", (Object)template);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    BundleEventCounter __getcounter() {
        if (!this.__Fcounter) {
            return this.counter;
        }
        return (BundleEventCounter)this.__IM.onGet((Object)this, "counter");
    }

    void __setcounter(BundleEventCounter bundleEventCounter) {
        if (!this.__Fcounter) {
            this.counter = bundleEventCounter;
            return;
        }
        this.__IM.onSet((Object)this, "counter", (Object)bundleEventCounter);
    }

    public BundleMonitorExtension() {
        this(null);
    }

    private BundleMonitorExtension(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setcounter(new BundleEventCounter());
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        this.__getcounter().start();
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        this.__getcounter().stop();
    }

    @Route(uri="", method=HttpMethod.GET)
    public Result bundle() {
        Result result;
        if (!this.__Mbundle) {
            return this.__M_bundle();
        }
        try {
            this.__IM.onEntry((Object)this, "bundle", new Object[0]);
            result = this.__M_bundle();
            this.__IM.onExit((Object)this, "bundle", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bundle", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_bundle() {
        return BundleMonitorExtension.ok((Object)this.render(this.__getbundles()));
    }

    @Route(uri=".json", method=HttpMethod.GET)
    public Result bundles() {
        Result result;
        if (!this.__Mbundles) {
            return this.__M_bundles();
        }
        try {
            this.__IM.onEntry((Object)this, "bundles", new Object[0]);
            result = this.__M_bundles();
            this.__IM.onExit((Object)this, "bundles", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bundles", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_bundles() {
        List<BundleModel> list = BundleModel.bundles(this.__getcontext());
        return BundleMonitorExtension.ok((Object)ImmutableMap.of((Object)"bundles", list, (Object)"events", (Object)this.__getcounter().get(), (Object)"active", (Object)this.getActiveBundleCount(list), (Object)"installed", (Object)this.getInstalledBundleCount(list))).json();
    }

    private int getInstalledBundleCount(List<BundleModel> bundles) {
        int n;
        if (!this.__MgetInstalledBundleCount$java_util_List) {
            return this.__M_getInstalledBundleCount(bundles);
        }
        try {
            this.__IM.onEntry((Object)this, "getInstalledBundleCount$java_util_List", new Object[]{bundles});
            n = this.__M_getInstalledBundleCount(bundles);
            this.__IM.onExit((Object)this, "getInstalledBundleCount$java_util_List", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getInstalledBundleCount$java_util_List", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_getInstalledBundleCount(List<BundleModel> bundles) {
        int count = 0;
        for (BundleModel bundle : bundles) {
            if (!"INSTALLED".equals(bundle.getState())) continue;
            ++count;
        }
        return count;
    }

    private int getActiveBundleCount(List<BundleModel> bundles) {
        int n;
        if (!this.__MgetActiveBundleCount$java_util_List) {
            return this.__M_getActiveBundleCount(bundles);
        }
        try {
            this.__IM.onEntry((Object)this, "getActiveBundleCount$java_util_List", new Object[]{bundles});
            n = this.__M_getActiveBundleCount(bundles);
            this.__IM.onExit((Object)this, "getActiveBundleCount$java_util_List", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getActiveBundleCount$java_util_List", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_getActiveBundleCount(List<BundleModel> bundles) {
        int count = 0;
        for (BundleModel bundle : bundles) {
            if (!"ACTIVE".equals(bundle.getState())) continue;
            ++count;
        }
        return count;
    }

    @Route(uri="/{id}", method=HttpMethod.GET)
    public Result toggleBundle(@Parameter(value="id") long id) {
        Result result;
        if (!this.__MtoggleBundle$long) {
            return this.__M_toggleBundle(id);
        }
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new Long(id);
            this.__IM.onEntry((Object)this, "toggleBundle$long", objectArray);
            result = this.__M_toggleBundle(id);
            this.__IM.onExit((Object)this, "toggleBundle$long", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "toggleBundle$long", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_toggleBundle(long id) {
        Bundle bundle = this.__getcontext().getBundle(id);
        if (bundle == null) {
            return BundleMonitorExtension.notFound((String)("Bundle " + id + " not found"));
        }
        if (!BundleMonitorExtension.isFragment(bundle)) {
            if (bundle.getState() == 32) {
                try {
                    bundle.stop();
                }
                catch (BundleException e) {
                    this.logger().error("Cannot stop bundle {}", (Object)bundle.getSymbolicName(), (Object)e);
                    return BundleMonitorExtension.badRequest((Object)((Object)e));
                }
            } else if (bundle.getState() == 2 || bundle.getState() == 4) {
                try {
                    bundle.start();
                }
                catch (BundleException e) {
                    this.logger().error("Cannot start bundle {}", (Object)bundle.getSymbolicName(), (Object)e);
                    return BundleMonitorExtension.badRequest((Object)((Object)e));
                }
            }
        } else if (bundle.getState() == 4) {
            try {
                bundle.stop();
            }
            catch (BundleException e) {
                this.logger().error("Cannot stop bundle {}", (Object)bundle.getSymbolicName(), (Object)e);
                return BundleMonitorExtension.badRequest((Object)((Object)e));
            }
        }
        return BundleMonitorExtension.ok();
    }

    @Route(uri="/{id}", method=HttpMethod.POST)
    public Result updateBundle(@Parameter(value="id") long id) {
        Result result;
        if (!this.__MupdateBundle$long) {
            return this.__M_updateBundle(id);
        }
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new Long(id);
            this.__IM.onEntry((Object)this, "updateBundle$long", objectArray);
            result = this.__M_updateBundle(id);
            this.__IM.onExit((Object)this, "updateBundle$long", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updateBundle$long", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_updateBundle(long id) {
        final Bundle bundle = this.__getcontext().getBundle(id);
        if (bundle == null) {
            return BundleMonitorExtension.notFound((String)("Bundle " + id + " not found"));
        }
        return BundleMonitorExtension.async((Callable)new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                Result result;
                if (!BundleMonitorExtension.this.__M1___call) {
                    return this.__M_call();
                }
                try {
                    BundleMonitorExtension.this.__IM.onEntry((Object)this, "1___call", new Object[0]);
                    result = this.__M_call();
                    BundleMonitorExtension.this.__IM.onExit((Object)this, "1___call", (Object)result);
                }
                catch (Throwable throwable) {
                    BundleMonitorExtension.this.__IM.onError((Object)this, "1___call", throwable);
                    throw throwable;
                }
                return result;
            }

            private Result __M_call() throws Exception {
                try {
                    BundleMonitorExtension.this.logger().info("Updating bundle {} from {}", (Object)bundle.getSymbolicName(), (Object)bundle.getLocation());
                    bundle.update();
                    return Results.ok();
                }
                catch (BundleException e) {
                    BundleMonitorExtension.this.logger().error("Cannot update bundle {}", (Object)bundle.getSymbolicName(), (Object)e);
                    return Results.badRequest((Object)((Object)e));
                }
            }

            private Object __M_call() throws Exception {
                return this.call();
            }
        });
    }

    @Route(uri="", method=HttpMethod.POST)
    public Result installBundle(@FormParameter(value="bundle") FileItem bundle, @FormParameter(value="start") @DefaultValue(value="false") boolean startIfNeeded) {
        Result result;
        if (!this.__MinstallBundle$org_wisdom_api_http_FileItem$boolean) {
            return this.__M_installBundle(bundle, startIfNeeded);
        }
        try {
            this.__IM.onEntry((Object)this, "installBundle$org_wisdom_api_http_FileItem$boolean", new Object[]{bundle, new Boolean(startIfNeeded)});
            result = this.__M_installBundle(bundle, startIfNeeded);
            this.__IM.onExit((Object)this, "installBundle$org_wisdom_api_http_FileItem$boolean", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "installBundle$org_wisdom_api_http_FileItem$boolean", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_installBundle(final FileItem bundle, final boolean startIfNeeded) {
        if (bundle != null) {
            return BundleMonitorExtension.async((Callable)new Callable<Result>(){

                @Override
                public Result call() throws Exception {
                    Result result;
                    if (!BundleMonitorExtension.this.__M2___call) {
                        return this.__M_call();
                    }
                    try {
                        BundleMonitorExtension.this.__IM.onEntry((Object)this, "2___call", new Object[0]);
                        result = this.__M_call();
                        BundleMonitorExtension.this.__IM.onExit((Object)this, "2___call", (Object)result);
                    }
                    catch (Throwable throwable) {
                        BundleMonitorExtension.this.__IM.onError((Object)this, "2___call", throwable);
                        throw throwable;
                    }
                    return result;
                }

                private Result __M_call() throws Exception {
                    Bundle b;
                    try {
                        b = BundleMonitorExtension.this.__getcontext().installBundle("file/temp/" + bundle.name(), bundle.stream());
                        BundleMonitorExtension.this.logger().info("Bundle {} installed", (Object)b.getSymbolicName());
                    }
                    catch (BundleException e) {
                        BundleMonitorExtension.this.flash("error", "Cannot install bundle '" + bundle.name() + "' : " + e.getMessage());
                        return BundleMonitorExtension.this.bundle();
                    }
                    if (startIfNeeded && !BundleMonitorExtension.isFragment(b)) {
                        try {
                            b.start();
                            BundleMonitorExtension.this.flash("success", "Bundle '" + b.getSymbolicName() + "' installed and started");
                            return BundleMonitorExtension.this.bundle();
                        }
                        catch (BundleException e) {
                            BundleMonitorExtension.this.flash("error", "Bundle '" + b.getSymbolicName() + "' installed but " + "failed to start: " + e.getMessage());
                            return BundleMonitorExtension.this.bundle();
                        }
                    }
                    BundleMonitorExtension.this.flash("success", "Bundle '" + b.getSymbolicName() + "' installed.");
                    return BundleMonitorExtension.this.bundle();
                }

                private Object __M_call() throws Exception {
                    return this.call();
                }
            });
        }
        this.logger().error("No bundle to install");
        this.flash("error", "Unable to install the bundle - no uploaded file");
        return this.bundle();
    }

    @Route(uri="/{id}", method=HttpMethod.DELETE)
    public Result uninstallBundle(@Parameter(value="id") long id) {
        Result result;
        if (!this.__MuninstallBundle$long) {
            return this.__M_uninstallBundle(id);
        }
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new Long(id);
            this.__IM.onEntry((Object)this, "uninstallBundle$long", objectArray);
            result = this.__M_uninstallBundle(id);
            this.__IM.onExit((Object)this, "uninstallBundle$long", (Object)result);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "uninstallBundle$long", throwable);
            throw throwable;
        }
        return result;
    }

    private Result __M_uninstallBundle(long id) {
        final Bundle bundle = this.__getcontext().getBundle(id);
        if (bundle == null) {
            return BundleMonitorExtension.notFound((String)("Bundle " + id + " not found"));
        }
        return BundleMonitorExtension.async((Callable)new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                Result result;
                if (!BundleMonitorExtension.this.__M3___call) {
                    return this.__M_call();
                }
                try {
                    BundleMonitorExtension.this.__IM.onEntry((Object)this, "3___call", new Object[0]);
                    result = this.__M_call();
                    BundleMonitorExtension.this.__IM.onExit((Object)this, "3___call", (Object)result);
                }
                catch (Throwable throwable) {
                    BundleMonitorExtension.this.__IM.onError((Object)this, "3___call", throwable);
                    throw throwable;
                }
                return result;
            }

            private Result __M_call() throws Exception {
                try {
                    BundleMonitorExtension.this.logger().info("Uninstalling bundle {}", (Object)bundle.getSymbolicName());
                    bundle.uninstall();
                    return Results.ok();
                }
                catch (BundleException e) {
                    BundleMonitorExtension.this.logger().error("Cannot uninstall bundle {}", (Object)bundle.getSymbolicName(), (Object)e);
                    return Results.badRequest((Object)((Object)e));
                }
            }

            private Object __M_call() throws Exception {
                return this.call();
            }
        });
    }

    @Override
    public String label() {
        String string;
        if (!this.__Mlabel) {
            return this.__M_label();
        }
        try {
            this.__IM.onEntry((Object)this, "label", new Object[0]);
            string = this.__M_label();
            this.__IM.onExit((Object)this, "label", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "label", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_label() {
        return "Bundles";
    }

    @Override
    public String url() {
        String string;
        if (!this.__Murl) {
            return this.__M_url();
        }
        try {
            this.__IM.onEntry((Object)this, "url", new Object[0]);
            string = this.__M_url();
            this.__IM.onExit((Object)this, "url", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "url", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_url() {
        return "/monitor/osgi/bundle";
    }

    @Override
    public String category() {
        String string;
        if (!this.__Mcategory) {
            return this.__M_category();
        }
        try {
            this.__IM.onEntry((Object)this, "category", new Object[0]);
            string = this.__M_category();
            this.__IM.onExit((Object)this, "category", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "category", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_category() {
        return "osgi";
    }

    public static boolean isFragment(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        return headers.get("Fragment-Host") != null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("bundles")) {
                this.__Fbundles = true;
            }
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("counter")) {
                this.__Fcounter = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("1___call")) {
                this.__M1___call = true;
            }
            if (set.contains("2___call")) {
                this.__M2___call = true;
            }
            if (set.contains("3___call")) {
                this.__M3___call = true;
            }
            if (set.contains("BundleEventCounter___start")) {
                this.__MBundleEventCounter___start = true;
            }
            if (set.contains("BundleEventCounter___reset")) {
                this.__MBundleEventCounter___reset = true;
            }
            if (set.contains("BundleEventCounter___stop")) {
                this.__MBundleEventCounter___stop = true;
            }
            if (set.contains("BundleEventCounter___bundleChanged$org_osgi_framework_BundleEvent")) {
                this.__MBundleEventCounter___bundleChanged$org_osgi_framework_BundleEvent = true;
            }
            if (set.contains("BundleEventCounter___get")) {
                this.__MBundleEventCounter___get = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("bundle")) {
                this.__Mbundle = true;
            }
            if (set.contains("bundles")) {
                this.__Mbundles = true;
            }
            if (set.contains("getInstalledBundleCount$java_util_List")) {
                this.__MgetInstalledBundleCount$java_util_List = true;
            }
            if (set.contains("getActiveBundleCount$java_util_List")) {
                this.__MgetActiveBundleCount$java_util_List = true;
            }
            if (set.contains("toggleBundle$long")) {
                this.__MtoggleBundle$long = true;
            }
            if (set.contains("updateBundle$long")) {
                this.__MupdateBundle$long = true;
            }
            if (set.contains("installBundle$org_wisdom_api_http_FileItem$boolean")) {
                this.__MinstallBundle$org_wisdom_api_http_FileItem$boolean = true;
            }
            if (set.contains("uninstallBundle$long")) {
                this.__MuninstallBundle$long = true;
            }
            if (set.contains("label")) {
                this.__Mlabel = true;
            }
            if (set.contains("url")) {
                this.__Murl = true;
            }
            if (set.contains("category")) {
                this.__Mcategory = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    private class BundleEventCounter
    implements BundleListener {
        int counter = 0;

        private BundleEventCounter() {
        }

        public void start() {
            if (!BundleMonitorExtension.this.__MBundleEventCounter___start) {
                this.__M_start();
                return;
            }
            try {
                BundleMonitorExtension.this.__IM.onEntry((Object)this, "BundleEventCounter___start", new Object[0]);
                this.__M_start();
                BundleMonitorExtension.this.__IM.onExit((Object)this, "BundleEventCounter___start", null);
            }
            catch (Throwable throwable) {
                BundleMonitorExtension.this.__IM.onError((Object)this, "BundleEventCounter___start", throwable);
                throw throwable;
            }
        }

        private void __M_start() {
            BundleMonitorExtension.this.__getcontext().addBundleListener((BundleListener)this);
        }

        public void reset() {
            if (!BundleMonitorExtension.this.__MBundleEventCounter___reset) {
                this.__M_reset();
                return;
            }
            try {
                BundleMonitorExtension.this.__IM.onEntry((Object)this, "BundleEventCounter___reset", new Object[0]);
                this.__M_reset();
                BundleMonitorExtension.this.__IM.onExit((Object)this, "BundleEventCounter___reset", null);
            }
            catch (Throwable throwable) {
                BundleMonitorExtension.this.__IM.onError((Object)this, "BundleEventCounter___reset", throwable);
                throw throwable;
            }
        }

        private void __M_reset() {
            this.counter = 0;
        }

        public void stop() {
            if (!BundleMonitorExtension.this.__MBundleEventCounter___stop) {
                this.__M_stop();
                return;
            }
            try {
                BundleMonitorExtension.this.__IM.onEntry((Object)this, "BundleEventCounter___stop", new Object[0]);
                this.__M_stop();
                BundleMonitorExtension.this.__IM.onExit((Object)this, "BundleEventCounter___stop", null);
            }
            catch (Throwable throwable) {
                BundleMonitorExtension.this.__IM.onError((Object)this, "BundleEventCounter___stop", throwable);
                throw throwable;
            }
        }

        private void __M_stop() {
            BundleMonitorExtension.this.__getcontext().removeBundleListener((BundleListener)this);
        }

        public void bundleChanged(BundleEvent bundleEvent) {
            if (!BundleMonitorExtension.this.__MBundleEventCounter___bundleChanged$org_osgi_framework_BundleEvent) {
                this.__M_bundleChanged(bundleEvent);
                return;
            }
            try {
                BundleMonitorExtension.this.__IM.onEntry((Object)this, "BundleEventCounter___bundleChanged$org_osgi_framework_BundleEvent", new Object[]{bundleEvent});
                this.__M_bundleChanged(bundleEvent);
                BundleMonitorExtension.this.__IM.onExit((Object)this, "BundleEventCounter___bundleChanged$org_osgi_framework_BundleEvent", null);
            }
            catch (Throwable throwable) {
                BundleMonitorExtension.this.__IM.onError((Object)this, "BundleEventCounter___bundleChanged$org_osgi_framework_BundleEvent", throwable);
                throw throwable;
            }
        }

        private void __M_bundleChanged(BundleEvent event) {
            ++this.counter;
        }

        public int get() {
            int n;
            if (!BundleMonitorExtension.this.__MBundleEventCounter___get) {
                return this.__M_get();
            }
            try {
                BundleMonitorExtension.this.__IM.onEntry((Object)this, "BundleEventCounter___get", new Object[0]);
                n = this.__M_get();
                BundleMonitorExtension.this.__IM.onExit((Object)this, "BundleEventCounter___get", (Object)new Integer(n));
            }
            catch (Throwable throwable) {
                BundleMonitorExtension.this.__IM.onError((Object)this, "BundleEventCounter___get", throwable);
                throw throwable;
            }
            return n;
        }

        private int __M_get() {
            return this.counter;
        }
    }
}

