/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.osgi;

import org.osgi.framework.Bundle;

public final class BundleStates {
    public static final String ACTIVE = "ACTIVE";
    public static final String INSTALLED = "INSTALLED";
    public static final String RESOLVED = "RESOLVED";
    public static final String STARTING = "STARTING";
    public static final String STOPPING = "STOPPING";
    public static final String UNINSTALLED = "UNINSTALLED";

    private BundleStates() {
    }

    public static String from(int state) {
        switch (state) {
            case 32: {
                return ACTIVE;
            }
            case 2: {
                return INSTALLED;
            }
            case 4: {
                return RESOLVED;
            }
            case 8: {
                return STARTING;
            }
            case 16: {
                return STOPPING;
            }
            case 1: {
                return UNINSTALLED;
            }
        }
        return "UNKNOWN (" + Integer.toString(state) + ")";
    }

    public static String from(Bundle bundle) {
        return BundleStates.from(bundle.getState());
    }

    public static int from(String state) {
        switch (state.toUpperCase()) {
            case "ACTIVE": {
                return 32;
            }
            case "INSTALLED": {
                return 2;
            }
            case "RESOLVED": {
                return 4;
            }
            case "STARTING": {
                return 8;
            }
            case "STOPPING": {
                return 16;
            }
            case "UNINSTALLED": {
                return 1;
            }
        }
        return -1;
    }
}

