/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.terminal;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.wisdom.api.http.websockets.Publisher;
import org.wisdom.monitor.extensions.terminal.CommandResult;
import org.wisdom.monitor.extensions.terminal.OutputType;

public class WisitOutputStream
extends OutputStream {
    private final Publisher publisher;
    private final String topic;
    private final OutputType myType;
    private final Object lock = new Object();
    private static final String UTF8 = "UTF-8";

    public WisitOutputStream(Publisher publisher, String topic) {
        this(publisher, topic, OutputType.RESULT);
    }

    public WisitOutputStream(Publisher publisher, String topic, OutputType outputType) {
        if (publisher == null || topic == null || outputType == null) {
            throw new IllegalArgumentException("publisher, topic and outputType cannot be null");
        }
        this.publisher = publisher;
        this.topic = topic;
        this.myType = outputType;
    }

    @Override
    public void write(int i) throws IOException {
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.publish(new String(b, UTF8));
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        if (len == 1 && buf[off] == 10) {
            return;
        }
        this.publish(new String(buf, off, len, Charset.forName(UTF8)));
    }

    public OutputType getType() {
        return this.myType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish(String buffer) {
        CommandResult out = new CommandResult(this.myType);
        out.setContent(buffer);
        Object object = this.lock;
        synchronized (object) {
            this.publisher.publish(this.topic, out.toString());
        }
    }
}

