/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.monitor.extensions.wisdom;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.architecture.InstanceDescription;
import org.apache.felix.ipojo.handlers.dependency.DependencyHandlerDescription;
import org.wisdom.api.Controller;
import org.wisdom.api.content.Json;
import org.wisdom.api.model.Crud;
import org.wisdom.api.router.Route;
import org.wisdom.api.router.Router;
import org.wisdom.api.templates.Template;
import org.wisdom.monitor.extensions.wisdom.RouteModel;

public class ControllerModel {
    public static final Pattern TEMPLATE_FILTER_PATTERN = Pattern.compile("\\(name=(.*)\\)");
    public static final Pattern MODEL_FILTER_PATTERN = Pattern.compile("\\(entity\\.classname=(.*)\\)");

    public static JsonNode from(InstanceDescription description, Json json) {
        ObjectNode node = json.newObject();
        node.put("classname", description.getComponentDescription().getName()).put("invalid", description.getState() == 1).put("reason", ControllerModel.extractInvalidityReason(description));
        return node;
    }

    public static JsonNode from(Controller controller, Router router, Json json) {
        ObjectNode node = json.newObject();
        node.put("classname", controller.getClass().getName()).put("invalid", false).put("routes", (JsonNode)ControllerModel.getRoutes(controller, router, json));
        return node;
    }

    private static ArrayNode getRoutes(Controller controller, Router router, Json json) {
        ArrayNode array = json.newArray();
        for (Route route : router.getRoutes()) {
            if (!route.getControllerClass().equals(controller.getClass())) continue;
            array.add((JsonNode)RouteModel.from(route, json));
        }
        return array;
    }

    private static String extractInvalidityReason(InstanceDescription description) {
        DependencyHandlerDescription deps = (DependencyHandlerDescription)description.getHandlerDescription("org.apache.felix.ipojo:requires");
        if (deps != null && !deps.isValid()) {
            for (HandlerDescription handlerDescription : deps.getDependencies()) {
                if (handlerDescription.getState() != 0) continue;
                if (handlerDescription.getSpecification().equals(Template.class.getName())) {
                    return "Missing template : " + ControllerModel.extractTemplateName(handlerDescription.getFilter());
                }
                if (handlerDescription.getSpecification().equals(Crud.class.getName())) {
                    return "Missing model : " + ControllerModel.extractModelName(handlerDescription.getFilter());
                }
                return "Missing service : " + handlerDescription.getSpecification();
            }
        }
        for (HandlerDescription handlerDescription : description.getHandlers()) {
            if (handlerDescription.isValid()) continue;
            return "Invalid handler " + handlerDescription.getHandlerName();
        }
        return "";
    }

    private static String extractTemplateName(String filter) {
        Matcher matcher = TEMPLATE_FILTER_PATTERN.matcher(filter);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "Unknown template";
    }

    private static String extractModelName(String filter) {
        Matcher matcher = MODEL_FILTER_PATTERN.matcher(filter);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "Unknown model";
    }
}

