/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.bodies;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.MimeTypes;
import org.wisdom.api.http.Renderable;
import org.wisdom.api.http.RenderableException;
import org.wisdom.api.http.Result;

public class RenderableFile
implements Renderable<File> {
    private final File file;
    private boolean mustBeChunked;

    public RenderableFile(File file) {
        this(file, true);
    }

    public RenderableFile(File file, boolean chunk) {
        this.file = file;
        this.mustBeChunked = chunk;
    }

    @Override
    public InputStream render(Context context, Result result) throws RenderableException {
        try {
            return FileUtils.openInputStream((File)this.file);
        }
        catch (IOException e) {
            throw new RenderableException("Cannot read file " + this.file.getAbsolutePath(), e);
        }
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public String mimetype() {
        return MimeTypes.getMimeTypeForFile(this.file);
    }

    @Override
    public File content() {
        return this.file;
    }

    @Override
    public boolean requireSerializer() {
        return false;
    }

    @Override
    public void setSerializedForm(String serialized) {
    }

    @Override
    public boolean mustBeChunked() {
        return this.mustBeChunked;
    }
}

