/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.bodies;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.slf4j.LoggerFactory;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.Renderable;
import org.wisdom.api.http.RenderableException;
import org.wisdom.api.http.Result;

public class RenderableJson
implements Renderable<JsonNode> {
    private static ObjectWriter OBJECT_WRITER = new ObjectMapper().writer().withDefaultPrettyPrinter();
    private final JsonNode node;
    private byte[] rendered;

    public RenderableJson(JsonNode node) {
        this.node = node;
    }

    @Override
    public InputStream render(Context context, Result result) throws RenderableException {
        if (this.rendered == null) {
            this.render();
        }
        return new ByteArrayInputStream(this.rendered);
    }

    private void render() throws RenderableException {
        try {
            this.rendered = OBJECT_WRITER.writeValueAsBytes((Object)this.node);
        }
        catch (JsonProcessingException e) {
            throw new RenderableException("cannot write the JSON form of " + this.node, (Exception)((Object)e));
        }
    }

    @Override
    public long length() {
        if (this.rendered == null) {
            try {
                this.render();
            }
            catch (RenderableException e) {
                LoggerFactory.getLogger(RenderableJson.class).warn("Cannot render JSON object {}", (Object)this.node, (Object)e);
                return -1L;
            }
        }
        return this.rendered.length;
    }

    @Override
    public String mimetype() {
        return "application/json";
    }

    @Override
    public JsonNode content() {
        return this.node;
    }

    @Override
    public boolean requireSerializer() {
        return false;
    }

    @Override
    public void setSerializedForm(String serialized) {
    }

    @Override
    public boolean mustBeChunked() {
        return false;
    }
}

