/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.bodies;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.slf4j.LoggerFactory;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.Renderable;
import org.wisdom.api.http.RenderableException;
import org.wisdom.api.http.Result;

public class RenderableJsonP
implements Renderable<String> {
    private static final ObjectWriter OBJECT_WRITER = new ObjectMapper().writer().withDefaultPrettyPrinter();
    private final JsonNode node;
    private final String padding;
    private byte[] rendered;

    public RenderableJsonP(String padding, JsonNode node) {
        this.padding = padding;
        this.node = node;
    }

    @Override
    public InputStream render(Context context, Result result) throws RenderableException {
        if (this.rendered == null) {
            this._render();
        }
        return new ByteArrayInputStream(this.rendered);
    }

    private void _render() throws RenderableException {
        try {
            this.rendered = (this.padding + "(" + OBJECT_WRITER.writeValueAsString((Object)this.node) + ");").getBytes(Charsets.UTF_8);
        }
        catch (JsonProcessingException e) {
            throw new RenderableException("cannot write the JSON form of " + this.node, (Exception)((Object)e));
        }
    }

    @Override
    public long length() {
        if (this.rendered == null) {
            try {
                this._render();
            }
            catch (RenderableException e) {
                LoggerFactory.getLogger(RenderableJsonP.class).warn("Cannot render JSON object {}", (Object)this.node, (Object)e);
                return -1L;
            }
        }
        return this.rendered.length;
    }

    @Override
    public String mimetype() {
        return "text/javascript";
    }

    @Override
    public String content() {
        try {
            return this.padding + "(" + OBJECT_WRITER.writeValueAsString((Object)this.node) + ")";
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot render jsonp content", e);
        }
    }

    @Override
    public boolean requireSerializer() {
        return false;
    }

    @Override
    public void setSerializedForm(String serialized) {
    }

    @Override
    public boolean mustBeChunked() {
        return false;
    }
}

