/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.bodies;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.MimeTypes;
import org.wisdom.api.http.Renderable;
import org.wisdom.api.http.RenderableException;
import org.wisdom.api.http.Result;

public class RenderableURL
implements Renderable<URL> {
    private final URL url;
    private final boolean mustBeChunked;

    public RenderableURL(URL url, boolean mustBeChunked) {
        this.url = url;
        this.mustBeChunked = mustBeChunked;
    }

    public RenderableURL(URL url) {
        this(url, true);
    }

    @Override
    public InputStream render(Context context, Result result) throws RenderableException {
        try {
            return this.url.openStream();
        }
        catch (IOException e) {
            throw new RenderableException("Cannot open stream " + this.url.toExternalForm(), e);
        }
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public String mimetype() {
        return MimeTypes.getMimeTypeForFile(this.url);
    }

    @Override
    public URL content() {
        return this.url;
    }

    @Override
    public boolean requireSerializer() {
        return false;
    }

    @Override
    public void setSerializedForm(String serialized) {
    }

    @Override
    public boolean mustBeChunked() {
        return this.mustBeChunked;
    }
}

