/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.concurrent;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.wisdom.api.concurrent.ExecutionContext;

public class CompositeExecutionContext
implements ExecutionContext {
    private Collection<? extends ExecutionContext> elements = ImmutableList.of();

    private CompositeExecutionContext() {
    }

    public static CompositeExecutionContext create(ExecutionContext ... contexts) {
        return CompositeExecutionContext.create(Arrays.asList(contexts));
    }

    public static CompositeExecutionContext create(List<ExecutionContext> contexts) {
        return new CompositeExecutionContext().addAll(contexts);
    }

    private CompositeExecutionContext addAll(List<ExecutionContext> contexts) {
        this.elements = new ImmutableList.Builder().addAll(contexts).build();
        return this;
    }

    @Override
    public void apply() {
        for (ExecutionContext executionContext : this.elements) {
            executionContext.apply();
        }
    }

    @Override
    public void unapply() {
        for (ExecutionContext executionContext : this.elements) {
            executionContext.unapply();
        }
    }
}

