/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.concurrent;

import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.wisdom.api.concurrent.ManagedFutureTask;

public interface ManagedExecutorService
extends ListeningExecutorService {
    public static final String SYSTEM = "wisdom-system-executor";

    public String name();

    public Collection<ManagedFutureTask> getHungTasks();

    public <T> ManagedFutureTask<T> submit(Callable<T> var1);

    public ManagedFutureTask submit(Runnable var1) throws RejectedExecutionException;

    public <T> ManagedFutureTask<T> submit(Runnable var1, T var2);

    public int getActiveCount();

    public long getCompletedTaskCount();

    public int getCorePoolSize();

    public long getKeepAliveTime(TimeUnit var1);

    public int getLargestPoolSize();

    public int getMaximumPoolSize();

    public int getPoolSize();

    public BlockingQueue<Runnable> getQueue();

    public void purge();

    public boolean remove(Runnable var1);

    public long getTaskCount();

    public ExecutionStatistics getExecutionTimeStatistics();

    public static class ExecutionStatistics {
        private long count;
        private long sum;
        private long min = Long.MAX_VALUE;
        private long max = Long.MIN_VALUE;

        public void accept(int value) {
            this.accept((long)value);
        }

        public synchronized void accept(long value) {
            ++this.count;
            this.sum += value;
            this.min = Math.min(this.min, value);
            this.max = Math.max(this.max, value);
        }

        public synchronized void combine(ExecutionStatistics other) {
            this.count += other.getCount();
            this.sum += other.getTotalExecutionTime();
            this.min = Math.min(this.min, other.getMinimumExecutionTime());
            this.max = Math.max(this.max, other.getMaximumExecutionTime());
        }

        public synchronized ExecutionStatistics copy() {
            ExecutionStatistics statistics = new ExecutionStatistics();
            statistics.combine(this);
            return statistics;
        }

        public final synchronized long getCount() {
            return this.count;
        }

        public final synchronized long getNumberOfTasks() {
            return this.getCount();
        }

        public final synchronized long getTotalExecutionTime() {
            return this.sum;
        }

        public final synchronized long getMinimumExecutionTime() {
            return this.min;
        }

        public final synchronized long getMaximumExecutionTime() {
            return this.max;
        }

        public final synchronized double getAverageExecutionTime() {
            return this.getCount() > 0L ? (double)this.getTotalExecutionTime() / (double)this.getNumberOfTasks() : 0.0;
        }

        public synchronized String toString() {
            return String.format("%s{count=%d, sum=%d, min=%d, average=%f, max=%d}", this.getClass().getSimpleName(), this.getCount(), this.getTotalExecutionTime(), this.getMinimumExecutionTime(), this.getAverageExecutionTime(), this.getMaximumExecutionTime());
        }
    }

    public static enum ThreadType {
        POOLED,
        DAEMON;

    }
}

