/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.http;

import java.io.File;
import java.net.URL;
import org.wisdom.api.utils.KnownMimeTypes;

public final class MimeTypes {
    public static final String TEXT = "text/plain";
    public static final String HTML = "text/html";
    public static final String JSON = "application/json";
    public static final String XML = "application/xml";
    public static final String CSS = "text/css";
    public static final String JAVASCRIPT = "text/javascript";
    public static final String FORM = "application/x-www-form-urlencoded";
    public static final String EVENT_STREAM = "text/event-stream";
    public static final String BINARY = "application/octet-stream";
    public static final String MULTIPART = "multipart/form-data";

    private MimeTypes() {
    }

    public static String getMimeTypeForFile(File file) {
        if (file == null) {
            return null;
        }
        String name = file.getName();
        if (name.indexOf(46) == -1) {
            return BINARY;
        }
        String ext = name.substring(name.lastIndexOf(46) + 1);
        String mime = KnownMimeTypes.getMimeTypeByExtension(ext);
        if (mime == null) {
            return BINARY;
        }
        return mime;
    }

    public static String getMimeTypeForFile(URL url) {
        if (url == null) {
            return null;
        }
        String external = url.toExternalForm();
        if (external.indexOf(46) == -1) {
            return BINARY;
        }
        String ext = external.substring(external.lastIndexOf(46) + 1);
        String mime = KnownMimeTypes.getMimeTypeByExtension(ext);
        if (mime == null) {
            return BINARY;
        }
        return mime;
    }
}

