/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.http;

import com.google.common.net.MediaType;
import java.util.Collection;
import java.util.Map;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.Result;
import org.wisdom.api.http.Results;

public final class Negotiation {
    private Negotiation() {
    }

    public static Result accept(Map<String, ? extends Result> results) {
        Context context = Context.CONTEXT.get();
        if (context == null) {
            throw new IllegalStateException("Negotiation cannot be achieved outside of a request");
        }
        Collection<MediaType> accepted = context.request().mediaTypes();
        for (MediaType media : accepted) {
            for (Map.Entry<String, ? extends Result> entry : results.entrySet()) {
                MediaType input = MediaType.parse((String)entry.getKey());
                if (!input.is(media)) continue;
                return entry.getValue().with("Vary", "Accept");
            }
        }
        return Results.status(406);
    }
}

