/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.http;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.wisdom.api.http.RequestHeader;

public abstract class Request
extends RequestHeader {
    private String username = null;

    public String username() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public abstract String contentType();

    public String contentMimeType() {
        String ct = this.contentType();
        if (ct != null) {
            int index = ct.indexOf(";");
            if (index != -1) {
                return ct.substring(0, index);
            }
            return ct;
        }
        return null;
    }

    public Charset contentCharset() {
        String ct = this.contentType();
        if (ct != null) {
            int index = ct.indexOf("charset=");
            if (index != -1) {
                return Charset.forName(ct.substring(index + 8));
            }
            return null;
        }
        return null;
    }

    public abstract String method();

    public abstract String parameter(String var1);

    public abstract List<String> parameterMultipleValues(String var1);

    public abstract String parameter(String var1, String var2);

    public abstract Integer parameterAsInteger(String var1);

    public abstract Integer parameterAsInteger(String var1, Integer var2);

    public abstract Boolean parameterAsBoolean(String var1);

    public abstract Boolean parameterAsBoolean(String var1, boolean var2);

    public abstract Map<String, List<String>> parameters();

    public abstract Map<String, Object> data();
}

