/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.http;

import com.google.common.net.MediaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wisdom.api.cookies.Cookie;
import org.wisdom.api.cookies.Cookies;

public abstract class RequestHeader {
    private static final Pattern LANGUAGE_SEGMENT_PATTERN = Pattern.compile("([a-zA-Z]+(-[a-zA-Z]+)?(-[a-zA-Z]+)?)(;q=(.*))?");

    public abstract String uri();

    public abstract String remoteAddress();

    public abstract String host();

    public abstract String path();

    public abstract MediaType mediaType();

    public abstract Collection<MediaType> mediaTypes();

    public abstract boolean accepts(String var1);

    public abstract Cookies cookies();

    public Cookie cookie(String name) {
        return this.cookies().get(name);
    }

    public abstract Map<String, List<String>> headers();

    public String getHeader(String headerName) {
        List<String> headers = null;
        for (String h : this.headers().keySet()) {
            if (!headerName.equalsIgnoreCase(h)) continue;
            headers = this.headers().get(h);
            break;
        }
        if (headers == null || headers.isEmpty()) {
            return null;
        }
        return (String)headers.get(0);
    }

    public abstract String encoding();

    public abstract String language();

    public Locale[] languages() {
        return RequestHeader.getLocaleList(this.getHeader("Accept-Language"));
    }

    public abstract String charset();

    public static Locale[] getLocaleList(String accept) {
        String[] segments;
        if (accept == null || accept.length() == 0) {
            return new Locale[0];
        }
        TreeMap<Float, ArrayList<Locale>> locales = new TreeMap<Float, ArrayList<Locale>>(new Comparator<Float>(){

            @Override
            public int compare(Float o1, Float o2) {
                return o2.compareTo(o1);
            }
        });
        for (String segment : segments = accept.split(",")) {
            ArrayList<Locale> l;
            Matcher matcher = LANGUAGE_SEGMENT_PATTERN.matcher(segment.trim());
            if (!matcher.matches()) continue;
            float q = 1.0f;
            if (matcher.group(5) != null) {
                q = Float.valueOf(matcher.group(5)).floatValue();
            }
            if ((l = (ArrayList<Locale>)locales.get(Float.valueOf(q))) == null) {
                l = new ArrayList<Locale>();
                locales.put(Float.valueOf(q), l);
            }
            l.add(Locale.forLanguageTag(matcher.group(1)));
        }
        ArrayList list = new ArrayList();
        for (Map.Entry entry : locales.entrySet()) {
            list.addAll((Collection)entry.getValue());
        }
        return list.toArray(new Locale[list.size()]);
    }
}

