/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.wisdom.api.bodies.NoHttpBody;
import org.wisdom.api.bodies.RenderableJson;
import org.wisdom.api.bodies.RenderableJsonP;
import org.wisdom.api.bodies.RenderableObject;
import org.wisdom.api.bodies.RenderableString;
import org.wisdom.api.bodies.RenderableXML;
import org.wisdom.api.cookies.Cookie;
import org.wisdom.api.http.Context;
import org.wisdom.api.http.Renderable;
import org.wisdom.api.http.Status;
import org.wisdom.api.utils.DateUtil;

public class Result
implements Status {
    private int statusCode;
    private Renderable<?> content;
    private Charset charset;
    private Map<String, String> headers = Maps.newHashMap();
    private List<Cookie> cookies = Lists.newArrayList();

    public Result(int statusCode) {
        this();
        this.statusCode = statusCode;
    }

    public Result() {
    }

    public Renderable<?> getRenderable() {
        return this.content;
    }

    public Result render(Renderable<?> renderable) {
        this.content = renderable;
        return this;
    }

    public Result render(Object object) {
        this.content = object instanceof Renderable ? (Renderable)object : new RenderableObject(object);
        return this;
    }

    public Result render(JsonNode node) {
        this.content = new RenderableJson(node);
        this.json();
        return this;
    }

    public Result render(String padding, JsonNode node) {
        this.content = new RenderableJsonP(padding, node);
        this.setContentType("text/javascript");
        this.charset = Charsets.UTF_8;
        return this;
    }

    public Result render(Document document) {
        this.content = new RenderableXML(document);
        this.xml();
        return this;
    }

    public Result render(String content) {
        this.content = new RenderableString(content);
        return this;
    }

    public Result render(CharSequence content) {
        this.content = new RenderableString(content);
        return this;
    }

    public Result render(StringBuilder content) {
        this.content = new RenderableString(content);
        return this;
    }

    public Result render(StringBuffer content) {
        this.content = new RenderableString(content);
        return this;
    }

    public String getContentType() {
        return this.headers.get("Content-Type");
    }

    private void setContentType(String contentType) {
        if (contentType != null && contentType.contains("charset=")) {
            this.charset = Charset.forName(contentType.substring(contentType.indexOf("charset=") + 8).trim());
        }
        this.headers.put("Content-Type", contentType);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Result with(Charset charset) {
        this.charset = charset;
        return this;
    }

    public String getFullContentType() {
        if (this.getContentType() == null) {
            return null;
        }
        Charset localCharset = this.getCharset();
        if (localCharset == null || this.getContentType().contains("charset")) {
            return this.getContentType();
        }
        return this.getContentType() + "; charset=" + localCharset.displayName();
    }

    public Result as(String contentType) {
        this.setContentType(contentType);
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Result with(String headerName, String headerContent) {
        this.headers.put(headerName, headerContent);
        return this;
    }

    public Cookie getCookie(String cookieName) {
        for (Cookie cookie : this.getCookies()) {
            if (!cookie.name().equals(cookieName)) continue;
            return cookie;
        }
        return null;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public Result with(Cookie cookie) {
        this.cookies.add(cookie);
        return this;
    }

    public Result without(String name) {
        String v = this.headers.remove(name);
        if (v == null) {
            Context context = this.current(false);
            if (context != null) {
                if (context.session().remove(name) == null) {
                    if (context.flash().remove(name)) {
                        return this;
                    }
                } else {
                    return this;
                }
            }
            this.discard(name);
        }
        return this;
    }

    public Result withoutCompression() {
        this.headers.put("X-Wisdom-Disabled-Encoding", "true");
        return this;
    }

    public Result discard(String name) {
        Cookie cookie = this.getCookie(name);
        if (cookie != null) {
            this.cookies.remove(cookie);
            this.cookies.add(Cookie.builder(cookie).setMaxAge(0L).build());
        } else {
            this.cookies.add(Cookie.builder(name, "").setMaxAge(0L).build());
        }
        return this;
    }

    public Result discard(String ... names) {
        for (String n : names) {
            this.discard(n);
        }
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Result status(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public Result redirect(String url) {
        this.status(303);
        this.with("Location", url);
        return this;
    }

    public Result redirectTemporary(String url) {
        this.status(307);
        this.with("Location", url);
        return this;
    }

    public Result html() {
        this.setContentType("text/html");
        this.charset = Charsets.UTF_8;
        return this;
    }

    public Result json() {
        this.setContentType("application/json");
        this.charset = Charsets.UTF_8;
        if (this.getRenderable() instanceof RenderableString) {
            ((RenderableString)this.getRenderable()).setType("application/json");
        }
        return this;
    }

    public Result xml() {
        this.setContentType("application/xml");
        this.charset = Charsets.UTF_8;
        if (this.getRenderable() instanceof RenderableString) {
            ((RenderableString)this.getRenderable()).setType("application/xml");
        }
        return this;
    }

    public Result noCache() {
        this.with("Cache-Control", "no-cache");
        this.with("Date", DateUtil.formatForHttpHeader(System.currentTimeMillis()));
        this.with("Expires", DateUtil.formatForHttpHeader(0L));
        return this;
    }

    public Result noContentIfNone() {
        if (this.content == null) {
            this.content = NoHttpBody.INSTANCE;
        }
        return this;
    }

    private Context current(boolean fail) {
        Context context = Context.CONTEXT.get();
        if (context == null && fail) {
            throw new IllegalStateException("No context");
        }
        return context;
    }

    public Result addToSession(String key, String value) {
        this.current(true).session().put(key, value);
        return this;
    }

    public Result addToFlash(String key, String value) {
        this.current(true).flash().put(key, value);
        return this;
    }
}

