/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.model;

import java.util.concurrent.Callable;
import org.wisdom.api.model.CommittedHandler;
import org.wisdom.api.model.InitTransactionException;
import org.wisdom.api.model.RollBackHasCauseAnException;
import org.wisdom.api.model.RolledBackHandler;
import org.wisdom.api.model.TransactionManager;

public final class FluentTransaction<R> {
    private Callable<R> txContent;
    private RolledBackHandler txOnRolledBack;
    private CommittedHandler<R> txOnCommitted = null;
    private final TransactionManager txManager;

    private FluentTransaction(TransactionManager txManager) {
        this.txManager = txManager;
    }

    public static FluentTransaction transaction(TransactionManager txManager) {
        return new FluentTransaction(txManager);
    }

    public TransactionManager getTransactionManager() {
        return this.txManager;
    }

    public Intermediate with(Callable<R> content) {
        this.txContent = content;
        return new Intermediate();
    }

    public class Ready {
        private Ready() {
        }

        public void execute() throws InitTransactionException, RollBackHasCauseAnException {
            FluentTransaction.this.txManager.begin();
            try {
                Object result = FluentTransaction.this.txContent.call();
                FluentTransaction.this.txManager.commit();
                if (FluentTransaction.this.txOnCommitted != null) {
                    FluentTransaction.this.txOnCommitted.committed(result);
                }
            }
            catch (Exception cause) {
                FluentTransaction.this.txManager.rollback();
                FluentTransaction.this.txOnRolledBack.rolledBack(cause);
            }
            finally {
                FluentTransaction.this.txManager.close();
            }
        }
    }

    public final class OptionalIntermediate
    extends Ready {
        private OptionalIntermediate() {
        }

        public Ready onCommitted(CommittedHandler<R> onCommitted) {
            FluentTransaction.this.txOnCommitted = onCommitted;
            return new Ready();
        }
    }

    public final class Intermediate {
        private Intermediate() {
        }

        public OptionalIntermediate onRolledBack(RolledBackHandler rollcall) {
            FluentTransaction.this.txOnRolledBack = rollcall;
            return new OptionalIntermediate();
        }
    }
}

