/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.router;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.net.MediaType;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wisdom.api.Controller;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Request;
import org.wisdom.api.http.Result;
import org.wisdom.api.router.RouteUtils;
import org.wisdom.api.router.RoutingException;
import org.wisdom.api.router.parameters.ActionParameter;

public class Route {
    protected final HttpMethod httpMethod;
    protected final String uri;
    protected final Controller controller;
    protected final Method controllerMethod;
    protected final List<String> parameterNames;
    protected final Pattern regex;
    protected Set<MediaType> acceptedMediaTypes = Collections.emptySet();
    protected Set<MediaType> producedMediaTypes = Collections.emptySet();
    protected final List<ActionParameter> arguments;
    protected int unboundStatus;

    protected Route() {
        this.httpMethod = null;
        this.uri = null;
        this.controller = null;
        this.controllerMethod = null;
        this.parameterNames = null;
        this.regex = null;
        this.arguments = null;
    }

    public Route(HttpMethod httpMethod, String uri, Controller controller, Method controllerMethod) {
        this.httpMethod = httpMethod;
        this.uri = uri;
        this.controller = controller;
        this.controllerMethod = controllerMethod;
        if (controllerMethod != null) {
            if (!controllerMethod.isAccessible()) {
                controllerMethod.setAccessible(true);
            }
            this.arguments = RouteUtils.buildActionParameterList(this.controllerMethod);
            this.parameterNames = ImmutableList.copyOf(RouteUtils.extractParameters(uri));
            this.regex = Pattern.compile(RouteUtils.convertRawUriToRegex(uri));
        } else {
            this.parameterNames = Collections.emptyList();
            this.regex = null;
            this.arguments = Collections.emptyList();
        }
        if (controller == null) {
            this.unboundStatus = 404;
        }
    }

    public Route(HttpMethod httpMethod, String uri, int unboundStatus) {
        this(httpMethod, uri, null, null);
        this.unboundStatus = unboundStatus;
    }

    public Route accepts(String ... types) {
        Preconditions.checkNotNull((Object)types);
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        builder.addAll(this.acceptedMediaTypes);
        for (String s : types) {
            builder.add((Object)MediaType.parse((String)s));
        }
        this.acceptedMediaTypes = builder.build();
        return this;
    }

    public Route accepting(String ... types) {
        this.accepts(types);
        return this;
    }

    public Route produces(String ... types) {
        Preconditions.checkNotNull((Object)types);
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        builder.addAll(this.producedMediaTypes);
        for (String s : types) {
            MediaType mt = MediaType.parse((String)s);
            if (mt.hasWildcard()) {
                throw new RoutingException("A route cannot `produce` a mime type with a wildcard: " + mt);
            }
            builder.add((Object)mt);
        }
        this.producedMediaTypes = builder.build();
        return this;
    }

    public Route producing(String ... types) {
        this.produces(types);
        return this;
    }

    public String getUrl() {
        return this.uri;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public Class<? extends Controller> getControllerClass() {
        return this.controller.getClass();
    }

    public Method getControllerMethod() {
        return this.controllerMethod;
    }

    public boolean matches(HttpMethod method, String uri) {
        if (this.httpMethod == method) {
            Matcher matcher = this.regex.matcher(uri);
            return matcher.matches();
        }
        return false;
    }

    public boolean matches(String method, String uri) {
        return this.matches(HttpMethod.from(method), uri);
    }

    public Map<String, String> getPathParametersEncoded(String uri) {
        HashMap map = Maps.newHashMap();
        if (this.regex == null) {
            return map;
        }
        Matcher m = this.regex.matcher(uri);
        if (m.matches()) {
            for (int i = 1; i < m.groupCount() + 1; ++i) {
                map.put(this.parameterNames.get(i - 1), m.group(i));
            }
        }
        return map;
    }

    public Controller getControllerObject() {
        return this.controller;
    }

    public Result invoke() throws Exception {
        if (this.isUnbound()) {
            return new Result().status(this.unboundStatus).noContentIfNone();
        }
        return (Result)this.controllerMethod.invoke((Object)this.controller, new Object[0]);
    }

    public List<ActionParameter> getArguments() {
        return this.arguments;
    }

    public String toString() {
        if (this.isUnbound()) {
            return "{" + (Object)((Object)this.getHttpMethod()) + " " + this.getUrl() + " => " + "UNBOUND (" + this.unboundStatus + ")" + "}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append((Object)this.getHttpMethod()).append(" ").append(this.uri).append(" => ").append(this.controller.getClass().toString()).append("#").append(this.controllerMethod.getName());
        if (!this.acceptedMediaTypes.isEmpty()) {
            builder.append(" - accepting: ").append(this.acceptedMediaTypes);
        }
        if (!this.producedMediaTypes.isEmpty()) {
            builder.append(" - producing: ").append(this.producedMediaTypes);
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Route)) {
            return false;
        }
        Route route = (Route)o;
        if (this.isUnbound()) {
            return route.isUnbound() && this.httpMethod == route.httpMethod && this.uri.equals(route.uri);
        }
        return this.controller.equals(route.controller) && this.controllerMethod.equals(route.controllerMethod) && this.httpMethod == route.httpMethod && this.uri.equals(route.uri);
    }

    public int hashCode() {
        int result;
        if (this.isUnbound()) {
            result = this.httpMethod.hashCode();
            result = 31 * result + this.uri.hashCode();
            result = 31 * result + this.unboundStatus;
        } else {
            result = this.httpMethod.hashCode();
            result = 31 * result + this.uri.hashCode();
            result = 31 * result + this.controller.hashCode();
            result = 31 * result + this.controllerMethod.hashCode();
        }
        return result;
    }

    public boolean isUnbound() {
        return this.controllerMethod == null;
    }

    public int getUnboundStatus() {
        return this.unboundStatus;
    }

    public int isCompliantWithRequestContentType(Request request) {
        if (this.acceptedMediaTypes == null || this.acceptedMediaTypes.isEmpty() || request == null) {
            return 2;
        }
        String content = request.contentMimeType();
        if (content == null) {
            return 2;
        }
        MediaType contentMimeType = MediaType.parse((String)request.contentMimeType());
        for (MediaType type : this.acceptedMediaTypes) {
            if (!contentMimeType.is(type)) continue;
            if (type.hasWildcard()) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public boolean isCompliantWithRequestAccept(Request request) {
        if (this.producedMediaTypes == null || this.producedMediaTypes.isEmpty() || request == null || request.getHeader("Accept") == null) {
            return true;
        }
        for (MediaType mt : this.producedMediaTypes) {
            if (!request.accepts(mt.toString())) continue;
            return true;
        }
        return false;
    }

    public Set<MediaType> getProducedMediaTypes() {
        return this.producedMediaTypes;
    }

    public Set<MediaType> getAcceptedMediaTypes() {
        return this.acceptedMediaTypes;
    }
}

