/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.router;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import org.wisdom.api.Controller;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Result;
import org.wisdom.api.router.Route;

public class RouteBuilder {
    private static final String ERROR_CTRL = "Cannot find the controller method `";
    private static final String ERROR_IN = "` in `";
    private Controller controller;
    private Method controllerMethod;
    private HttpMethod httpMethod;
    private String uri;

    public RouteBuilder route(HttpMethod method) {
        this.httpMethod = method;
        return this;
    }

    public RouteBuilder on(String uri) {
        this.uri = !uri.startsWith("/") ? "/" + uri : uri;
        return this;
    }

    public Route to(Controller controller, String method) {
        Preconditions.checkNotNull((Object)controller);
        Preconditions.checkNotNull((Object)method);
        this.controller = controller;
        try {
            this.controllerMethod = this.verifyThatControllerAndMethodExists(controller.getClass(), method);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ERROR_CTRL + method + ERROR_IN + controller.getClass() + "`, or the method is invalid", e);
        }
        return this._build();
    }

    public Route to(Controller controller, Method method) {
        Preconditions.checkNotNull((Object)controller);
        Preconditions.checkNotNull((Object)method);
        this.controller = controller;
        this.controllerMethod = method;
        if (!method.getReturnType().isAssignableFrom(Result.class)) {
            throw new IllegalArgumentException(ERROR_CTRL + method + ERROR_IN + controller.getClass() + "`, or the method does not return a " + Result.class.getName() + " object");
        }
        return this._build();
    }

    private Route _build() {
        Preconditions.checkNotNull((Object)this.controller);
        Preconditions.checkNotNull((Object)((Object)this.httpMethod));
        Preconditions.checkNotNull((Object)this.uri);
        Preconditions.checkNotNull((Object)((Object)this.httpMethod));
        return new Route(this.httpMethod, this.uri, this.controller, this.controllerMethod);
    }

    private Method verifyThatControllerAndMethodExists(Class<?> controller, String controllerMethod) throws NoSuchMethodException {
        Method methodFromQueryingClass = null;
        for (Method method : controller.getMethods()) {
            if (!method.getName().equals(controllerMethod)) continue;
            if (methodFromQueryingClass == null) {
                methodFromQueryingClass = method;
                continue;
            }
            throw new NoSuchMethodException();
        }
        if (methodFromQueryingClass == null) {
            throw new NoSuchMethodException("The method " + controllerMethod + " does not exist in " + controller.getName());
        }
        if (methodFromQueryingClass.getReturnType().isAssignableFrom(Result.class)) {
            return methodFromQueryingClass;
        }
        throw new NoSuchMethodException("The method " + controllerMethod + " is declared in " + controller.getName() + " but does not return a " + Result.class.getName() + " object.");
    }
}

