/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.api.router;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wisdom.api.Controller;
import org.wisdom.api.annotations.Path;
import org.wisdom.api.router.Route;
import org.wisdom.api.router.RouteBuilder;
import org.wisdom.api.router.parameters.ActionParameter;

public class RouteUtils {
    private static final Pattern PATH_PARAMETER_REGEX = Pattern.compile("\\{(.*?)\\}");
    private static final String ANY_CHARS = "(.*?)";
    public static final String EMPTY_PREFIX = "";

    private RouteUtils() {
    }

    public static List<String> extractParameters(String rawRoute) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = PATH_PARAMETER_REGEX.matcher(rawRoute);
        while (m.find()) {
            if (m.group(1).indexOf(60) != -1) {
                list.add(m.group(1).substring(0, m.group(1).indexOf(60)));
                continue;
            }
            if (m.group(1).indexOf(42) != -1) {
                list.add(m.group(1).substring(0, m.group(1).indexOf(42)));
                continue;
            }
            if (m.group(1).indexOf(43) != -1) {
                list.add(m.group(1).substring(0, m.group(1).indexOf(43)));
                continue;
            }
            list.add(m.group(1));
        }
        return list;
    }

    public static String convertRawUriToRegex(String rawUri) {
        String s = rawUri.replaceAll("\\{.*?<", "(").replaceAll(">\\}", ")").replaceAll("\\{.*?\\*\\}", ANY_CHARS).replaceAll("\\{.*?\\+\\}", "(.+?)").replaceAll("\\{.*?\\}", "([^/]+?)");
        if (s.endsWith("*")) {
            s = s.substring(0, s.length() - 1) + ANY_CHARS;
        }
        return s;
    }

    public static List<Route> collectRouteFromControllerAnnotations(Controller controller) {
        Method[] methods;
        String prefix = RouteUtils.getPath(controller);
        ArrayList<Route> routes = new ArrayList<Route>();
        for (Method method : methods = controller.getClass().getMethods()) {
            org.wisdom.api.annotations.Route annotation = method.getAnnotation(org.wisdom.api.annotations.Route.class);
            if (annotation == null) continue;
            String uri = annotation.uri();
            uri = RouteUtils.getPrefixedUri(prefix, uri);
            Route route = new RouteBuilder().route(annotation.method()).on(uri).to(controller, method).accepting(annotation.accepts()).producing(annotation.produces());
            routes.add(route);
        }
        return routes;
    }

    public static String getPrefixedUri(String prefix, String uri) {
        String localURI = uri;
        if (localURI.length() > 0) {
            localURI = !localURI.startsWith("/") && !prefix.endsWith("/") && Character.isLetterOrDigit(localURI.indexOf(0)) ? prefix + "/" + localURI : prefix + localURI;
        } else {
            return prefix;
        }
        return localURI;
    }

    public static List<ActionParameter> buildActionParameterList(Method method) {
        ArrayList<ActionParameter> arguments = new ArrayList<ActionParameter>();
        Annotation[][] annotations = method.getParameterAnnotations();
        Class<?>[] typesOfParameters = method.getParameterTypes();
        Type[] genericTypeOfParameters = method.getGenericParameterTypes();
        for (int i = 0; i < annotations.length; ++i) {
            arguments.add(ActionParameter.from(method, annotations[i], typesOfParameters[i], genericTypeOfParameters[i]));
        }
        return arguments;
    }

    public static String getPath(Controller controller) {
        Path path = controller.getClass().getAnnotation(Path.class);
        if (path == null) {
            return EMPTY_PREFIX;
        }
        return path.value();
    }
}

