/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.router;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wisdom.api.Controller;
import org.wisdom.api.annotations.Parameter;
import org.wisdom.api.router.RouteUtils;
import org.wisdom.api.router.parameters.ActionParameter;
import org.wisdom.api.router.parameters.Source;
import org.wisdom.router.WebSocketRouter;

public class DefaultWebSocketCallback {
    private final Controller controller;
    private final Method method;
    private final Pattern regex;
    private final ImmutableList<String> parameterNames;
    protected final WebSocketRouter router;
    protected List<ActionParameter> arguments;

    public DefaultWebSocketCallback(Controller controller, Method method, String uri, WebSocketRouter router) {
        this.router = router;
        this.controller = controller;
        this.method = method;
        this.regex = Pattern.compile(RouteUtils.convertRawUriToRegex((String)uri));
        this.parameterNames = ImmutableList.copyOf((Collection)RouteUtils.extractParameters((String)uri));
    }

    public Controller getController() {
        return this.controller;
    }

    public Method getMethod() {
        return this.method;
    }

    public Pattern getRegex() {
        return this.regex;
    }

    public List<ActionParameter> buildArguments(Method method) {
        ArrayList<ActionParameter> args = new ArrayList<ActionParameter>();
        Annotation[][] annotations = method.getParameterAnnotations();
        Class<?>[] typesOfParameters = method.getParameterTypes();
        Type[] genericTypeOfParameters = method.getGenericParameterTypes();
        for (int i = 0; i < annotations.length; ++i) {
            boolean sourceDetected = false;
            for (int j = 0; !sourceDetected && j < annotations[i].length; ++j) {
                Annotation annotation = annotations[i][j];
                if (!(annotation instanceof Parameter)) continue;
                Parameter parameter = (Parameter)annotation;
                args.add(new ActionParameter(parameter.value(), Source.PARAMETER, typesOfParameters[i], genericTypeOfParameters[i]));
                sourceDetected = true;
            }
            if (sourceDetected) continue;
            WebSocketRouter.getLogger().error("The method {} has a parameter without annotations indicating  the injected data. Only @Parameter annotations are supported in web sockets callbacks.", (Object)method.getName());
            return Collections.emptyList();
        }
        return args;
    }

    public boolean matches(String url) {
        return this.regex.matcher(url).matches();
    }

    public boolean check() {
        if (!this.method.getReturnType().equals(Void.TYPE)) {
            WebSocketRouter.getLogger().error("The method {} annotated with a web socket callback is not well-formed. These methods receive only parameter annotated with @Parameter and do not return anything", (Object)this.method.getName());
            return false;
        }
        List<ActionParameter> localArguments = this.buildArguments(this.method);
        if (localArguments == null) {
            return false;
        }
        this.arguments = localArguments;
        return true;
    }

    public Map<String, String> getPathParametersEncoded(String uri) {
        HashMap map = Maps.newHashMap();
        Matcher m = this.regex.matcher(uri);
        if (m.matches()) {
            for (int i = 1; i < m.groupCount() + 1; ++i) {
                map.put(this.parameterNames.get(i - 1), m.group(i));
            }
        }
        return map;
    }

    public void invoke(String uri, String client, byte[] content) throws InvocationTargetException, IllegalAccessException {
        Map<String, String> values = this.getPathParametersEncoded(uri);
        Object[] parameters = new Object[this.arguments.size()];
        for (int i = 0; i < this.arguments.size(); ++i) {
            ActionParameter argument = this.arguments.get(i);
            if (argument.getSource() == Source.PARAMETER) {
                if (argument.getName().equals("client") && argument.getRawType().equals(String.class)) {
                    parameters[i] = client;
                    continue;
                }
                parameters[i] = this.router.converter().convertValue(values.get(argument.getName()), argument.getRawType(), argument.getGenericType(), argument.getDefaultValue());
                continue;
            }
            parameters[i] = this.transform(argument, content);
        }
        this.getMethod().invoke((Object)this.getController(), parameters);
    }

    private Object transform(ActionParameter parameter, byte[] content) {
        String data = new String(content, Charset.defaultCharset());
        try {
            return this.router.converter().convertValue(data, parameter.getRawType(), parameter.getGenericType(), null);
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            return this.router.engine().getBodyParserEngineForContentType("application/json").invoke(content, parameter.getRawType());
        }
    }
}

