/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.router;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.validation.Validator;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Unbind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.Controller;
import org.wisdom.api.content.ParameterFactories;
import org.wisdom.api.http.HttpMethod;
import org.wisdom.api.http.Request;
import org.wisdom.api.interception.Filter;
import org.wisdom.api.interception.Interceptor;
import org.wisdom.api.router.AbstractRouter;
import org.wisdom.api.router.Route;
import org.wisdom.api.router.RouteUtils;
import org.wisdom.api.router.RoutingException;
import org.wisdom.router.RouteDelegate;

@Component
@Provides
@Instantiate(name="router")
public class RequestRouter
extends AbstractRouter
implements Pojo {
    InstanceManager __IM;
    boolean __MFilterSet___add$org_wisdom_api_interception_Filter;
    boolean __MFilterSet___contains$java_lang_Object;
    boolean __MFilterSet___indexOf$java_lang_Object;
    boolean __MFilterSet___remove$java_lang_Object;
    boolean __MFilterSet___add$java_lang_Object;
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestRouter.class);
    private static final Map<String, String> PERCENT_ENCODING_MAP = new TreeMap<String, String>();
    private boolean __Ffilters;
    private Set<Filter> filters;
    private boolean __Finterceptors;
    @Requires(optional=true, specification=Interceptor.class)
    private List<Interceptor<?>> interceptors;
    private boolean __Fvalidator;
    @Requires(optional=true, proxy=false)
    private Validator validator;
    private boolean __Fengine;
    @Requires(optional=true)
    private ParameterFactories engine;
    private boolean __Froutes;
    private Set<RouteDelegate> routes;
    private static final Comparator<Filter> COMPARATOR;
    boolean __MbindController$org_wisdom_api_Controller;
    boolean __MunbindController$org_wisdom_api_Controller;
    boolean __MensureNoConflicts$java_util_List;
    boolean __MisRouteConflictingWithExistingRoutes$org_wisdom_api_router_Route;
    boolean __MhasSameMethodAndUrl$org_wisdom_api_router_Route$org_wisdom_api_router_Route;
    boolean __MhasSameOrOverlappingAcceptedTypes$org_wisdom_api_router_Route$org_wisdom_api_router_Route;
    boolean __MhasSameOrOverlappingProducedTypes$org_wisdom_api_router_Route$org_wisdom_api_router_Route;
    boolean __Mstop;
    boolean __Mcopy;
    boolean __MgetRouteFor$org_wisdom_api_http_HttpMethod$java_lang_String$org_wisdom_api_http_Request;
    boolean __MgetReverseRouteFor$java_lang_String$java_lang_String$java_util_Map;
    boolean __MgetRoutes;
    boolean __McomputeUrlForRoute$org_wisdom_api_router_Route$java_util_Map;
    boolean __MpathEncode$java_lang_String$boolean;
    boolean __Mencode$java_lang_String;
    boolean __MgetValidator;
    boolean __MsetValidator$javax_validation_Validator;
    boolean __MgetFilters;
    boolean __MgetInterceptors;
    boolean __MgetParameterConverterEngine;
    boolean __MbindFilter$org_wisdom_api_interception_Filter;
    boolean __MunbindFilter$org_wisdom_api_interception_Filter;
    boolean __MsetParameterConverterEngine$org_wisdom_api_content_ParameterFactories;

    Set __getfilters() {
        if (!this.__Ffilters) {
            return this.filters;
        }
        return (Set)this.__IM.onGet((Object)this, "filters");
    }

    void __setfilters(Set set) {
        if (!this.__Ffilters) {
            this.filters = set;
            return;
        }
        this.__IM.onSet((Object)this, "filters", (Object)set);
    }

    List __getinterceptors() {
        if (!this.__Finterceptors) {
            return this.interceptors;
        }
        return (List)this.__IM.onGet((Object)this, "interceptors");
    }

    void __setinterceptors(List list) {
        if (!this.__Finterceptors) {
            this.interceptors = list;
            return;
        }
        this.__IM.onSet((Object)this, "interceptors", (Object)list);
    }

    Validator __getvalidator() {
        if (!this.__Fvalidator) {
            return this.validator;
        }
        return (Validator)this.__IM.onGet((Object)this, "validator");
    }

    void __setvalidator(Validator validator) {
        if (!this.__Fvalidator) {
            this.validator = validator;
            return;
        }
        this.__IM.onSet((Object)this, "validator", (Object)validator);
    }

    ParameterFactories __getengine() {
        if (!this.__Fengine) {
            return this.engine;
        }
        return (ParameterFactories)this.__IM.onGet((Object)this, "engine");
    }

    void __setengine(ParameterFactories parameterFactories) {
        if (!this.__Fengine) {
            this.engine = parameterFactories;
            return;
        }
        this.__IM.onSet((Object)this, "engine", (Object)parameterFactories);
    }

    Set __getroutes() {
        if (!this.__Froutes) {
            return this.routes;
        }
        return (Set)this.__IM.onGet((Object)this, "routes");
    }

    void __setroutes(Set set) {
        if (!this.__Froutes) {
            this.routes = set;
            return;
        }
        this.__IM.onSet((Object)this, "routes", (Object)set);
    }

    public RequestRouter() {
        this(null);
    }

    private RequestRouter(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setfilters(new FilterSet());
        this.__setroutes(new LinkedHashSet());
    }

    public synchronized void bindController(Controller controller) {
        if (!this.__MbindController$org_wisdom_api_Controller) {
            this.__M_bindController(controller);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindController$org_wisdom_api_Controller", new Object[]{controller});
            this.__M_bindController(controller);
            this.__IM.onExit((Object)this, "bindController$org_wisdom_api_Controller", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindController$org_wisdom_api_Controller", throwable);
            throw throwable;
        }
    }

    @Bind(aggregate=true)
    private void __M_bindController(Controller controller) {
        LOGGER.info("Adding routes from " + controller);
        ArrayList<Route> newRoutes = new ArrayList<Route>();
        try {
            List annotatedNewRoutes = RouteUtils.collectRouteFromControllerAnnotations((Controller)controller);
            newRoutes.addAll(annotatedNewRoutes);
            newRoutes.addAll(controller.routes());
            this.ensureNoConflicts(newRoutes);
        }
        catch (RoutingException e) {
            LOGGER.error("The controller {} declares routes conflicting with existing routes, the controller is ignored, reason: {}", new Object[]{controller, e.getMessage(), e});
            this.__getroutes().removeAll(newRoutes);
        }
        catch (Exception e) {
            LOGGER.error("The controller {} declares invalid routes, the controller is ignored, reason: {}", new Object[]{controller, e.getMessage(), e});
            this.__getroutes().removeAll(newRoutes);
        }
    }

    public synchronized void unbindController(Controller controller) {
        if (!this.__MunbindController$org_wisdom_api_Controller) {
            this.__M_unbindController(controller);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindController$org_wisdom_api_Controller", new Object[]{controller});
            this.__M_unbindController(controller);
            this.__IM.onExit((Object)this, "unbindController$org_wisdom_api_Controller", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindController$org_wisdom_api_Controller", throwable);
            throw throwable;
        }
    }

    @Unbind(aggregate=true)
    private void __M_unbindController(Controller controller) {
        LOGGER.info("Removing routes from " + controller);
        LinkedHashSet copy = new LinkedHashSet(this.__getroutes());
        for (RouteDelegate r : copy) {
            if (!r.getControllerObject().equals(controller)) continue;
            this.__getroutes().remove((Object)r);
        }
    }

    private void ensureNoConflicts(List<Route> newRoutes) {
        if (!this.__MensureNoConflicts$java_util_List) {
            this.__M_ensureNoConflicts(newRoutes);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "ensureNoConflicts$java_util_List", new Object[]{newRoutes});
            this.__M_ensureNoConflicts(newRoutes);
            this.__IM.onExit((Object)this, "ensureNoConflicts$java_util_List", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "ensureNoConflicts$java_util_List", throwable);
            throw throwable;
        }
    }

    private void __M_ensureNoConflicts(List<Route> newRoutes) {
        for (Route newRoute : newRoutes) {
            if (this.isRouteConflictingWithExistingRoutes(newRoute)) continue;
            RouteDelegate delegate = new RouteDelegate(this, newRoute);
            this.__getroutes().add(delegate);
        }
    }

    private boolean isRouteConflictingWithExistingRoutes(Route route) {
        boolean bl;
        if (!this.__MisRouteConflictingWithExistingRoutes$org_wisdom_api_router_Route) {
            return this.__M_isRouteConflictingWithExistingRoutes(route);
        }
        try {
            this.__IM.onEntry((Object)this, "isRouteConflictingWithExistingRoutes$org_wisdom_api_router_Route", new Object[]{route});
            bl = this.__M_isRouteConflictingWithExistingRoutes(route);
            this.__IM.onExit((Object)this, "isRouteConflictingWithExistingRoutes$org_wisdom_api_router_Route", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isRouteConflictingWithExistingRoutes$org_wisdom_api_router_Route", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isRouteConflictingWithExistingRoutes(Route route) {
        for (Route existing : this.__getroutes()) {
            if (!this.hasSameMethodAndUrl(existing, route) || !this.hasSameOrOverlappingAcceptedTypes(existing, route) || !this.hasSameOrOverlappingProducedTypes(existing, route)) continue;
            throw new RoutingException(existing.getHttpMethod() + " " + existing.getUrl() + " is already registered by controller " + existing.getControllerClass() + " - " + existing.toString() + " conflicts with " + route.toString());
        }
        return false;
    }

    private boolean hasSameMethodAndUrl(Route actual, Route other) {
        boolean bl;
        if (!this.__MhasSameMethodAndUrl$org_wisdom_api_router_Route$org_wisdom_api_router_Route) {
            return this.__M_hasSameMethodAndUrl(actual, other);
        }
        try {
            this.__IM.onEntry((Object)this, "hasSameMethodAndUrl$org_wisdom_api_router_Route$org_wisdom_api_router_Route", new Object[]{actual, other});
            bl = this.__M_hasSameMethodAndUrl(actual, other);
            this.__IM.onExit((Object)this, "hasSameMethodAndUrl$org_wisdom_api_router_Route$org_wisdom_api_router_Route", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "hasSameMethodAndUrl$org_wisdom_api_router_Route$org_wisdom_api_router_Route", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_hasSameMethodAndUrl(Route actual, Route other) {
        return other.getUrl().equals(actual.getUrl()) && other.getHttpMethod() == actual.getHttpMethod();
    }

    private boolean hasSameOrOverlappingAcceptedTypes(Route actual, Route other) {
        boolean bl;
        if (!this.__MhasSameOrOverlappingAcceptedTypes$org_wisdom_api_router_Route$org_wisdom_api_router_Route) {
            return this.__M_hasSameOrOverlappingAcceptedTypes(actual, other);
        }
        try {
            this.__IM.onEntry((Object)this, "hasSameOrOverlappingAcceptedTypes$org_wisdom_api_router_Route$org_wisdom_api_router_Route", new Object[]{actual, other});
            bl = this.__M_hasSameOrOverlappingAcceptedTypes(actual, other);
            this.__IM.onExit((Object)this, "hasSameOrOverlappingAcceptedTypes$org_wisdom_api_router_Route$org_wisdom_api_router_Route", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "hasSameOrOverlappingAcceptedTypes$org_wisdom_api_router_Route$org_wisdom_api_router_Route", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_hasSameOrOverlappingAcceptedTypes(Route actual, Route other) {
        Set actualAcceptedMediaTypes = actual.getAcceptedMediaTypes();
        Set otherAcceptedMediaTypes = other.getAcceptedMediaTypes();
        if (actualAcceptedMediaTypes.isEmpty() && otherAcceptedMediaTypes.isEmpty()) {
            return true;
        }
        if (actualAcceptedMediaTypes.isEmpty() || otherAcceptedMediaTypes.isEmpty()) {
            return true;
        }
        Sets.SetView intersection = Sets.intersection((Set)actualAcceptedMediaTypes, (Set)otherAcceptedMediaTypes);
        return !intersection.isEmpty();
    }

    private boolean hasSameOrOverlappingProducedTypes(Route actual, Route other) {
        boolean bl;
        if (!this.__MhasSameOrOverlappingProducedTypes$org_wisdom_api_router_Route$org_wisdom_api_router_Route) {
            return this.__M_hasSameOrOverlappingProducedTypes(actual, other);
        }
        try {
            this.__IM.onEntry((Object)this, "hasSameOrOverlappingProducedTypes$org_wisdom_api_router_Route$org_wisdom_api_router_Route", new Object[]{actual, other});
            bl = this.__M_hasSameOrOverlappingProducedTypes(actual, other);
            this.__IM.onExit((Object)this, "hasSameOrOverlappingProducedTypes$org_wisdom_api_router_Route$org_wisdom_api_router_Route", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "hasSameOrOverlappingProducedTypes$org_wisdom_api_router_Route$org_wisdom_api_router_Route", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_hasSameOrOverlappingProducedTypes(Route actual, Route other) {
        Set actualProducedMediaTypes = actual.getProducedMediaTypes();
        Set otherProducedMediaTypes = other.getProducedMediaTypes();
        if (actualProducedMediaTypes.isEmpty() && otherProducedMediaTypes.isEmpty()) {
            return true;
        }
        if (actualProducedMediaTypes.isEmpty() || otherProducedMediaTypes.isEmpty()) {
            return true;
        }
        Sets.SetView intersection = Sets.intersection((Set)actualProducedMediaTypes, (Set)otherProducedMediaTypes);
        return !intersection.isEmpty();
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        this.__getroutes().clear();
    }

    private synchronized Set<Route> copy() {
        Set<Route> set;
        if (!this.__Mcopy) {
            return this.__M_copy();
        }
        try {
            this.__IM.onEntry((Object)this, "copy", new Object[0]);
            set = this.__M_copy();
            this.__IM.onExit((Object)this, "copy", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "copy", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<Route> __M_copy() {
        return new LinkedHashSet<Route>(this.__getroutes());
    }

    public Route getRouteFor(HttpMethod method, String uri, Request request) {
        Route route;
        if (!this.__MgetRouteFor$org_wisdom_api_http_HttpMethod$java_lang_String$org_wisdom_api_http_Request) {
            return this.__M_getRouteFor(method, uri, request);
        }
        try {
            this.__IM.onEntry((Object)this, "getRouteFor$org_wisdom_api_http_HttpMethod$java_lang_String$org_wisdom_api_http_Request", new Object[]{method, uri, request});
            route = this.__M_getRouteFor(method, uri, request);
            this.__IM.onExit((Object)this, "getRouteFor$org_wisdom_api_http_HttpMethod$java_lang_String$org_wisdom_api_http_Request", (Object)route);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRouteFor$org_wisdom_api_http_HttpMethod$java_lang_String$org_wisdom_api_http_Request", throwable);
            throw throwable;
        }
        return route;
    }

    private Route __M_getRouteFor(HttpMethod method, String uri, Request request) {
        ArrayList<Route> list = new ArrayList<Route>(1);
        for (Route route : this.copy()) {
            if (!route.matches(method, uri)) continue;
            list.add(route);
        }
        if (list.isEmpty()) {
            return new RouteDelegate(this, new Route(method, uri, 404));
        }
        ArrayList<Object> fullMatch = new ArrayList<Object>();
        ArrayList<Route> partialMatch = new ArrayList<Route>();
        for (Route route : list) {
            int acceptation = route.isCompliantWithRequestContentType(request);
            switch (acceptation) {
                case 2: {
                    fullMatch.add(route);
                    break;
                }
                case 1: {
                    partialMatch.add(route);
                    break;
                }
            }
        }
        if (fullMatch.isEmpty() && partialMatch.isEmpty()) {
            return new RouteDelegate(this, new Route(method, uri, 415));
        }
        fullMatch.addAll(partialMatch);
        for (Route route : fullMatch) {
            if (!route.isCompliantWithRequestAccept(request)) continue;
            return route;
        }
        return new RouteDelegate(this, new Route(method, uri, 406));
    }

    public String getReverseRouteFor(String className, String method, Map<String, Object> params) {
        String string;
        if (!this.__MgetReverseRouteFor$java_lang_String$java_lang_String$java_util_Map) {
            return this.__M_getReverseRouteFor(className, method, params);
        }
        try {
            this.__IM.onEntry((Object)this, "getReverseRouteFor$java_lang_String$java_lang_String$java_util_Map", new Object[]{className, method, params});
            string = this.__M_getReverseRouteFor(className, method, params);
            this.__IM.onExit((Object)this, "getReverseRouteFor$java_lang_String$java_lang_String$java_util_Map", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getReverseRouteFor$java_lang_String$java_lang_String$java_util_Map", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getReverseRouteFor(String className, String method, Map<String, Object> params) {
        for (Route route : this.copy()) {
            if (!route.getControllerClass().getName().equals(className) || !route.getControllerMethod().getName().equals(method)) continue;
            return this.computeUrlForRoute(route, params);
        }
        return null;
    }

    public Collection<Route> getRoutes() {
        Collection<Route> collection;
        if (!this.__MgetRoutes) {
            return this.__M_getRoutes();
        }
        try {
            this.__IM.onEntry((Object)this, "getRoutes", new Object[0]);
            collection = this.__M_getRoutes();
            this.__IM.onExit((Object)this, "getRoutes", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRoutes", throwable);
            throw throwable;
        }
        return collection;
    }

    private Collection<Route> __M_getRoutes() {
        return this.copy();
    }

    private String computeUrlForRoute(Route route, Map<String, Object> params) {
        String string;
        if (!this.__McomputeUrlForRoute$org_wisdom_api_router_Route$java_util_Map) {
            return this.__M_computeUrlForRoute(route, params);
        }
        try {
            this.__IM.onEntry((Object)this, "computeUrlForRoute$org_wisdom_api_router_Route$java_util_Map", new Object[]{route, params});
            string = this.__M_computeUrlForRoute(route, params);
            this.__IM.onExit((Object)this, "computeUrlForRoute$org_wisdom_api_router_Route$java_util_Map", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "computeUrlForRoute$org_wisdom_api_router_Route$java_util_Map", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_computeUrlForRoute(Route route, Map<String, Object> params) {
        if (params == null) {
            return route.getUrl();
        }
        String urlWithReplacedPlaceholders = route.getUrl();
        HashMap queryParameterMap = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String originalRegexEscaped = String.format("\\{%s(\\+)?\\}", entry.getKey());
            boolean containVar = urlWithReplacedPlaceholders.contains("{" + entry.getKey() + "}");
            boolean containAndCanSpreadOnSeveralSegment = urlWithReplacedPlaceholders.contains("{" + entry.getKey() + "+}");
            if (containVar || containAndCanSpreadOnSeveralSegment) {
                urlWithReplacedPlaceholders = urlWithReplacedPlaceholders.replaceAll(originalRegexEscaped, this.pathEncode(entry.getValue().toString(), containAndCanSpreadOnSeveralSegment));
                continue;
            }
            queryParameterMap.put(entry.getKey(), entry.getValue());
        }
        if (!queryParameterMap.entrySet().isEmpty()) {
            StringBuilder queryParameterStringBuffer = new StringBuilder();
            Iterator iterator = queryParameterMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry queryParameterEntry = iterator.next();
                queryParameterStringBuffer.append((String)queryParameterEntry.getKey());
                queryParameterStringBuffer.append("=");
                queryParameterStringBuffer.append(this.encode(queryParameterEntry.getValue().toString()));
                if (!iterator.hasNext()) continue;
                queryParameterStringBuffer.append("&");
            }
            urlWithReplacedPlaceholders = urlWithReplacedPlaceholders + "?" + queryParameterStringBuffer.toString();
        }
        return urlWithReplacedPlaceholders;
    }

    private String pathEncode(String s, boolean canSpreadOnSeveralSegments) {
        String string;
        if (!this.__MpathEncode$java_lang_String$boolean) {
            return this.__M_pathEncode(s, canSpreadOnSeveralSegments);
        }
        try {
            this.__IM.onEntry((Object)this, "pathEncode$java_lang_String$boolean", new Object[]{s, new Boolean(canSpreadOnSeveralSegments)});
            string = this.__M_pathEncode(s, canSpreadOnSeveralSegments);
            this.__IM.onExit((Object)this, "pathEncode$java_lang_String$boolean", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "pathEncode$java_lang_String$boolean", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_pathEncode(String s, boolean canSpreadOnSeveralSegments) {
        String copy = s;
        for (Map.Entry<String, String> c : PERCENT_ENCODING_MAP.entrySet()) {
            if (!s.contains(c.getKey()) || c.getKey().endsWith("/") && canSpreadOnSeveralSegments) continue;
            copy = copy.replace(c.getKey(), c.getValue());
        }
        return copy;
    }

    private String encode(String v) {
        String string;
        if (!this.__Mencode$java_lang_String) {
            return this.__M_encode(v);
        }
        try {
            this.__IM.onEntry((Object)this, "encode$java_lang_String", new Object[]{v});
            string = this.__M_encode(v);
            this.__IM.onExit((Object)this, "encode$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "encode$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_encode(String v) {
        try {
            return URLEncoder.encode(v, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF-8 not supported", e);
        }
    }

    public Validator getValidator() {
        Validator validator;
        if (!this.__MgetValidator) {
            return this.__M_getValidator();
        }
        try {
            this.__IM.onEntry((Object)this, "getValidator", new Object[0]);
            validator = this.__M_getValidator();
            this.__IM.onExit((Object)this, "getValidator", (Object)validator);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getValidator", throwable);
            throw throwable;
        }
        return validator;
    }

    private Validator __M_getValidator() {
        return this.__getvalidator();
    }

    public void setValidator(Validator validator) {
        if (!this.__MsetValidator$javax_validation_Validator) {
            this.__M_setValidator(validator);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setValidator$javax_validation_Validator", new Object[]{validator});
            this.__M_setValidator(validator);
            this.__IM.onExit((Object)this, "setValidator$javax_validation_Validator", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setValidator$javax_validation_Validator", throwable);
            throw throwable;
        }
    }

    private void __M_setValidator(Validator validator) {
        this.__setvalidator(validator);
    }

    protected Set<Filter> getFilters() {
        Set<Filter> set;
        if (!this.__MgetFilters) {
            return this.__M_getFilters();
        }
        try {
            this.__IM.onEntry((Object)this, "getFilters", new Object[0]);
            set = this.__M_getFilters();
            this.__IM.onExit((Object)this, "getFilters", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getFilters", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<Filter> __M_getFilters() {
        return this.__getfilters();
    }

    protected List<Interceptor<?>> getInterceptors() {
        List<Interceptor<?>> list;
        if (!this.__MgetInterceptors) {
            return this.__M_getInterceptors();
        }
        try {
            this.__IM.onEntry((Object)this, "getInterceptors", new Object[0]);
            list = this.__M_getInterceptors();
            this.__IM.onExit((Object)this, "getInterceptors", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getInterceptors", throwable);
            throw throwable;
        }
        return list;
    }

    private List<Interceptor<?>> __M_getInterceptors() {
        return this.__getinterceptors();
    }

    protected ParameterFactories getParameterConverterEngine() {
        ParameterFactories parameterFactories;
        if (!this.__MgetParameterConverterEngine) {
            return this.__M_getParameterConverterEngine();
        }
        try {
            this.__IM.onEntry((Object)this, "getParameterConverterEngine", new Object[0]);
            parameterFactories = this.__M_getParameterConverterEngine();
            this.__IM.onExit((Object)this, "getParameterConverterEngine", (Object)parameterFactories);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getParameterConverterEngine", throwable);
            throw throwable;
        }
        return parameterFactories;
    }

    private ParameterFactories __M_getParameterConverterEngine() {
        return this.__getengine();
    }

    public void bindFilter(Filter filter) {
        if (!this.__MbindFilter$org_wisdom_api_interception_Filter) {
            this.__M_bindFilter(filter);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindFilter$org_wisdom_api_interception_Filter", new Object[]{filter});
            this.__M_bindFilter(filter);
            this.__IM.onExit((Object)this, "bindFilter$org_wisdom_api_interception_Filter", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindFilter$org_wisdom_api_interception_Filter", throwable);
            throw throwable;
        }
    }

    @Bind(aggregate=true, optional=true)
    private void __M_bindFilter(Filter filter) {
        this.__getfilters().add(filter);
    }

    public void unbindFilter(Filter filter) {
        if (!this.__MunbindFilter$org_wisdom_api_interception_Filter) {
            this.__M_unbindFilter(filter);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindFilter$org_wisdom_api_interception_Filter", new Object[]{filter});
            this.__M_unbindFilter(filter);
            this.__IM.onExit((Object)this, "unbindFilter$org_wisdom_api_interception_Filter", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindFilter$org_wisdom_api_interception_Filter", throwable);
            throw throwable;
        }
    }

    @Unbind
    private void __M_unbindFilter(Filter filter) {
        this.__getfilters().remove(filter);
    }

    public void setParameterConverterEngine(ParameterFactories parameterConverterEngine) {
        if (!this.__MsetParameterConverterEngine$org_wisdom_api_content_ParameterFactories) {
            this.__M_setParameterConverterEngine(parameterConverterEngine);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setParameterConverterEngine$org_wisdom_api_content_ParameterFactories", new Object[]{parameterConverterEngine});
            this.__M_setParameterConverterEngine(parameterConverterEngine);
            this.__IM.onExit((Object)this, "setParameterConverterEngine$org_wisdom_api_content_ParameterFactories", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setParameterConverterEngine$org_wisdom_api_content_ParameterFactories", throwable);
            throw throwable;
        }
    }

    private void __M_setParameterConverterEngine(ParameterFactories parameterConverterEngine) {
        this.__setengine(parameterConverterEngine);
    }

    static {
        PERCENT_ENCODING_MAP.put("/", "%2F");
        PERCENT_ENCODING_MAP.put(" ", "%20");
        PERCENT_ENCODING_MAP.put("\"", "%22");
        PERCENT_ENCODING_MAP.put("%", "%25");
        PERCENT_ENCODING_MAP.put("-", "%2D");
        PERCENT_ENCODING_MAP.put("<", "%3C");
        PERCENT_ENCODING_MAP.put(">", "%3E");
        PERCENT_ENCODING_MAP.put("\\", "%5C");
        PERCENT_ENCODING_MAP.put("\u02c6", "%5E");
        PERCENT_ENCODING_MAP.put("_", "%5F");
        PERCENT_ENCODING_MAP.put("`", "%60");
        PERCENT_ENCODING_MAP.put("{", "%7B");
        PERCENT_ENCODING_MAP.put("|", "%7C");
        PERCENT_ENCODING_MAP.put("}", "%7D");
        PERCENT_ENCODING_MAP.put("\n", "%0A");
        COMPARATOR = new Comparator<Filter>(){

            @Override
            public int compare(Filter o1, Filter o2) {
                if (o1 == o2 || o1.hashCode() == o2.hashCode()) {
                    return 0;
                }
                int compare = Integer.valueOf(o2.priority()).compareTo(o1.priority());
                if (compare == 0) {
                    return -1;
                }
                return compare;
            }
        };
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("engine")) {
                this.__Fengine = true;
            }
            if (set.contains("filters")) {
                this.__Ffilters = true;
            }
            if (set.contains("interceptors")) {
                this.__Finterceptors = true;
            }
            if (set.contains("routes")) {
                this.__Froutes = true;
            }
            if (set.contains("validator")) {
                this.__Fvalidator = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("FilterSet___add$org_wisdom_api_interception_Filter")) {
                this.__MFilterSet___add$org_wisdom_api_interception_Filter = true;
            }
            if (set.contains("FilterSet___contains$java_lang_Object")) {
                this.__MFilterSet___contains$java_lang_Object = true;
            }
            if (set.contains("FilterSet___indexOf$java_lang_Object")) {
                this.__MFilterSet___indexOf$java_lang_Object = true;
            }
            if (set.contains("FilterSet___remove$java_lang_Object")) {
                this.__MFilterSet___remove$java_lang_Object = true;
            }
            if (set.contains("FilterSet___add$java_lang_Object")) {
                this.__MFilterSet___add$java_lang_Object = true;
            }
            if (set.contains("bindController$org_wisdom_api_Controller")) {
                this.__MbindController$org_wisdom_api_Controller = true;
            }
            if (set.contains("unbindController$org_wisdom_api_Controller")) {
                this.__MunbindController$org_wisdom_api_Controller = true;
            }
            if (set.contains("ensureNoConflicts$java_util_List")) {
                this.__MensureNoConflicts$java_util_List = true;
            }
            if (set.contains("isRouteConflictingWithExistingRoutes$org_wisdom_api_router_Route")) {
                this.__MisRouteConflictingWithExistingRoutes$org_wisdom_api_router_Route = true;
            }
            if (set.contains("hasSameMethodAndUrl$org_wisdom_api_router_Route$org_wisdom_api_router_Route")) {
                this.__MhasSameMethodAndUrl$org_wisdom_api_router_Route$org_wisdom_api_router_Route = true;
            }
            if (set.contains("hasSameOrOverlappingAcceptedTypes$org_wisdom_api_router_Route$org_wisdom_api_router_Route")) {
                this.__MhasSameOrOverlappingAcceptedTypes$org_wisdom_api_router_Route$org_wisdom_api_router_Route = true;
            }
            if (set.contains("hasSameOrOverlappingProducedTypes$org_wisdom_api_router_Route$org_wisdom_api_router_Route")) {
                this.__MhasSameOrOverlappingProducedTypes$org_wisdom_api_router_Route$org_wisdom_api_router_Route = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("copy")) {
                this.__Mcopy = true;
            }
            if (set.contains("getRouteFor$org_wisdom_api_http_HttpMethod$java_lang_String$org_wisdom_api_http_Request")) {
                this.__MgetRouteFor$org_wisdom_api_http_HttpMethod$java_lang_String$org_wisdom_api_http_Request = true;
            }
            if (set.contains("getReverseRouteFor$java_lang_String$java_lang_String$java_util_Map")) {
                this.__MgetReverseRouteFor$java_lang_String$java_lang_String$java_util_Map = true;
            }
            if (set.contains("getRoutes")) {
                this.__MgetRoutes = true;
            }
            if (set.contains("computeUrlForRoute$org_wisdom_api_router_Route$java_util_Map")) {
                this.__McomputeUrlForRoute$org_wisdom_api_router_Route$java_util_Map = true;
            }
            if (set.contains("pathEncode$java_lang_String$boolean")) {
                this.__MpathEncode$java_lang_String$boolean = true;
            }
            if (set.contains("encode$java_lang_String")) {
                this.__Mencode$java_lang_String = true;
            }
            if (set.contains("getValidator")) {
                this.__MgetValidator = true;
            }
            if (set.contains("setValidator$javax_validation_Validator")) {
                this.__MsetValidator$javax_validation_Validator = true;
            }
            if (set.contains("getFilters")) {
                this.__MgetFilters = true;
            }
            if (set.contains("getInterceptors")) {
                this.__MgetInterceptors = true;
            }
            if (set.contains("getParameterConverterEngine")) {
                this.__MgetParameterConverterEngine = true;
            }
            if (set.contains("bindFilter$org_wisdom_api_interception_Filter")) {
                this.__MbindFilter$org_wisdom_api_interception_Filter = true;
            }
            if (set.contains("unbindFilter$org_wisdom_api_interception_Filter")) {
                this.__MunbindFilter$org_wisdom_api_interception_Filter = true;
            }
            if (set.contains("setParameterConverterEngine$org_wisdom_api_content_ParameterFactories")) {
                this.__MsetParameterConverterEngine$org_wisdom_api_content_ParameterFactories = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    private class FilterSet
    extends ArrayList<Filter>
    implements Set<Filter> {
        private FilterSet() {
        }

        @Override
        public boolean add(Filter filter) {
            boolean bl;
            if (!RequestRouter.this.__MFilterSet___add$org_wisdom_api_interception_Filter) {
                return this.__M_add(filter);
            }
            try {
                RequestRouter.this.__IM.onEntry((Object)this, "FilterSet___add$org_wisdom_api_interception_Filter", new Object[]{filter});
                bl = this.__M_add(filter);
                RequestRouter.this.__IM.onExit((Object)this, "FilterSet___add$org_wisdom_api_interception_Filter", (Object)new Boolean(bl));
            }
            catch (Throwable throwable) {
                RequestRouter.this.__IM.onError((Object)this, "FilterSet___add$org_wisdom_api_interception_Filter", throwable);
                throw throwable;
            }
            return bl;
        }

        private boolean __M_add(Filter filter) {
            if (!this.contains(filter)) {
                super.add(filter);
                Collections.sort(this, COMPARATOR);
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Object object) {
            boolean bl;
            if (!RequestRouter.this.__MFilterSet___contains$java_lang_Object) {
                return this.__M_contains(object);
            }
            try {
                RequestRouter.this.__IM.onEntry((Object)this, "FilterSet___contains$java_lang_Object", new Object[]{object});
                bl = this.__M_contains(object);
                RequestRouter.this.__IM.onExit((Object)this, "FilterSet___contains$java_lang_Object", (Object)new Boolean(bl));
            }
            catch (Throwable throwable) {
                RequestRouter.this.__IM.onError((Object)this, "FilterSet___contains$java_lang_Object", throwable);
                throw throwable;
            }
            return bl;
        }

        private boolean __M_contains(Object o) {
            for (Object f : this) {
                if (o != f && o.hashCode() != f.hashCode()) continue;
                return true;
            }
            return false;
        }

        @Override
        public int indexOf(Object object) {
            int n;
            if (!RequestRouter.this.__MFilterSet___indexOf$java_lang_Object) {
                return this.__M_indexOf(object);
            }
            try {
                RequestRouter.this.__IM.onEntry((Object)this, "FilterSet___indexOf$java_lang_Object", new Object[]{object});
                n = this.__M_indexOf(object);
                RequestRouter.this.__IM.onExit((Object)this, "FilterSet___indexOf$java_lang_Object", (Object)new Integer(n));
            }
            catch (Throwable throwable) {
                RequestRouter.this.__IM.onError((Object)this, "FilterSet___indexOf$java_lang_Object", throwable);
                throw throwable;
            }
            return n;
        }

        private int __M_indexOf(Object o) {
            for (int i = 0; i < this.size(); ++i) {
                Object f = this.get(i);
                if (o != f && o.hashCode() != f.hashCode()) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean remove(Object object) {
            boolean bl;
            if (!RequestRouter.this.__MFilterSet___remove$java_lang_Object) {
                return this.__M_remove(object);
            }
            try {
                RequestRouter.this.__IM.onEntry((Object)this, "FilterSet___remove$java_lang_Object", new Object[]{object});
                bl = this.__M_remove(object);
                RequestRouter.this.__IM.onExit((Object)this, "FilterSet___remove$java_lang_Object", (Object)new Boolean(bl));
            }
            catch (Throwable throwable) {
                RequestRouter.this.__IM.onError((Object)this, "FilterSet___remove$java_lang_Object", throwable);
                throw throwable;
            }
            return bl;
        }

        private boolean __M_remove(Object o) {
            int index = this.indexOf(o);
            if (index != -1) {
                this.remove(index);
                return true;
            }
            return false;
        }

        private boolean __M_add(Object object) {
            return this.add((Filter)object);
        }
    }
}

