/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.router;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Unbind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.Controller;
import org.wisdom.api.annotations.Closed;
import org.wisdom.api.annotations.OnMessage;
import org.wisdom.api.annotations.Opened;
import org.wisdom.api.concurrent.ManagedExecutorService;
import org.wisdom.api.content.ContentEngine;
import org.wisdom.api.content.ParameterFactories;
import org.wisdom.api.http.websockets.Publisher;
import org.wisdom.api.http.websockets.WebSocketDispatcher;
import org.wisdom.api.http.websockets.WebSocketListener;
import org.wisdom.api.router.RouteUtils;
import org.wisdom.router.DefaultWebSocketCallback;
import org.wisdom.router.OnMessageWebSocketCallback;

@Component(immediate=true)
@Provides(specifications={Publisher.class})
@Instantiate(name="WebSocketRouter")
public class WebSocketRouter
implements WebSocketListener,
Publisher,
Pojo {
    InstanceManager __IM;
    boolean __M1___call;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketRouter.class);
    private boolean __Fdispatchers;
    @Requires
    WebSocketDispatcher[] dispatchers;
    private boolean __Fopens;
    Set<DefaultWebSocketCallback> opens;
    private boolean __Fcloses;
    Set<DefaultWebSocketCallback> closes;
    private boolean __Flisteners;
    Set<OnMessageWebSocketCallback> listeners;
    private boolean __FcontentEngine;
    @Requires(optional=true)
    private ContentEngine contentEngine;
    private boolean __Fconverter;
    @Requires(optional=true)
    ParameterFactories converter;
    private boolean __Fexecutor;
    @Requires(filter="(name=wisdom-system-executor)")
    ManagedExecutorService executor;
    boolean __MbindDispatcher$org_wisdom_api_http_websockets_WebSocketDispatcher;
    boolean __MunbindDispatcher$org_wisdom_api_http_websockets_WebSocketDispatcher;
    boolean __Mstop;
    boolean __MbindController$org_wisdom_api_Controller;
    boolean __Mconverter;
    boolean __Mengine;
    boolean __Manalyze$org_wisdom_api_Controller;
    boolean __MunbindController$org_wisdom_api_Controller;
    boolean __Mreceived$java_lang_String$java_lang_String$byte__;
    boolean __Mopened$java_lang_String$java_lang_String;
    boolean __Mclosed$java_lang_String$java_lang_String;
    boolean __Mpublish$java_lang_String$java_lang_String;
    boolean __Mpublish$java_lang_String$byte__;
    boolean __Mpublish$java_lang_String$com_fasterxml_jackson_databind_JsonNode;
    boolean __Msend$java_lang_String$java_lang_String$java_lang_String;
    boolean __Msend$java_lang_String$java_lang_String$com_fasterxml_jackson_databind_JsonNode;
    boolean __Msend$java_lang_String$java_lang_String$byte__;

    WebSocketDispatcher[] __getdispatchers() {
        if (!this.__Fdispatchers) {
            return this.dispatchers;
        }
        return (WebSocketDispatcher[])this.__IM.onGet((Object)this, "dispatchers");
    }

    void __setdispatchers(WebSocketDispatcher[] webSocketDispatcherArray) {
        if (!this.__Fdispatchers) {
            this.dispatchers = webSocketDispatcherArray;
            return;
        }
        this.__IM.onSet((Object)this, "dispatchers", (Object)webSocketDispatcherArray);
    }

    Set __getopens() {
        if (!this.__Fopens) {
            return this.opens;
        }
        return (Set)this.__IM.onGet((Object)this, "opens");
    }

    void __setopens(Set set) {
        if (!this.__Fopens) {
            this.opens = set;
            return;
        }
        this.__IM.onSet((Object)this, "opens", (Object)set);
    }

    Set __getcloses() {
        if (!this.__Fcloses) {
            return this.closes;
        }
        return (Set)this.__IM.onGet((Object)this, "closes");
    }

    void __setcloses(Set set) {
        if (!this.__Fcloses) {
            this.closes = set;
            return;
        }
        this.__IM.onSet((Object)this, "closes", (Object)set);
    }

    Set __getlisteners() {
        if (!this.__Flisteners) {
            return this.listeners;
        }
        return (Set)this.__IM.onGet((Object)this, "listeners");
    }

    void __setlisteners(Set set) {
        if (!this.__Flisteners) {
            this.listeners = set;
            return;
        }
        this.__IM.onSet((Object)this, "listeners", (Object)set);
    }

    ContentEngine __getcontentEngine() {
        if (!this.__FcontentEngine) {
            return this.contentEngine;
        }
        return (ContentEngine)this.__IM.onGet((Object)this, "contentEngine");
    }

    void __setcontentEngine(ContentEngine contentEngine) {
        if (!this.__FcontentEngine) {
            this.contentEngine = contentEngine;
            return;
        }
        this.__IM.onSet((Object)this, "contentEngine", (Object)contentEngine);
    }

    ParameterFactories __getconverter() {
        if (!this.__Fconverter) {
            return this.converter;
        }
        return (ParameterFactories)this.__IM.onGet((Object)this, "converter");
    }

    void __setconverter(ParameterFactories parameterFactories) {
        if (!this.__Fconverter) {
            this.converter = parameterFactories;
            return;
        }
        this.__IM.onSet((Object)this, "converter", (Object)parameterFactories);
    }

    ManagedExecutorService __getexecutor() {
        if (!this.__Fexecutor) {
            return this.executor;
        }
        return (ManagedExecutorService)this.__IM.onGet((Object)this, "executor");
    }

    void __setexecutor(ManagedExecutorService managedExecutorService) {
        if (!this.__Fexecutor) {
            this.executor = managedExecutorService;
            return;
        }
        this.__IM.onSet((Object)this, "executor", (Object)managedExecutorService);
    }

    public WebSocketRouter() {
        this(null);
    }

    private WebSocketRouter(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setopens(new LinkedHashSet());
        this.__setcloses(new LinkedHashSet());
        this.__setlisteners(new LinkedHashSet());
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public void bindDispatcher(WebSocketDispatcher dispatcher) {
        if (!this.__MbindDispatcher$org_wisdom_api_http_websockets_WebSocketDispatcher) {
            this.__M_bindDispatcher(dispatcher);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindDispatcher$org_wisdom_api_http_websockets_WebSocketDispatcher", new Object[]{dispatcher});
            this.__M_bindDispatcher(dispatcher);
            this.__IM.onExit((Object)this, "bindDispatcher$org_wisdom_api_http_websockets_WebSocketDispatcher", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindDispatcher$org_wisdom_api_http_websockets_WebSocketDispatcher", throwable);
            throw throwable;
        }
    }

    @Bind(aggregate=true)
    private void __M_bindDispatcher(WebSocketDispatcher dispatcher) {
        dispatcher.register((WebSocketListener)this);
    }

    public void unbindDispatcher(WebSocketDispatcher dispatcher) {
        if (!this.__MunbindDispatcher$org_wisdom_api_http_websockets_WebSocketDispatcher) {
            this.__M_unbindDispatcher(dispatcher);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindDispatcher$org_wisdom_api_http_websockets_WebSocketDispatcher", new Object[]{dispatcher});
            this.__M_unbindDispatcher(dispatcher);
            this.__IM.onExit((Object)this, "unbindDispatcher$org_wisdom_api_http_websockets_WebSocketDispatcher", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindDispatcher$org_wisdom_api_http_websockets_WebSocketDispatcher", throwable);
            throw throwable;
        }
    }

    @Unbind
    private void __M_unbindDispatcher(WebSocketDispatcher dispatcher) {
        dispatcher.unregister((WebSocketListener)this);
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        for (WebSocketDispatcher dispatcher : this.__getdispatchers()) {
            dispatcher.unregister((WebSocketListener)this);
        }
    }

    public synchronized void bindController(Controller controller) {
        if (!this.__MbindController$org_wisdom_api_Controller) {
            this.__M_bindController(controller);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindController$org_wisdom_api_Controller", new Object[]{controller});
            this.__M_bindController(controller);
            this.__IM.onExit((Object)this, "bindController$org_wisdom_api_Controller", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindController$org_wisdom_api_Controller", throwable);
            throw throwable;
        }
    }

    @Bind(aggregate=true)
    private void __M_bindController(Controller controller) {
        this.analyze(controller);
    }

    public ParameterFactories converter() {
        ParameterFactories parameterFactories;
        if (!this.__Mconverter) {
            return this.__M_converter();
        }
        try {
            this.__IM.onEntry((Object)this, "converter", new Object[0]);
            parameterFactories = this.__M_converter();
            this.__IM.onExit((Object)this, "converter", (Object)parameterFactories);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "converter", throwable);
            throw throwable;
        }
        return parameterFactories;
    }

    private ParameterFactories __M_converter() {
        return this.__getconverter();
    }

    public ContentEngine engine() {
        ContentEngine contentEngine;
        if (!this.__Mengine) {
            return this.__M_engine();
        }
        try {
            this.__IM.onEntry((Object)this, "engine", new Object[0]);
            contentEngine = this.__M_engine();
            this.__IM.onExit((Object)this, "engine", (Object)contentEngine);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "engine", throwable);
            throw throwable;
        }
        return contentEngine;
    }

    private ContentEngine __M_engine() {
        return this.__getcontentEngine();
    }

    private void analyze(Controller controller) {
        if (!this.__Manalyze$org_wisdom_api_Controller) {
            this.__M_analyze(controller);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "analyze$org_wisdom_api_Controller", new Object[]{controller});
            this.__M_analyze(controller);
            this.__IM.onExit((Object)this, "analyze$org_wisdom_api_Controller", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "analyze$org_wisdom_api_Controller", throwable);
            throw throwable;
        }
    }

    private void __M_analyze(Controller controller) {
        Method[] methods;
        String prefix = RouteUtils.getPath((Controller)controller);
        for (Method method : methods = controller.getClass().getMethods()) {
            DefaultWebSocketCallback callback;
            Opened open = method.getAnnotation(Opened.class);
            Closed close = method.getAnnotation(Closed.class);
            OnMessage on = method.getAnnotation(OnMessage.class);
            if (open != null && (callback = new DefaultWebSocketCallback(controller, method, RouteUtils.getPrefixedUri((String)prefix, (String)open.value()), this)).check()) {
                this.__getopens().add(callback);
            }
            if (close != null && (callback = new DefaultWebSocketCallback(controller, method, RouteUtils.getPrefixedUri((String)prefix, (String)close.value()), this)).check()) {
                this.__getcloses().add(callback);
            }
            if (on == null || !(callback = new OnMessageWebSocketCallback(controller, method, RouteUtils.getPrefixedUri((String)prefix, (String)on.value()), this)).check()) continue;
            this.__getlisteners().add(callback);
        }
    }

    public synchronized void unbindController(Controller controller) {
        if (!this.__MunbindController$org_wisdom_api_Controller) {
            this.__M_unbindController(controller);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindController$org_wisdom_api_Controller", new Object[]{controller});
            this.__M_unbindController(controller);
            this.__IM.onExit((Object)this, "unbindController$org_wisdom_api_Controller", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindController$org_wisdom_api_Controller", throwable);
            throw throwable;
        }
    }

    @Unbind
    private void __M_unbindController(Controller controller) {
        ArrayList<DefaultWebSocketCallback> toRemove = new ArrayList<DefaultWebSocketCallback>();
        for (DefaultWebSocketCallback open : this.__getopens()) {
            if (open.getController() != controller) continue;
            toRemove.add(open);
        }
        this.__getopens().removeAll(toRemove);
        toRemove.clear();
        for (DefaultWebSocketCallback close : this.__getcloses()) {
            if (close.getController() != controller) continue;
            toRemove.add(close);
        }
        this.__getcloses().removeAll(toRemove);
        toRemove.clear();
        for (DefaultWebSocketCallback callback : this.__getlisteners()) {
            if (callback.getController() != controller) continue;
            toRemove.add(callback);
        }
        this.__getlisteners().removeAll(toRemove);
    }

    public void received(String uri, String from, byte[] content) {
        if (!this.__Mreceived$java_lang_String$java_lang_String$byte__) {
            this.__M_received(uri, from, content);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "received$java_lang_String$java_lang_String$byte__", new Object[]{uri, from, content});
            this.__M_received(uri, from, content);
            this.__IM.onExit((Object)this, "received$java_lang_String$java_lang_String$byte__", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "received$java_lang_String$java_lang_String$byte__", throwable);
            throw throwable;
        }
    }

    private void __M_received(final String uri, final String from, final byte[] content) {
        for (final OnMessageWebSocketCallback listener : this.__getlisteners()) {
            if (!listener.matches(uri)) continue;
            this.__getexecutor().submit((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Void void_;
                    if (!WebSocketRouter.this.__M1___call) {
                        return this.__M_call();
                    }
                    try {
                        WebSocketRouter.this.__IM.onEntry((Object)this, "1___call", new Object[0]);
                        void_ = this.__M_call();
                        WebSocketRouter.this.__IM.onExit((Object)this, "1___call", (Object)void_);
                    }
                    catch (Throwable throwable) {
                        WebSocketRouter.this.__IM.onError((Object)this, "1___call", throwable);
                        throw throwable;
                    }
                    return void_;
                }

                private Void __M_call() throws Exception {
                    try {
                        listener.invoke(uri, from, content);
                    }
                    catch (InvocationTargetException e) {
                        LOGGER.error("An error occurred in the @OnMessage callback {}#{} : {}", new Object[]{listener.getController().getClass().getName(), listener.getMethod().getName(), e.getTargetException().getMessage(), e.getTargetException()});
                    }
                    catch (Exception e) {
                        LOGGER.error("An error occurred in the @OnMessage callback {}#{} : {}", new Object[]{listener.getController().getClass().getName(), listener.getMethod().getName(), e.getMessage(), e});
                    }
                    return null;
                }

                private Object __M_call() throws Exception {
                    return this.call();
                }
            });
        }
    }

    public void opened(String uri, String client) {
        if (!this.__Mopened$java_lang_String$java_lang_String) {
            this.__M_opened(uri, client);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "opened$java_lang_String$java_lang_String", new Object[]{uri, client});
            this.__M_opened(uri, client);
            this.__IM.onExit((Object)this, "opened$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "opened$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_opened(String uri, String client) {
        for (DefaultWebSocketCallback open : this.__getopens()) {
            if (!open.matches(uri)) continue;
            try {
                open.invoke(uri, client, null);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("An error occurred in the @Open callback {}#{} : {}", new Object[]{open.getController().getClass().getName(), open.getMethod().getName(), e.getTargetException().getMessage(), e.getTargetException()});
            }
            catch (Exception e) {
                LOGGER.error("An error occurred in the @Open callback {}#{} : {}", new Object[]{open.getController().getClass().getName(), open.getMethod().getName(), e.getMessage(), e});
            }
        }
    }

    public void closed(String uri, String client) {
        if (!this.__Mclosed$java_lang_String$java_lang_String) {
            this.__M_closed(uri, client);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "closed$java_lang_String$java_lang_String", new Object[]{uri, client});
            this.__M_closed(uri, client);
            this.__IM.onExit((Object)this, "closed$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "closed$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_closed(String uri, String client) {
        for (DefaultWebSocketCallback close : this.__getcloses()) {
            if (!close.matches(uri)) continue;
            try {
                close.invoke(uri, client, null);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("An error occurred in the @Close callback {}#{} : {}", new Object[]{close.getController().getClass().getName(), close.getMethod().getName(), e.getTargetException().getMessage(), e.getTargetException()});
            }
            catch (Exception e) {
                LOGGER.error("An error occurred in the @Close callback {}#{} : {}", new Object[]{close.getController().getClass().getName(), close.getMethod().getName(), e.getMessage(), e});
            }
        }
    }

    public void publish(String uri, String message) {
        if (!this.__Mpublish$java_lang_String$java_lang_String) {
            this.__M_publish(uri, message);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "publish$java_lang_String$java_lang_String", new Object[]{uri, message});
            this.__M_publish(uri, message);
            this.__IM.onExit((Object)this, "publish$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "publish$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_publish(String uri, String message) {
        if (message == null) {
            LOGGER.warn("Cannot send websocket message on {}, the message is null", (Object)uri);
            return;
        }
        for (WebSocketDispatcher dispatcher : this.__getdispatchers()) {
            dispatcher.publish(uri, message);
        }
    }

    public void publish(String uri, byte[] message) {
        if (!this.__Mpublish$java_lang_String$byte__) {
            this.__M_publish(uri, message);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "publish$java_lang_String$byte__", new Object[]{uri, message});
            this.__M_publish(uri, message);
            this.__IM.onExit((Object)this, "publish$java_lang_String$byte__", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "publish$java_lang_String$byte__", throwable);
            throw throwable;
        }
    }

    private void __M_publish(String uri, byte[] message) {
        if (message == null) {
            LOGGER.warn("Cannot send websocket message on {}, the message is null", (Object)uri);
            return;
        }
        for (WebSocketDispatcher dispatcher : this.__getdispatchers()) {
            dispatcher.publish(uri, message);
        }
    }

    public void publish(String uri, JsonNode message) {
        if (!this.__Mpublish$java_lang_String$com_fasterxml_jackson_databind_JsonNode) {
            this.__M_publish(uri, message);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "publish$java_lang_String$com_fasterxml_jackson_databind_JsonNode", new Object[]{uri, message});
            this.__M_publish(uri, message);
            this.__IM.onExit((Object)this, "publish$java_lang_String$com_fasterxml_jackson_databind_JsonNode", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "publish$java_lang_String$com_fasterxml_jackson_databind_JsonNode", throwable);
            throw throwable;
        }
    }

    private void __M_publish(String uri, JsonNode message) {
        for (WebSocketDispatcher dispatcher : this.__getdispatchers()) {
            if (message == null) {
                dispatcher.publish(uri, NullNode.getInstance().toString());
                continue;
            }
            dispatcher.publish(uri, message.toString());
        }
    }

    public void send(String uri, String client, String message) {
        if (!this.__Msend$java_lang_String$java_lang_String$java_lang_String) {
            this.__M_send(uri, client, message);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "send$java_lang_String$java_lang_String$java_lang_String", new Object[]{uri, client, message});
            this.__M_send(uri, client, message);
            this.__IM.onExit((Object)this, "send$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "send$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_send(String uri, String client, String message) {
        if (message == null || client == null) {
            LOGGER.warn("Cannot send websocket message on {}, either the client id is null ({}) of the message is null ({})", new Object[]{uri, client, message});
            return;
        }
        for (WebSocketDispatcher dispatcher : this.__getdispatchers()) {
            dispatcher.send(uri, client, message);
        }
    }

    public void send(String uri, String client, JsonNode message) {
        if (!this.__Msend$java_lang_String$java_lang_String$com_fasterxml_jackson_databind_JsonNode) {
            this.__M_send(uri, client, message);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "send$java_lang_String$java_lang_String$com_fasterxml_jackson_databind_JsonNode", new Object[]{uri, client, message});
            this.__M_send(uri, client, message);
            this.__IM.onExit((Object)this, "send$java_lang_String$java_lang_String$com_fasterxml_jackson_databind_JsonNode", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "send$java_lang_String$java_lang_String$com_fasterxml_jackson_databind_JsonNode", throwable);
            throw throwable;
        }
    }

    private void __M_send(String uri, String client, JsonNode message) {
        for (WebSocketDispatcher dispatcher : this.__getdispatchers()) {
            if (message == null) {
                dispatcher.send(uri, client, NullNode.getInstance().toString());
                continue;
            }
            dispatcher.send(uri, client, message.toString());
        }
    }

    public void send(String uri, String client, byte[] message) {
        if (!this.__Msend$java_lang_String$java_lang_String$byte__) {
            this.__M_send(uri, client, message);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "send$java_lang_String$java_lang_String$byte__", new Object[]{uri, client, message});
            this.__M_send(uri, client, message);
            this.__IM.onExit((Object)this, "send$java_lang_String$java_lang_String$byte__", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "send$java_lang_String$java_lang_String$byte__", throwable);
            throw throwable;
        }
    }

    private void __M_send(String uri, String client, byte[] message) {
        if (message == null || client == null) {
            LOGGER.warn("Cannot send websocket message on {}, either the client id is null ({}) of the message is null ({})", new Object[]{uri, client, message});
            return;
        }
        for (WebSocketDispatcher dispatcher : this.__getdispatchers()) {
            dispatcher.send(uri, client, message);
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("closes")) {
                this.__Fcloses = true;
            }
            if (set.contains("contentEngine")) {
                this.__FcontentEngine = true;
            }
            if (set.contains("converter")) {
                this.__Fconverter = true;
            }
            if (set.contains("dispatchers")) {
                this.__Fdispatchers = true;
            }
            if (set.contains("executor")) {
                this.__Fexecutor = true;
            }
            if (set.contains("listeners")) {
                this.__Flisteners = true;
            }
            if (set.contains("opens")) {
                this.__Fopens = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("1___call")) {
                this.__M1___call = true;
            }
            if (set.contains("bindDispatcher$org_wisdom_api_http_websockets_WebSocketDispatcher")) {
                this.__MbindDispatcher$org_wisdom_api_http_websockets_WebSocketDispatcher = true;
            }
            if (set.contains("unbindDispatcher$org_wisdom_api_http_websockets_WebSocketDispatcher")) {
                this.__MunbindDispatcher$org_wisdom_api_http_websockets_WebSocketDispatcher = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("bindController$org_wisdom_api_Controller")) {
                this.__MbindController$org_wisdom_api_Controller = true;
            }
            if (set.contains("converter")) {
                this.__Mconverter = true;
            }
            if (set.contains("engine")) {
                this.__Mengine = true;
            }
            if (set.contains("analyze$org_wisdom_api_Controller")) {
                this.__Manalyze$org_wisdom_api_Controller = true;
            }
            if (set.contains("unbindController$org_wisdom_api_Controller")) {
                this.__MunbindController$org_wisdom_api_Controller = true;
            }
            if (set.contains("received$java_lang_String$java_lang_String$byte__")) {
                this.__Mreceived$java_lang_String$java_lang_String$byte__ = true;
            }
            if (set.contains("opened$java_lang_String$java_lang_String")) {
                this.__Mopened$java_lang_String$java_lang_String = true;
            }
            if (set.contains("closed$java_lang_String$java_lang_String")) {
                this.__Mclosed$java_lang_String$java_lang_String = true;
            }
            if (set.contains("publish$java_lang_String$java_lang_String")) {
                this.__Mpublish$java_lang_String$java_lang_String = true;
            }
            if (set.contains("publish$java_lang_String$byte__")) {
                this.__Mpublish$java_lang_String$byte__ = true;
            }
            if (set.contains("publish$java_lang_String$com_fasterxml_jackson_databind_JsonNode")) {
                this.__Mpublish$java_lang_String$com_fasterxml_jackson_databind_JsonNode = true;
            }
            if (set.contains("send$java_lang_String$java_lang_String$java_lang_String")) {
                this.__Msend$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("send$java_lang_String$java_lang_String$com_fasterxml_jackson_databind_JsonNode")) {
                this.__Msend$java_lang_String$java_lang_String$com_fasterxml_jackson_databind_JsonNode = true;
            }
            if (set.contains("send$java_lang_String$java_lang_String$byte__")) {
                this.__Msend$java_lang_String$java_lang_String$byte__ = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

