/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.Assignation;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.AssignationUtils;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionCache;
import org.thymeleaf.standard.expression.ExpressionSequence;
import org.thymeleaf.standard.expression.ExpressionSequenceUtils;
import org.thymeleaf.standard.expression.FragmentSelection;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.StandardExpressionPreprocessor;
import org.thymeleaf.standard.expression.TextLiteralExpression;
import org.thymeleaf.util.DOMUtils;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FragmentSelectionUtils {
    private static final String OPERATOR = "::";
    private static final String UNNAMED_PARAMETERS_PREFIX = "_arg";

    public static boolean hasSyntheticParameters(FragmentSelection fragmentSelection, Configuration configuration, IProcessingContext processingContext, StandardExpressionExecutionContext expContext) {
        if (!fragmentSelection.hasParameters()) {
            return false;
        }
        AssignationSequence fragmentSelectionParameters = fragmentSelection.getParameters();
        HashSet<String> variableNames = new HashSet<String>(fragmentSelectionParameters.size() + 2);
        for (Assignation assignation : fragmentSelectionParameters.getAssignations()) {
            IStandardExpression variableNameExpr = assignation.getLeft();
            Object variableNameValue = variableNameExpr.execute(configuration, processingContext, expContext);
            String variableName = variableNameValue == null ? null : variableNameValue.toString();
            variableNames.add(variableName);
        }
        return FragmentSelectionUtils.parameterNamesAreSynthetic(variableNames);
    }

    public static FragmentSelection parseFragmentSelection(Configuration configuration, IProcessingContext processingContext, String input) {
        FragmentSelection cachedFragmentSelection;
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(processingContext, "Processing Context cannot be null");
        Validate.notNull(input, "Input cannot be null");
        String preprocessedInput = StandardExpressionPreprocessor.preprocess(configuration, processingContext, input);
        if (configuration != null && (cachedFragmentSelection = ExpressionCache.getFragmentSelectionFromCache(configuration, preprocessedInput)) != null) {
            return cachedFragmentSelection;
        }
        FragmentSelection fragmentSelection = FragmentSelectionUtils.internalParseFragmentSelection(DOMUtils.unescapeXml(preprocessedInput.trim(), true));
        if (fragmentSelection == null) {
            throw new TemplateProcessingException("Could not parse as fragment selection: \"" + input + "\"");
        }
        if (configuration != null) {
            ExpressionCache.putFragmentSelectionIntoCache(configuration, preprocessedInput, fragmentSelection);
        }
        return fragmentSelection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static FragmentSelection internalParseFragmentSelection(String input) {
        Expression fragmentSpecExpression;
        Expression templateNameExpression;
        String fragmentSpecStr;
        String templateNameStr;
        String inputWithoutParameters;
        String parametersStr;
        if (StringUtils.isEmptyOrWhitespace(input)) {
            return null;
        }
        String trimmedInput = input.trim();
        int lastParenthesesGroupPos = FragmentSelectionUtils.indexOfLastParenthesesGroup(trimmedInput);
        if (lastParenthesesGroupPos != -1) {
            parametersStr = trimmedInput.substring(lastParenthesesGroupPos).trim();
            inputWithoutParameters = trimmedInput.substring(0, lastParenthesesGroupPos).trim();
        } else {
            parametersStr = null;
            inputWithoutParameters = trimmedInput;
        }
        int operatorPos = inputWithoutParameters.indexOf(OPERATOR);
        if (operatorPos == -1) {
            templateNameStr = inputWithoutParameters;
            fragmentSpecStr = null;
            if (StringUtils.isEmptyOrWhitespace(templateNameStr)) {
                if (parametersStr == null) return null;
                templateNameStr = parametersStr;
                parametersStr = null;
            }
        } else {
            templateNameStr = inputWithoutParameters.substring(0, operatorPos).trim();
            fragmentSpecStr = inputWithoutParameters.substring(operatorPos + OPERATOR.length()).trim();
            if (StringUtils.isEmptyOrWhitespace(fragmentSpecStr)) {
                if (parametersStr == null) return null;
                fragmentSpecStr = parametersStr;
                parametersStr = null;
            }
        }
        if (!StringUtils.isEmptyOrWhitespace(templateNameStr)) {
            templateNameExpression = FragmentSelectionUtils.parseDefaultAsLiteral(templateNameStr);
            if (templateNameExpression == null) {
                return null;
            }
        } else {
            templateNameExpression = null;
        }
        if (!StringUtils.isEmptyOrWhitespace(fragmentSpecStr)) {
            fragmentSpecExpression = FragmentSelectionUtils.parseDefaultAsLiteral(fragmentSpecStr);
            if (fragmentSpecExpression == null) {
                return null;
            }
        } else {
            fragmentSpecExpression = null;
        }
        if (StringUtils.isEmptyOrWhitespace(parametersStr)) return new FragmentSelection(templateNameExpression, fragmentSpecExpression, null);
        AssignationSequence parametersAsSeq = AssignationUtils.internalParseAssignationSequence(parametersStr, false);
        if (parametersAsSeq != null) {
            return new FragmentSelection(templateNameExpression, fragmentSpecExpression, parametersAsSeq);
        }
        ExpressionSequence parametersExpSeq = ExpressionSequenceUtils.internalParseExpressionSequence(parametersStr);
        if (parametersExpSeq == null) return null;
        AssignationSequence parametersAsSeqFromExp = FragmentSelectionUtils.createSyntheticallyNamedParameterSequence(parametersExpSeq);
        return new FragmentSelection(templateNameExpression, fragmentSpecExpression, parametersAsSeqFromExp);
    }

    private static Expression parseDefaultAsLiteral(String input) {
        if (StringUtils.isEmptyOrWhitespace(input)) {
            return null;
        }
        Expression expr = Expression.parse(input);
        if (expr == null) {
            return Expression.parse(TextLiteralExpression.wrapStringIntoLiteral(input));
        }
        return expr;
    }

    private static int indexOfLastParenthesesGroup(String input) {
        int inputLen = input.length();
        char finalC = input.charAt(inputLen - 1);
        if (finalC != ')') {
            return -1;
        }
        int parenLevel = 1;
        for (int i = inputLen - 2; i >= 0; --i) {
            char c = input.charAt(i);
            if (c == '(') {
                if (--parenLevel != 0) continue;
                if (i == inputLen - 2) {
                    return -1;
                }
                return i;
            }
            if (c != ')') continue;
            ++parenLevel;
        }
        return -1;
    }

    public static boolean parameterNamesAreSynthetic(Set<String> parameterNames) {
        Validate.notNull(parameterNames, "Parameter names set cannot be null");
        for (String parameterName : parameterNames) {
            if (parameterName == null) {
                return false;
            }
            if (!parameterName.startsWith(UNNAMED_PARAMETERS_PREFIX)) {
                return false;
            }
            int parameterNameLen = parameterName.length();
            for (int i = UNNAMED_PARAMETERS_PREFIX.length(); i < parameterNameLen; ++i) {
                char c = parameterName.charAt(i);
                if (Character.isDigit(c)) continue;
                return false;
            }
        }
        return true;
    }

    static String getSyntheticParameterNameForIndex(int i) {
        return UNNAMED_PARAMETERS_PREFIX + i;
    }

    private static AssignationSequence createSyntheticallyNamedParameterSequence(ExpressionSequence expSeq) {
        ArrayList<Assignation> assignations = new ArrayList<Assignation>(expSeq.size() + 2);
        int argIndex = 0;
        for (IStandardExpression expression : expSeq.getExpressions()) {
            Expression parameterName = Expression.parse(TextLiteralExpression.wrapStringIntoLiteral(UNNAMED_PARAMETERS_PREFIX + argIndex++));
            assignations.add(new Assignation(parameterName, expression));
        }
        return new AssignationSequence(assignations);
    }

    private FragmentSelectionUtils() {
    }
}

