/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templatewriter;

import java.io.IOException;
import java.io.Writer;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.Attribute;
import org.thymeleaf.dom.CDATASection;
import org.thymeleaf.dom.Comment;
import org.thymeleaf.dom.DocType;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.GroupNode;
import org.thymeleaf.dom.Macro;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;
import org.thymeleaf.templatewriter.ITemplateWriter;
import org.thymeleaf.util.DOMUtils;
import org.thymeleaf.util.Validate;

public abstract class AbstractGeneralTemplateWriter
implements ITemplateWriter {
    private static final char[] COMMENT_PREFIX = "<!--".toCharArray();
    private static final char[] COMMENT_SUFFIX = "-->".toCharArray();
    private static final char[] CDATA_PREFIX = "<![CDATA[".toCharArray();
    private static final char[] CDATA_SUFFIX = "]]>".toCharArray();
    private static final char[] XML_DECLARATION_PREFIX = "<?xml version=\"1.0\"".toCharArray();
    private static final char[] XML_DECLARATION_SUFFIX = "?>\n".toCharArray();

    protected AbstractGeneralTemplateWriter() {
    }

    public void write(Arguments arguments, Writer writer, Document document) throws IOException {
        if (document == null) {
            return;
        }
        this.writeDocument(arguments, writer, document);
    }

    protected abstract boolean shouldWriteXmlDeclaration();

    protected abstract boolean useXhtmlTagMinimizationRules();

    protected void writeDocument(Arguments arguments, Writer writer, Document document) throws IOException {
        if (this.shouldWriteXmlDeclaration()) {
            this.writeXmlDeclaration(writer, document);
        }
        if (document.hasDocType()) {
            this.writeDocType(arguments, writer, document.getDocType());
            writer.write(10);
        }
        if (document.hasChildren()) {
            Node[] children = document.unsafeGetChildrenNodeArray();
            int childrenLen = document.numChildren();
            for (int i = 0; i < childrenLen; ++i) {
                this.writeNode(arguments, writer, children[i]);
            }
        }
    }

    protected void writeXmlDeclaration(Writer writer, Document document) throws IOException {
        Boolean xmlStandalone;
        String xmlEncoding;
        writer.write(XML_DECLARATION_PREFIX);
        if (document.hasNodeProperty("XML_ENCODING") && (xmlEncoding = (String)document.getNodeProperty("XML_ENCODING")) != null) {
            writer.write(" encoding=\"");
            writer.write(xmlEncoding);
            writer.write("\"");
        }
        if (document.hasNodeProperty("XML_STANDALONE") && (xmlStandalone = (Boolean)document.getNodeProperty("XML_STANDALONE")) != null && xmlStandalone.booleanValue()) {
            writer.write(" standalone=\"true\"");
        }
        writer.write(XML_DECLARATION_SUFFIX);
    }

    protected void writeDocType(Arguments arguments, Writer writer, DocType docType) throws IOException {
        docType.write(writer);
    }

    public void writeNode(Arguments arguments, Writer writer, Node node) throws IOException {
        Validate.notNull(arguments, "Arguments cannot be null");
        if (node == null) {
            return;
        }
        if (node instanceof Element) {
            this.writeElement(arguments, writer, (Element)node);
        } else if (node instanceof GroupNode) {
            this.writeGroupNode(arguments, writer, (GroupNode)node);
        } else if (node instanceof Text) {
            this.writeText(arguments, writer, (Text)node);
        } else if (node instanceof Comment) {
            this.writeComment(arguments, writer, (Comment)node);
        } else if (node instanceof CDATASection) {
            this.writeCDATASection(arguments, writer, (CDATASection)node);
        } else if (node instanceof Macro) {
            this.writeMacro(arguments, writer, (Macro)node);
        } else if (node instanceof Document) {
            this.writeDocument(arguments, writer, (Document)node);
        } else {
            throw new IllegalStateException("Cannot write node of class \"" + node.getClass().getName());
        }
    }

    protected void writeGroupNode(Arguments arguments, Writer writer, GroupNode groupNode) throws IOException {
        if (groupNode.hasChildren()) {
            Node[] children = groupNode.unsafeGetChildrenNodeArray();
            int childrenLen = groupNode.numChildren();
            for (int i = 0; i < childrenLen; ++i) {
                this.writeNode(arguments, writer, children[i]);
            }
        }
    }

    protected void writeElement(Arguments arguments, Writer writer, Element element) throws IOException {
        int i;
        writer.write(60);
        writer.write(element.getOriginalName());
        if (element.hasAttributes()) {
            Configuration configuration = arguments.getConfiguration();
            Attribute[] attributes = element.unsafeGetAttributes();
            int attributesLen = element.numAttributes();
            for (i = 0; i < attributesLen; ++i) {
                String xmlnsPrefix;
                Attribute attribute = attributes[i];
                boolean writeAttribute = true;
                if (attribute.getNormalizedName().startsWith("xmlns:") && configuration.isPrefixManaged(xmlnsPrefix = attribute.getNormalizedName().substring("xmlns:".length()))) {
                    writeAttribute = false;
                }
                if (!writeAttribute) continue;
                writer.write(32);
                writer.write(attribute.getOriginalName());
                String attrValue = attribute.getValue();
                if (attrValue == null && attribute.isOnlyName()) continue;
                writer.write(61);
                writer.write(34);
                if (attrValue != null) {
                    writer.write(DOMUtils.escapeXml(attrValue, true));
                }
                writer.write(34);
            }
        }
        Element.RepresentationInTemplate representationInTemplate = element.getRepresentationInTemplate();
        if (element.hasChildren()) {
            writer.write(62);
            Node[] children = element.unsafeGetChildrenNodeArray();
            int childrenLen = element.numChildren();
            for (i = 0; i < childrenLen; ++i) {
                this.writeNode(arguments, writer, children[i]);
            }
            if (representationInTemplate != Element.RepresentationInTemplate.ONLY_OPEN) {
                writer.write(60);
                writer.write(47);
                writer.write(element.getOriginalName());
                writer.write(62);
            }
        } else if (representationInTemplate == null || representationInTemplate == Element.RepresentationInTemplate.OPEN_AND_CLOSE_NONEMPTY) {
            if (this.useXhtmlTagMinimizationRules()) {
                if (element.isMinimizableIfWeb()) {
                    writer.write(32);
                    writer.write(47);
                    writer.write(62);
                } else {
                    writer.write(62);
                    writer.write(60);
                    writer.write(47);
                    writer.write(element.getOriginalName());
                    writer.write(62);
                }
            } else {
                writer.write(47);
                writer.write(62);
            }
        } else if (representationInTemplate == Element.RepresentationInTemplate.OPEN_AND_CLOSE_EMPTY) {
            writer.write(62);
            writer.write(60);
            writer.write(47);
            writer.write(element.getOriginalName());
            writer.write(62);
        } else if (representationInTemplate == Element.RepresentationInTemplate.STANDALONE) {
            if (this.useXhtmlTagMinimizationRules()) {
                writer.write(32);
            }
            writer.write(47);
            writer.write(62);
        } else if (representationInTemplate == Element.RepresentationInTemplate.ONLY_OPEN) {
            writer.write(62);
        }
    }

    protected void writeCDATASection(Arguments arguments, Writer writer, CDATASection cdataSection) throws IOException {
        writer.write(CDATA_PREFIX);
        writer.write(cdataSection.getContent());
        writer.write(CDATA_SUFFIX);
    }

    protected void writeComment(Arguments arguments, Writer writer, Comment comment) throws IOException {
        writer.write(COMMENT_PREFIX);
        writer.write(comment.getContent());
        writer.write(COMMENT_SUFFIX);
    }

    protected void writeText(Arguments arguments, Writer writer, Text text) throws IOException {
        writer.write(text.getContent());
    }

    protected void writeMacro(Arguments arguments, Writer writer, Macro macro) throws IOException {
        writer.write(macro.getContent());
    }
}

