/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.template.thymeleaf.dialect;

import java.util.HashMap;
import java.util.Map;
import ognl.ClassResolver;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.IStandardConversionService;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.OgnlVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.wisdom.api.http.Context;

public class ExtendedOGNLExpressionEvaluator
implements IStandardVariableExpressionEvaluator {
    public static final ExtendedOGNLExpressionEvaluator INSTANCE = new ExtendedOGNLExpressionEvaluator();
    private static final Logger LOGGER = LoggerFactory.getLogger(OgnlVariableExpressionEvaluator.class);
    private static final String OGNL_CACHE_PREFIX = "{ognl}";
    public static final String BUNDLE_VAR_KEY = "__bundle__";

    protected Map<String, Object> computeAdditionalContextVariables(IProcessingContext processingContext) {
        HashMap<String, Object> var = new HashMap<String, Object>();
        var.put("routes", processingContext.getContext().getVariables().get("__routes__"));
        Context context = (Context)Context.CONTEXT.get();
        if (context != null) {
            var.put("http", context);
            var.put("session", context.session());
            var.put("flash", context.flash());
            var.put("request", context.request());
            var.put("parameters", context.parameters());
        }
        return var;
    }

    public String toString() {
        return "OGNL extended by Wisdom";
    }

    @Override
    public final Object evaluate(Configuration configuration, IProcessingContext processingContext, String expression, StandardExpressionExecutionContext expContext, boolean useSelectionAsRoot) {
        try {
            Object evaluationRoot;
            ICacheManager cacheManager;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("OGNL expression: evaluating expression \"{}\" on target", (Object)expression);
            }
            Object expressionTree = null;
            ICache<String, Object> cache = null;
            if (configuration != null && (cacheManager = configuration.getCacheManager()) != null) {
                cache = cacheManager.getExpressionCache();
            }
            if (cache != null) {
                expressionTree = cache.get(OGNL_CACHE_PREFIX + expression);
            }
            if (expressionTree == null) {
                expressionTree = Ognl.parseExpression(expression);
                if (cache != null && null != expressionTree) {
                    cache.put(OGNL_CACHE_PREFIX + expression, expressionTree);
                }
            }
            OgnlContext ctxt = new OgnlContext();
            ctxt.putAll(processingContext.getExpressionObjects());
            Map<String, Object> additionalContextVariables = this.computeAdditionalContextVariables(processingContext);
            if (additionalContextVariables != null) {
                ctxt.putAll(additionalContextVariables);
            }
            Object object = evaluationRoot = useSelectionAsRoot ? processingContext.getExpressionSelectionEvaluationRoot() : processingContext.getExpressionEvaluationRoot();
            if (ctxt.get("vars") instanceof Map && ((Map)ctxt.get("vars")).containsKey(BUNDLE_VAR_KEY)) {
                final Bundle bundle = (Bundle)((Map)ctxt.get("vars")).get(BUNDLE_VAR_KEY);
                Ognl.setClassResolver(ctxt, new ClassResolver(){

                    @Override
                    public Class classForName(String className, Map context) throws ClassNotFoundException {
                        try {
                            return bundle.loadClass(className);
                        }
                        catch (ClassNotFoundException e) {
                            if (bundle.getBundleId() != 0L) {
                                try {
                                    return bundle.getBundleContext().getBundle(0L).loadClass(className);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    // empty catch block
                                }
                            }
                            LOGGER.warn("A template tried to load the '" + className + "' class, " + "but this class is not available. Try to import it in the bundle containing the " + "template.");
                            throw new ClassNotFoundException(className);
                        }
                    }
                });
            }
            Object result = Ognl.getValue(expressionTree, (Map)ctxt, evaluationRoot);
            if (!expContext.getPerformTypeConversion()) {
                return result;
            }
            IStandardConversionService conversionService = StandardExpressions.getConversionService(configuration);
            return conversionService.convert(configuration, processingContext, result, String.class);
        }
        catch (OgnlException e) {
            throw new TemplateProcessingException("Exception evaluating OGNL expression: \"" + expression + "\"", e);
        }
    }
}

