/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.template.thymeleaf.dialect;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.wisdom.api.Controller;
import org.wisdom.api.asset.Asset;
import org.wisdom.api.asset.Assets;
import org.wisdom.api.router.Router;

public class Routes {
    public static final String ROUTES_VAR = "__routes__";
    public static final String OBJECT_NAME = "routes";
    public static final String ERR_FIND_ROUTE = "Cannot find the reverse route for ";
    public static final String WITH_PARAM = " with params : ";
    private final Router router;
    private final Assets assets;
    private final Controller controller;

    public Routes(Router router, Assets assets, Controller controller) {
        this.router = router;
        this.controller = controller;
        this.assets = assets;
    }

    public String route(String controllerClass, String method) {
        String route = this.router.getReverseRouteFor(controllerClass, method);
        if (route == null) {
            throw new TemplateProcessingException(ERR_FIND_ROUTE + controllerClass + "#" + method);
        }
        return route;
    }

    public String route(String method) {
        String route = this.router.getReverseRouteFor(this.controller, method);
        if (route == null) {
            throw new TemplateProcessingException(ERR_FIND_ROUTE + this.controller.getClass().getName() + "#" + method);
        }
        return route;
    }

    public String route(String controllerClass, String method, String var1, Object value1) {
        ImmutableMap params = ImmutableMap.of((Object)var1, (Object)value1);
        String route = this.router.getReverseRouteFor(controllerClass, method, (Map)params);
        if (route == null) {
            throw new TemplateProcessingException(ERR_FIND_ROUTE + this.controller.getClass().getName() + "#" + method + WITH_PARAM + params);
        }
        return route;
    }

    public String route(String controllerClass, String method, String var1, Object value1, String var2, Object value2) {
        ImmutableMap params = ImmutableMap.of((Object)var1, (Object)value1, (Object)var2, (Object)value2);
        String route = this.router.getReverseRouteFor(controllerClass, method, (Map)params);
        if (route == null) {
            throw new TemplateProcessingException(ERR_FIND_ROUTE + this.controller.getClass().getName() + "#" + method + WITH_PARAM + params);
        }
        return route;
    }

    public String route(String controllerClass, String method, String var1, Object value1, String var2, Object value2, String var3, Object value3) {
        ImmutableMap params = ImmutableMap.of((Object)var1, (Object)value1, (Object)var2, (Object)value2, (Object)var3, (Object)value3);
        String route = this.router.getReverseRouteFor(controllerClass, method, (Map)params);
        if (route == null) {
            throw new TemplateProcessingException(ERR_FIND_ROUTE + this.controller.getClass().getName() + "#" + method + WITH_PARAM + params);
        }
        return route;
    }

    public String route(String controllerClass, String method, String var1, Object value1, String var2, Object value2, String var3, Object value3, String var4, Object value4) {
        ImmutableMap params = ImmutableMap.of((Object)var1, (Object)value1, (Object)var2, (Object)value2, (Object)var3, (Object)value3, (Object)var4, (Object)value4);
        String route = this.router.getReverseRouteFor(controllerClass, method, (Map)params);
        if (route == null) {
            throw new TemplateProcessingException(ERR_FIND_ROUTE + this.controller.getClass().getName() + "#" + method + WITH_PARAM + params);
        }
        return route;
    }

    public String route(String controllerClass, String method, String var1, Object value1, String var2, Object value2, String var3, Object value3, String var4, Object value4, String var5, Object value5) {
        ImmutableMap params = ImmutableMap.of((Object)var1, (Object)value1, (Object)var2, (Object)value2, (Object)var3, (Object)value3, (Object)var4, (Object)value4, (Object)var5, (Object)value5);
        String route = this.router.getReverseRouteFor(controllerClass, method, (Map)params);
        if (route == null) {
            throw new TemplateProcessingException(ERR_FIND_ROUTE + this.controller.getClass().getName() + "#" + method + WITH_PARAM + params);
        }
        return route;
    }

    public String route(String method, String var1, Object value1) {
        return this.route(this.controller.getClass().getName(), method, var1, value1);
    }

    public String route(String method, String var1, Object value1, String var2, Object value2) {
        return this.route(this.controller.getClass().getName(), method, var1, value1, var2, value2);
    }

    public String route(String method, String var1, Object value1, String var2, Object value2, String var3, Object value3) {
        return this.route(this.controller.getClass().getName(), method, var1, value1, var2, value2, var3, value3);
    }

    public String route(String method, String var1, Object value1, String var2, Object value2, String var3, Object value3, String var4, Object value4) {
        return this.route(this.controller.getClass().getName(), method, var1, value1, var2, value2, var3, value3, var4, value4);
    }

    public String route(String method, String var1, Object value1, String var2, Object value2, String var3, Object value3, String var4, Object value4, String var5, Object value5) {
        return this.route(this.controller.getClass().getName(), method, var1, value1, var2, value2, var3, value3, var4, value4, var5, value5);
    }

    public String asset(String path) {
        Asset asset = this.assets.assetAt(path);
        if (asset == null) {
            if (path.startsWith("/")) {
                return this.asset(path.substring(1));
            }
            throw new TemplateProcessingException("Cannot find the URL of the asset " + path);
        }
        return asset.getPath();
    }
}

