/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.template.thymeleaf.impl;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nz.net.ultraq.thymeleaf.LayoutDialect;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.wisdom.api.Controller;
import org.wisdom.api.asset.Assets;
import org.wisdom.api.bodies.RenderableString;
import org.wisdom.api.http.Context;
import org.wisdom.api.router.Router;
import org.wisdom.api.templates.Template;
import org.wisdom.template.thymeleaf.dialect.Routes;
import org.wisdom.template.thymeleaf.dialect.WisdomStandardDialect;

public class WisdomTemplateEngine
extends TemplateEngine {
    public WisdomTemplateEngine(Set<IDialect> dialects) {
        this.clearDialects();
        this.addDialect(new WisdomStandardDialect());
        this.addDialect(new LayoutDialect());
        if (dialects != null) {
            this.setAdditionalDialects(dialects);
        }
    }

    public RenderableString process(Template template, Controller controller, Router router, Assets assets, Map<String, Object> variables) {
        org.thymeleaf.context.Context ctx = new org.thymeleaf.context.Context();
        Context http = (Context)Context.CONTEXT.get();
        ctx.setVariables(http.session().getData());
        ctx.setVariables(http.flash().getCurrentFlashCookieData());
        ctx.setVariables(http.flash().getOutgoingFlashCookieData());
        for (Map.Entry entry : http.parameters().entrySet()) {
            if (((List)entry.getValue()).size() == 1) {
                ctx.setVariable((String)entry.getKey(), ((List)entry.getValue()).get(0));
                continue;
            }
            ctx.setVariable((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : http.request().data().entrySet()) {
            ctx.setVariable((String)entry.getKey(), entry.getValue());
        }
        ctx.setVariables(variables);
        ctx.setVariable("__routes__", new Routes(router, assets, controller));
        StringWriter writer = new StringWriter();
        try {
            this.process(template.fullName(), (IContext)ctx, (Writer)writer);
        }
        catch (TemplateProcessingException e) {
            if (e.getCause() != null && e.getCause().getCause() != null) {
                throw new TemplateProcessingException(e.getCause().getCause().getMessage(), e.getTemplateName(), e.getLineNumber(), e.getCause().getCause());
            }
            throw e;
        }
        return new RenderableString((Object)writer, "text/html");
    }
}

