/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.template.thymeleaf.tracker;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Context;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.BundleContext;
import org.ow2.chameleon.core.services.AbstractDeployer;
import org.ow2.chameleon.core.services.Deployer;
import org.ow2.chameleon.core.services.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.api.configuration.ApplicationConfiguration;
import org.wisdom.template.thymeleaf.ThymeleafTemplateCollector;

@Component
@Provides
@Instantiate
public class TemplateDeployer
extends AbstractDeployer
implements Deployer,
Pojo {
    InstanceManager __IM;
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateDeployer.class);
    private boolean __Fengine;
    @Requires
    ThymeleafTemplateCollector engine;
    private boolean __Fwatcher;
    @Requires
    Watcher watcher;
    private boolean __Fconfiguration;
    @Requires
    ApplicationConfiguration configuration;
    private boolean __Fdirectory;
    private File directory;
    private boolean __Fcontext;
    @Context
    BundleContext context;
    boolean __Mstart;
    boolean __Mstop;
    boolean __Maccept$java_io_File;
    boolean __MonFileCreate$java_io_File;
    boolean __MonFileChange$java_io_File;
    boolean __MonFileDelete$java_io_File;

    ThymeleafTemplateCollector __getengine() {
        if (!this.__Fengine) {
            return this.engine;
        }
        return (ThymeleafTemplateCollector)this.__IM.onGet((Object)this, "engine");
    }

    void __setengine(ThymeleafTemplateCollector thymeleafTemplateCollector) {
        if (!this.__Fengine) {
            this.engine = thymeleafTemplateCollector;
            return;
        }
        this.__IM.onSet((Object)this, "engine", (Object)thymeleafTemplateCollector);
    }

    Watcher __getwatcher() {
        if (!this.__Fwatcher) {
            return this.watcher;
        }
        return (Watcher)this.__IM.onGet((Object)this, "watcher");
    }

    void __setwatcher(Watcher watcher) {
        if (!this.__Fwatcher) {
            this.watcher = watcher;
            return;
        }
        this.__IM.onSet((Object)this, "watcher", (Object)watcher);
    }

    ApplicationConfiguration __getconfiguration() {
        if (!this.__Fconfiguration) {
            return this.configuration;
        }
        return (ApplicationConfiguration)this.__IM.onGet((Object)this, "configuration");
    }

    void __setconfiguration(ApplicationConfiguration applicationConfiguration) {
        if (!this.__Fconfiguration) {
            this.configuration = applicationConfiguration;
            return;
        }
        this.__IM.onSet((Object)this, "configuration", (Object)applicationConfiguration);
    }

    File __getdirectory() {
        if (!this.__Fdirectory) {
            return this.directory;
        }
        return (File)this.__IM.onGet((Object)this, "directory");
    }

    void __setdirectory(File file) {
        if (!this.__Fdirectory) {
            this.directory = file;
            return;
        }
        this.__IM.onSet((Object)this, "directory", (Object)file);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    public TemplateDeployer() {
        this(null);
    }

    private TemplateDeployer(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        LOGGER.info("Starting thymeleaf template deployer");
        this.__setdirectory(this.__getconfiguration().getFileWithDefault("application.template.directory", "templates"));
        if (!this.__getdirectory().isDirectory()) {
            LOGGER.info("Creating the template directory : {}", (Object)this.__getdirectory().getAbsolutePath());
            this.__getdirectory().mkdirs();
        }
        LOGGER.info("Template directory set to {}", (Object)this.__getdirectory().getAbsolutePath());
        this.__getwatcher().add(new File(this.__getconfiguration().getBaseDir(), "templates"), true);
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        try {
            this.__getwatcher().removeAndStopIfNeeded(this.__getdirectory());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public boolean accept(File file) {
        boolean bl;
        if (!this.__Maccept$java_io_File) {
            return this.__M_accept(file);
        }
        try {
            this.__IM.onEntry((Object)this, "accept$java_io_File", new Object[]{file});
            bl = this.__M_accept(file);
            this.__IM.onExit((Object)this, "accept$java_io_File", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "accept$java_io_File", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_accept(File file) {
        return file.getName().endsWith(this.__getengine().extension());
    }

    public void onFileCreate(File file) {
        if (!this.__MonFileCreate$java_io_File) {
            this.__M_onFileCreate(file);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "onFileCreate$java_io_File", new Object[]{file});
            this.__M_onFileCreate(file);
            this.__IM.onExit((Object)this, "onFileCreate$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "onFileCreate$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __M_onFileCreate(File file) {
        try {
            this.__getengine().addTemplate(this.__getcontext().getBundle(0L), file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            LOGGER.error("Cannot compute the url of file {}", (Object)file.getAbsolutePath(), (Object)e);
        }
    }

    public void onFileChange(File file) {
        if (!this.__MonFileChange$java_io_File) {
            this.__M_onFileChange(file);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "onFileChange$java_io_File", new Object[]{file});
            this.__M_onFileChange(file);
            this.__IM.onExit((Object)this, "onFileChange$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "onFileChange$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __M_onFileChange(File file) {
        this.__getengine().updatedTemplate(this.__getcontext().getBundle(0L), file);
    }

    public void onFileDelete(File file) {
        if (!this.__MonFileDelete$java_io_File) {
            this.__M_onFileDelete(file);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "onFileDelete$java_io_File", new Object[]{file});
            this.__M_onFileDelete(file);
            this.__IM.onExit((Object)this, "onFileDelete$java_io_File", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "onFileDelete$java_io_File", throwable);
            throw throwable;
        }
    }

    private void __M_onFileDelete(File file) {
        this.__getengine().deleteTemplate(file);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("configuration")) {
                this.__Fconfiguration = true;
            }
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("directory")) {
                this.__Fdirectory = true;
            }
            if (set.contains("engine")) {
                this.__Fengine = true;
            }
            if (set.contains("watcher")) {
                this.__Fwatcher = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("accept$java_io_File")) {
                this.__Maccept$java_io_File = true;
            }
            if (set.contains("onFileCreate$java_io_File")) {
                this.__MonFileCreate$java_io_File = true;
            }
            if (set.contains("onFileChange$java_io_File")) {
                this.__MonFileChange$java_io_File = true;
            }
            if (set.contains("onFileDelete$java_io_File")) {
                this.__MonFileDelete$java_io_File = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

