/*
 * Decompiled with CFR 0.152.
 */
package org.wisdom.template.thymeleaf.tracker;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Context;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wisdom.template.thymeleaf.ThymeleafTemplateCollector;
import org.wisdom.template.thymeleaf.impl.ThymeLeafTemplateImplementation;

@Component
@Provides
@Instantiate
public class TemplateTracker
implements BundleTrackerCustomizer<List<ThymeLeafTemplateImplementation>> {
    InstanceManager __IM;
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateTracker.class);
    private boolean __Fengine;
    @Requires(proxy=false)
    ThymeleafTemplateCollector engine;
    private boolean __Fcontext;
    @Context
    BundleContext context;
    private static final String TEMPLATE_DIRECTORY_IN_BUNDLES = "/templates";
    private boolean __Ftracker;
    private BundleTracker<List<ThymeLeafTemplateImplementation>> tracker;
    boolean __Mstart;
    boolean __Mstop;
    boolean __MaddingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent;
    boolean __MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List;
    boolean __MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List;
    boolean __MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object;
    boolean __MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object;

    ThymeleafTemplateCollector __getengine() {
        if (!this.__Fengine) {
            return this.engine;
        }
        return (ThymeleafTemplateCollector)this.__IM.onGet((Object)this, "engine");
    }

    void __setengine(ThymeleafTemplateCollector thymeleafTemplateCollector) {
        if (!this.__Fengine) {
            this.engine = thymeleafTemplateCollector;
            return;
        }
        this.__IM.onSet((Object)this, "engine", (Object)thymeleafTemplateCollector);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    BundleTracker __gettracker() {
        if (!this.__Ftracker) {
            return this.tracker;
        }
        return (BundleTracker)this.__IM.onGet((Object)this, "tracker");
    }

    void __settracker(BundleTracker bundleTracker) {
        if (!this.__Ftracker) {
            this.tracker = bundleTracker;
            return;
        }
        this.__IM.onSet((Object)this, "tracker", (Object)bundleTracker);
    }

    public TemplateTracker() {
        this(null);
    }

    private TemplateTracker(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_start() {
        LOGGER.info("Starting Thymeleaf template tracker");
        this.__settracker(new BundleTracker(this.__getcontext(), 32, (BundleTrackerCustomizer)this));
        this.__gettracker().open();
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() {
        try {
            if (this.__gettracker() != null) {
                this.__gettracker().close();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public List<ThymeLeafTemplateImplementation> addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        Object object;
        if (!this.__MaddingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent) {
            return this.__M_addingBundle(bundle, bundleEvent);
        }
        try {
            this.__IM.onEntry((Object)this, "addingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent", new Object[]{bundle, bundleEvent});
            object = this.__M_addingBundle(bundle, bundleEvent);
            this.__IM.onExit((Object)this, "addingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent", throwable);
            throw throwable;
        }
        return object;
    }

    private List<ThymeLeafTemplateImplementation> __M_addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        ArrayList<ThymeLeafTemplateImplementation> list = new ArrayList<ThymeLeafTemplateImplementation>();
        Enumeration urls = bundle.findEntries(TEMPLATE_DIRECTORY_IN_BUNDLES, "*.html", true);
        if (urls == null) {
            return list;
        }
        while (urls.hasMoreElements()) {
            URL url = (URL)urls.nextElement();
            if (!url.toExternalForm().endsWith(this.__getengine().extension())) continue;
            ThymeLeafTemplateImplementation template = this.__getengine().addTemplate(bundle, url);
            list.add(template);
        }
        return list;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, List<ThymeLeafTemplateImplementation> o) {
        if (!this.__MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List) {
            this.__M_modifiedBundle(bundle, bundleEvent, o);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List", new Object[]{bundle, bundleEvent, o});
            this.__M_modifiedBundle(bundle, bundleEvent, o);
            this.__IM.onExit((Object)this, "modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List", throwable);
            throw throwable;
        }
    }

    private void __M_modifiedBundle(Bundle bundle, BundleEvent bundleEvent, List<ThymeLeafTemplateImplementation> o) {
        for (ThymeLeafTemplateImplementation template : o) {
            this.__getengine().updatedTemplate();
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, List<ThymeLeafTemplateImplementation> o) {
        if (!this.__MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List) {
            this.__M_removedBundle(bundle, bundleEvent, o);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List", new Object[]{bundle, bundleEvent, o});
            this.__M_removedBundle(bundle, bundleEvent, o);
            this.__IM.onExit((Object)this, "removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List", throwable);
            throw throwable;
        }
    }

    private void __M_removedBundle(Bundle bundle, BundleEvent bundleEvent, List<ThymeLeafTemplateImplementation> o) {
        for (ThymeLeafTemplateImplementation template : o) {
            LOGGER.info("Thymeleaf template deleted for {} from {}", (Object)template.fullName(), (Object)bundle.getSymbolicName());
            if (this.__getengine() == null) continue;
            this.__getengine().deleteTemplate(template);
        }
    }

    private void __M_removedBundle(Bundle bundle, BundleEvent bundleEvent, Object object) {
        this.removedBundle(bundle, bundleEvent, (List)object);
    }

    private void __M_modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Object object) {
        this.modifiedBundle(bundle, bundleEvent, (List)object);
    }

    private Object __M_addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        return this.addingBundle(bundle, bundleEvent);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("engine")) {
                this.__Fengine = true;
            }
            if (set.contains("tracker")) {
                this.__Ftracker = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("addingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent")) {
                this.__MaddingBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent = true;
            }
            if (set.contains("modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List")) {
                this.__MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List = true;
            }
            if (set.contains("removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List")) {
                this.__MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_util_List = true;
            }
            if (set.contains("removedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object")) {
                this.__MremovedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object = true;
            }
            if (set.contains("modifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object")) {
                this.__MmodifiedBundle$org_osgi_framework_Bundle$org_osgi_framework_BundleEvent$java_lang_Object = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

